/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.generator;

import com.regnosys.rosetta.config.RosettaGeneratorsConfiguration;
import com.regnosys.rosetta.generator.AggregateGenerationException;
import com.regnosys.rosetta.generator.GenerationException;
import com.regnosys.rosetta.generator.external.ExternalGenerator;
import com.regnosys.rosetta.generator.external.ExternalGenerators;
import com.regnosys.rosetta.generator.java.JavaClassGenerator;
import com.regnosys.rosetta.generator.java.condition.ConditionGenerator;
import com.regnosys.rosetta.generator.java.enums.EnumGenerator;
import com.regnosys.rosetta.generator.java.expression.DeepPathUtilGenerator;
import com.regnosys.rosetta.generator.java.function.FunctionGenerator;
import com.regnosys.rosetta.generator.java.function.LabelProviderGenerator;
import com.regnosys.rosetta.generator.java.object.JavaPackageInfoGenerator;
import com.regnosys.rosetta.generator.java.object.MetaFieldGenerator;
import com.regnosys.rosetta.generator.java.object.ModelMetaGenerator;
import com.regnosys.rosetta.generator.java.object.ModelObjectGenerator;
import com.regnosys.rosetta.generator.java.object.validators.CardinalityValidatorGenerator;
import com.regnosys.rosetta.generator.java.object.validators.OnlyExistsValidatorGenerator;
import com.regnosys.rosetta.generator.java.object.validators.TypeFormatValidatorGenerator;
import com.regnosys.rosetta.generator.java.reports.ReportGenerator;
import com.regnosys.rosetta.generator.java.reports.RuleGenerator;
import com.regnosys.rosetta.generator.resourcefsa.ResourceAwareFSAFactory;
import com.regnosys.rosetta.rosetta.RosettaModel;
import com.rosetta.util.DemandableLock;
import jakarta.inject.Inject;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.function.Consumer;
import java.util.function.Function;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtext.generator.IFileSystemAccess2;
import org.eclipse.xtext.generator.IGenerator2;
import org.eclipse.xtext.generator.IGeneratorContext;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RosettaGenerator
implements IGenerator2 {
    private static Logger LOGGER = LoggerFactory.getLogger(RosettaGenerator.class);
    @Inject
    private EnumGenerator enumGenerator;
    @Inject
    private ModelMetaGenerator metaGenerator;
    @Inject
    private ConditionGenerator conditionGenerator;
    @Inject
    private MetaFieldGenerator metaFieldGenerator;
    @Inject
    private ExternalGenerators externalGenerators;
    @Inject
    private JavaPackageInfoGenerator javaPackageInfoGenerator;
    @Inject
    private RuleGenerator ruleGenerator;
    @Inject
    private ModelObjectGenerator dataGenerator;
    @Inject
    private CardinalityValidatorGenerator cardinalityValidatorGenerator;
    @Inject
    private TypeFormatValidatorGenerator typeFormatValidatorGenerator;
    @Inject
    private OnlyExistsValidatorGenerator onlyExistsValidatorGenerator;
    @Inject
    private FunctionGenerator funcGenerator;
    @Inject
    private ReportGenerator reportGenerator;
    @Inject
    private DeepPathUtilGenerator deepPathUtilGenerator;
    @Inject
    private LabelProviderGenerator labelProviderGenerator;
    @Inject
    private ResourceAwareFSAFactory fsaFactory;
    @Inject
    private RosettaGeneratorsConfiguration config;
    private final Set<String> ignoredFiles = Collections.unmodifiableSet(CollectionLiterals.newHashSet((Object[])new String[]{"model-no-code-gen.rosetta", "basictypes.rosetta", "annotations.rosetta"}));
    private final Map<ResourceSet, DemandableLock> locks = CollectionLiterals.newHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beforeAllGenerate(ResourceSet resourceSet, IFileSystemAccess2 fsa2, IGeneratorContext context) {
        block8: {
            LOGGER.trace("Starting the before all generate method");
            Function<ResourceSet, DemandableLock> _function = it -> new DemandableLock();
            DemandableLock lock = this.locks.computeIfAbsent(resourceSet, _function);
            try {
                lock.getWriteLock(true);
                Functions.Function1 _function_1 = it -> {
                    boolean _contains = this.ignoredFiles.contains(IterableExtensions.lastOrNull((Iterable)((Iterable)Conversions.doWrapArray((Object)it.getURI().segments()))));
                    return !_contains;
                };
                Functions.Function1 _function_2 = it -> {
                    EObject _head = (EObject)IterableExtensions.head((Iterable)it.getContents());
                    return (RosettaModel)_head;
                };
                Functions.Function1 _function_3 = it -> this.shouldGenerate((RosettaModel)it);
                List models = IterableExtensions.toList((Iterable)IterableExtensions.filter((Iterable)IterableExtensions.map((Iterable)IterableExtensions.filter((Iterable)resourceSet.getResources(), (Functions.Function1)_function_1), (Functions.Function1)_function_2), (Functions.Function1)_function_3));
                RosettaModel _head = (RosettaModel)IterableExtensions.head((Iterable)models);
                String _version = null;
                if (_head != null) {
                    _version = _head.getVersion();
                }
                String version = _version;
                Consumer<ExternalGenerator> _function_4 = generator -> {
                    Consumer<Map<String, ? extends CharSequence>> _function_5 = map -> {
                        Consumer<Map.Entry> _function_6 = it -> fsa2.generateFile((String)it.getKey(), generator.getOutputConfiguration().getName(), (CharSequence)it.getValue());
                        map.entrySet().forEach(_function_6);
                    };
                    generator.beforeAllGenerate(resourceSet, models, version, _function_5, lock);
                };
                this.externalGenerators.forEach(_function_4);
            }
            catch (Throwable _t) {
                if (_t instanceof CancellationException) {
                    LOGGER.trace("Code generation cancelled, this is expected");
                    break block8;
                }
                if (_t instanceof Exception) {
                    Exception e_1 = (Exception)_t;
                    LOGGER.warn("Unexpected calling before all generate for rosetta -{} - see debug logging for more", (Object)e_1.getMessage());
                    LOGGER.debug("Unexpected calling before all generate for rosetta", (Throwable)e_1);
                    String _message = e_1.getMessage();
                    Throwable _cause = e_1.getCause();
                    throw new GenerationException(_message, null, null, _cause);
                }
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
            finally {
                lock.releaseWriteLock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beforeGenerate(Resource resource, IFileSystemAccess2 fsa2, IGeneratorContext context) {
        block10: {
            boolean _not;
            boolean _contains = this.ignoredFiles.contains(IterableExtensions.lastOrNull((Iterable)((Iterable)Conversions.doWrapArray((Object)resource.getURI().segments()))));
            boolean bl = _not = !_contains;
            if (_not) {
                String _string = resource.getURI().toString();
                String _plus = "Starting the before generate method for " + _string;
                LOGGER.trace(_plus);
                Function<ResourceSet, DemandableLock> _function = it -> new DemandableLock();
                DemandableLock lock = this.locks.computeIfAbsent(resource.getResourceSet(), _function);
                IFileSystemAccess2 fsa = this.fsaFactory.resourceAwareFSA(resource, fsa2, true);
                try {
                    boolean _not_1;
                    lock.getWriteLock(true);
                    this.fsaFactory.beforeGenerate(resource);
                    EObject _head = (EObject)IterableExtensions.head((Iterable)resource.getContents());
                    RosettaModel model = (RosettaModel)_head;
                    boolean _shouldGenerate = this.shouldGenerate(model);
                    boolean bl2 = _not_1 = !_shouldGenerate;
                    if (_not_1) {
                        return;
                    }
                    String version = model.getVersion();
                    Consumer<ExternalGenerator> _function_1 = generator -> {
                        Consumer<Map<String, ? extends CharSequence>> _function_2 = map -> {
                            Consumer<Map.Entry> _function_3 = it -> fsa.generateFile((String)it.getKey(), generator.getOutputConfiguration().getName(), (CharSequence)it.getValue());
                            map.entrySet().forEach(_function_3);
                        };
                        generator.beforeGenerate(resource, model, version, _function_2, lock);
                    };
                    this.externalGenerators.forEach(_function_1);
                }
                catch (Throwable _t) {
                    if (_t instanceof CancellationException) {
                        LOGGER.trace("Code generation cancelled, this is expected");
                        break block10;
                    }
                    if (_t instanceof Exception) {
                        Exception e_1 = (Exception)_t;
                        LOGGER.warn("Unexpected calling before generate for rosetta -{} - see debug logging for more", (Object)e_1.getMessage());
                        LOGGER.debug("Unexpected calling before generate for rosetta", (Throwable)e_1);
                        String _message = e_1.getMessage();
                        URI _uRI = resource.getURI();
                        Throwable _cause = e_1.getCause();
                        throw new GenerationException(_message, _uRI, null, _cause);
                    }
                    throw Exceptions.sneakyThrow((Throwable)_t);
                }
                finally {
                    lock.releaseWriteLock();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGenerate(Resource resource, IFileSystemAccess2 fsa2, IGeneratorContext context) {
        block13: {
            boolean _not;
            boolean _contains = this.ignoredFiles.contains(IterableExtensions.lastOrNull((Iterable)((Iterable)Conversions.doWrapArray((Object)resource.getURI().segments()))));
            boolean bl = _not = !_contains;
            if (_not) {
                String _string = resource.getURI().toString();
                String _plus = "Starting the main generate method for " + _string;
                LOGGER.trace(_plus);
                IFileSystemAccess2 fsa = this.fsaFactory.resourceAwareFSA(resource, fsa2, false);
                Function<ResourceSet, DemandableLock> _function = it -> new DemandableLock();
                DemandableLock lock = this.locks.computeIfAbsent(resource.getResourceSet(), _function);
                try {
                    boolean _not_2;
                    Functions.Function1 _function_1;
                    boolean _not_1;
                    lock.getWriteLock(true);
                    EObject _head = (EObject)IterableExtensions.head((Iterable)resource.getContents());
                    RosettaModel model = (RosettaModel)_head;
                    boolean _shouldGenerate = this.shouldGenerate(model);
                    boolean bl2 = _not_1 = !_shouldGenerate;
                    if (_not_1) {
                        return;
                    }
                    String version = model.getVersion();
                    List javaGenerators = Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new JavaClassGenerator[]{this.conditionGenerator, this.dataGenerator, this.metaGenerator, this.cardinalityValidatorGenerator, this.typeFormatValidatorGenerator, this.onlyExistsValidatorGenerator, this.deepPathUtilGenerator, this.funcGenerator, this.labelProviderGenerator, this.ruleGenerator, this.reportGenerator, this.enumGenerator, this.metaFieldGenerator}));
                    List aggregatedGenerationExceptions = IterableExtensions.toList((Iterable)IterableExtensions.flatMap(javaGenerators, (Functions.Function1)(_function_1 = generator -> generator.generateClasses(model, version, fsa2, context.getCancelIndicator()))));
                    boolean _isEmpty = aggregatedGenerationExceptions.isEmpty();
                    boolean bl3 = _not_2 = !_isEmpty;
                    if (_not_2) {
                        boolean _tripleEquals;
                        int _size = aggregatedGenerationExceptions.size();
                        boolean bl4 = _tripleEquals = _size == 1;
                        if (_tripleEquals) {
                            throw (GenerationException)aggregatedGenerationExceptions.get(0);
                        }
                        URI _uRI = resource.getURI();
                        throw new AggregateGenerationException("Multiple errors encountered during generation", _uRI, aggregatedGenerationExceptions);
                    }
                    Consumer<ExternalGenerator> _function_2 = generator -> {
                        Consumer<Map<String, ? extends CharSequence>> _function_3 = map -> {
                            Consumer<Map.Entry> _function_4 = it -> fsa.generateFile((String)it.getKey(), generator.getOutputConfiguration().getName(), (CharSequence)it.getValue());
                            map.entrySet().forEach(_function_4);
                        };
                        generator.generate(resource, model, version, _function_3, lock);
                    };
                    this.externalGenerators.forEach(_function_2);
                }
                catch (Throwable _t) {
                    if (_t instanceof CancellationException) {
                        LOGGER.trace("Code generation cancelled, this is expected");
                        break block13;
                    }
                    if (_t instanceof AggregateGenerationException || _t instanceof GenerationException) {
                        RuntimeException e_1 = (RuntimeException)_t;
                        LOGGER.warn("Unexpected calling standard generate for rosetta root element  -{} - see debug logging for more", (Object)e_1.getMessage());
                        LOGGER.info("Unexpected calling standard generate for rosetta root element", (Throwable)e_1);
                        throw e_1;
                    }
                    if (_t instanceof Exception) {
                        Exception e_2 = (Exception)_t;
                        LOGGER.warn("Unexpected calling standard generate for rosetta -{} - see debug logging for more", (Object)e_2.getMessage());
                        LOGGER.info("Unexpected calling standard generate for rosetta", (Throwable)e_2);
                        String _message = e_2.getMessage();
                        URI _uRI_1 = resource.getURI();
                        Throwable _cause = e_2.getCause();
                        throw new GenerationException(_message, _uRI_1, null, _cause);
                    }
                    throw Exceptions.sneakyThrow((Throwable)_t);
                }
                finally {
                    LOGGER.trace("ending the main generate method");
                    lock.releaseWriteLock();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterGenerate(Resource resource, IFileSystemAccess2 fsa2, IGeneratorContext context) {
        block10: {
            boolean _not;
            boolean _contains = this.ignoredFiles.contains(IterableExtensions.lastOrNull((Iterable)((Iterable)Conversions.doWrapArray((Object)resource.getURI().segments()))));
            boolean bl = _not = !_contains;
            if (_not) {
                String _string = resource.getURI().toString();
                String _plus = "Starting the after generate method for " + _string;
                LOGGER.trace(_plus);
                Function<ResourceSet, DemandableLock> _function = it -> new DemandableLock();
                DemandableLock lock = this.locks.computeIfAbsent(resource.getResourceSet(), _function);
                IFileSystemAccess2 fsa = this.fsaFactory.resourceAwareFSA(resource, fsa2, true);
                try {
                    boolean _not_1;
                    lock.getWriteLock(true);
                    EObject _head = (EObject)IterableExtensions.head((Iterable)resource.getContents());
                    RosettaModel model = (RosettaModel)_head;
                    boolean _shouldGenerate = this.shouldGenerate(model);
                    boolean bl2 = _not_1 = !_shouldGenerate;
                    if (_not_1) {
                        return;
                    }
                    String version = model.getVersion();
                    Consumer<ExternalGenerator> _function_1 = generator -> {
                        Consumer<Map<String, ? extends CharSequence>> _function_2 = map -> {
                            Consumer<Map.Entry> _function_3 = it -> fsa.generateFile((String)it.getKey(), generator.getOutputConfiguration().getName(), (CharSequence)it.getValue());
                            map.entrySet().forEach(_function_3);
                        };
                        generator.afterGenerate(resource, model, version, _function_2, lock);
                    };
                    this.externalGenerators.forEach(_function_1);
                    this.fsaFactory.afterGenerate(resource);
                    Functions.Function1 _function_2 = it -> {
                        boolean _contains_1 = this.ignoredFiles.contains(IterableExtensions.lastOrNull((Iterable)((Iterable)Conversions.doWrapArray((Object)it.getURI().segments()))));
                        return !_contains_1;
                    };
                    Functions.Function1 _function_3 = it -> {
                        EObject _head_1 = (EObject)IterableExtensions.head((Iterable)it.getContents());
                        return (RosettaModel)_head_1;
                    };
                    Functions.Function1 _function_4 = it -> this.shouldGenerate((RosettaModel)it);
                    List models = IterableExtensions.toList((Iterable)IterableExtensions.filter((Iterable)IterableExtensions.map((Iterable)IterableExtensions.filter((Iterable)resource.getResourceSet().getResources(), (Functions.Function1)_function_2), (Functions.Function1)_function_3), (Functions.Function1)_function_4));
                    this.javaPackageInfoGenerator.generatePackageInfoClasses(fsa2, models);
                }
                catch (Throwable _t) {
                    if (_t instanceof CancellationException) {
                        LOGGER.trace("Code generation cancelled, this is expected");
                        break block10;
                    }
                    if (_t instanceof Exception) {
                        Exception e_1 = (Exception)_t;
                        LOGGER.warn("Unexpected calling after generate for rosetta -{} - see debug logging for more", (Object)e_1.getMessage());
                        LOGGER.debug("Unexpected calling after generate for rosetta", (Throwable)e_1);
                        String _message = e_1.getMessage();
                        URI _uRI = resource.getURI();
                        Throwable _cause = e_1.getCause();
                        throw new GenerationException(_message, _uRI, null, _cause);
                    }
                    throw Exceptions.sneakyThrow((Throwable)_t);
                }
                finally {
                    lock.releaseWriteLock();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterAllGenerate(ResourceSet resourceSet, IFileSystemAccess2 fsa2, IGeneratorContext context) {
        block8: {
            LOGGER.trace("Starting the after all generate method");
            Function<ResourceSet, DemandableLock> _function = it -> new DemandableLock();
            DemandableLock lock = this.locks.computeIfAbsent(resourceSet, _function);
            try {
                lock.getWriteLock(true);
                Functions.Function1 _function_1 = it -> {
                    boolean _contains = this.ignoredFiles.contains(IterableExtensions.lastOrNull((Iterable)((Iterable)Conversions.doWrapArray((Object)it.getURI().segments()))));
                    return !_contains;
                };
                Functions.Function1 _function_2 = it -> {
                    EObject _head = (EObject)IterableExtensions.head((Iterable)it.getContents());
                    return (RosettaModel)_head;
                };
                Functions.Function1 _function_3 = it -> this.shouldGenerate((RosettaModel)it);
                List models = IterableExtensions.toList((Iterable)IterableExtensions.filter((Iterable)IterableExtensions.map((Iterable)IterableExtensions.filter((Iterable)resourceSet.getResources(), (Functions.Function1)_function_1), (Functions.Function1)_function_2), (Functions.Function1)_function_3));
                RosettaModel _head = (RosettaModel)IterableExtensions.head((Iterable)models);
                String _version = null;
                if (_head != null) {
                    _version = _head.getVersion();
                }
                String version = _version;
                Consumer<ExternalGenerator> _function_4 = generator -> {
                    Consumer<Map<String, ? extends CharSequence>> _function_5 = map -> {
                        Consumer<Map.Entry> _function_6 = it -> fsa2.generateFile((String)it.getKey(), generator.getOutputConfiguration().getName(), (CharSequence)it.getValue());
                        map.entrySet().forEach(_function_6);
                    };
                    generator.afterAllGenerate(resourceSet, models, version, _function_5, lock);
                };
                this.externalGenerators.forEach(_function_4);
            }
            catch (Throwable _t) {
                if (_t instanceof CancellationException) {
                    LOGGER.trace("Code generation cancelled, this is expected");
                    break block8;
                }
                if (_t instanceof Exception) {
                    Exception e_1 = (Exception)_t;
                    LOGGER.warn("Unexpected calling after all generate for rosetta -{} - see debug logging for more", (Object)e_1.getMessage());
                    LOGGER.debug("Unexpected calling after all generate for rosetta", (Throwable)e_1);
                    String _message = e_1.getMessage();
                    Throwable _cause = e_1.getCause();
                    throw new GenerationException(_message, null, null, _cause);
                }
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
            finally {
                lock.releaseWriteLock();
            }
        }
    }

    private boolean shouldGenerate(RosettaModel model) {
        return this.config.getNamespaceFilter().test(model.getName()) || model.isOverridden();
    }
}

