/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.parsing;

import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.xtext.conversion.ValueConverterException;
import org.eclipse.xtext.conversion.ValueConverterWithValueException;
import org.eclipse.xtext.conversion.impl.AbstractLexerBasedConverter;
import org.eclipse.xtext.nodemodel.INode;

public class PATTERNValueConverter
extends AbstractLexerBasedConverter<Pattern> {
    protected String toEscapedString(Pattern value) {
        return "/" + value.toString() + "/";
    }

    public Pattern toValue(String string, INode node) {
        if (string == null) {
            return null;
        }
        try {
            if (string.length() == 1) {
                throw new ValueConverterException(this.getPatternNotClosedMessage(), node, null);
            }
            return this.convertFromString(string, node);
        }
        catch (IllegalArgumentException e) {
            throw new ValueConverterException(e.getMessage(), node, (Exception)e);
        }
    }

    protected Pattern convertFromString(String literal, INode node) throws ValueConverterWithValueException {
        Implementation converter = this.createConverter();
        Pattern result = converter.convertFromJavaString(literal);
        if (converter.errorMessage != null) {
            throw new ValueConverterWithValueException(converter.errorMessage, node, (Object)result, converter.errorIndex, converter.errorLength, null);
        }
        return result;
    }

    protected Implementation createConverter() {
        return new Implementation();
    }

    protected String getInvalidSyntaxMessage(PatternSyntaxException e) {
        return "Invalid syntax: " + e.getMessage();
    }

    protected String getInvalidEscapeSequenceMessage() {
        return "Invalid escape sequence (valid ones are  \\/  \\\\ )";
    }

    protected String getPatternNotClosedMessage() {
        return "Pattern literal is not properly closed";
    }

    protected class Implementation {
        String errorMessage = null;
        int errorIndex = -1;
        int errorLength = -1;
        int nextIndex = 1;

        protected Implementation() {
        }

        private Pattern compile(String javaRegex) {
            try {
                return Pattern.compile(javaRegex);
            }
            catch (PatternSyntaxException e) {
                this.errorMessage = PATTERNValueConverter.this.getInvalidSyntaxMessage(e);
                this.errorIndex = e.getIndex();
                return null;
            }
        }

        public Pattern convertFromJavaString(String literal) {
            int idx = literal.indexOf(92);
            if (idx < 0 && literal.length() > 1 && literal.charAt(0) == literal.charAt(literal.length() - 1)) {
                return this.compile(literal.substring(1, literal.length() - 1));
            }
            return this.convertFromJavaString(literal, 1, new StringBuilder(literal.length()));
        }

        protected Pattern convertFromJavaString(String string, int index, StringBuilder result) {
            int length = string.length();
            while (index < length - 1) {
                this.nextIndex = index = this.unescapeCharAndAppendTo(string, index, result);
            }
            if (this.nextIndex < length) {
                if (this.nextIndex != length - 1) {
                    throw new IllegalStateException();
                }
                char next = string.charAt(this.nextIndex);
                if (string.charAt(0) != next) {
                    result.append(next);
                    if (this.errorMessage == null) {
                        if (next == '\\') {
                            this.errorMessage = PATTERNValueConverter.this.getInvalidEscapeSequenceMessage();
                            this.errorIndex = this.nextIndex;
                            this.errorLength = 1;
                        } else {
                            this.errorMessage = PATTERNValueConverter.this.getPatternNotClosedMessage();
                        }
                    } else {
                        this.errorMessage = PATTERNValueConverter.this.getPatternNotClosedMessage();
                        this.errorIndex = -1;
                        this.errorLength = -1;
                    }
                }
            } else if (this.nextIndex == length) {
                this.errorMessage = PATTERNValueConverter.this.getPatternNotClosedMessage();
            }
            return this.compile(result.toString());
        }

        protected int doUnescapeCharAndAppendTo(String string, int index, StringBuilder result) {
            if (string.length() == index) {
                if (this.errorMessage == null) {
                    this.errorMessage = PATTERNValueConverter.this.getInvalidEscapeSequenceMessage();
                    this.errorIndex = index - 1;
                    this.errorLength = 1;
                }
                return index;
            }
            char c = string.charAt(index++);
            switch (c) {
                case '/': 
                case '\\': {
                    break;
                }
                default: {
                    result.append('\\');
                }
            }
            this.validateAndAppendChar(c, result);
            return index;
        }

        protected int handleUnknownEscapeSequence(String string, char c, int index, StringBuilder result) {
            if (this.errorMessage == null) {
                this.errorMessage = PATTERNValueConverter.this.getInvalidEscapeSequenceMessage();
                this.errorIndex = index - 2;
                this.errorLength = 2;
            }
            result.append(c);
            return index;
        }

        protected int unescapeCharAndAppendTo(String string, int index, StringBuilder result) {
            char c;
            if ((c = string.charAt(index++)) == '\\') {
                return this.doUnescapeCharAndAppendTo(string, index, result);
            }
            this.validateAndAppendChar(c, result);
            return index;
        }

        protected void validateAndAppendChar(char c, StringBuilder result) {
            if (this.validate(c, result)) {
                result.append(c);
            }
        }

        protected boolean validate(char c, StringBuilder result) {
            return true;
        }
    }
}

