/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.resource;

import com.regnosys.rosetta.resource.AttributeDescription;
import com.regnosys.rosetta.resource.RosettaModelDescription;
import com.regnosys.rosetta.resource.RuleDescription;
import com.regnosys.rosetta.rosetta.RosettaModel;
import com.regnosys.rosetta.rosetta.RosettaRule;
import com.regnosys.rosetta.rosetta.expression.RosettaExpression;
import com.regnosys.rosetta.rosetta.simple.Attribute;
import jakarta.inject.Singleton;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.impl.DefaultResourceDescriptionStrategy;
import org.eclipse.xtext.util.IAcceptor;

@Singleton
public class RosettaResourceDescriptionStrategy
extends DefaultResourceDescriptionStrategy {
    private static final Logger LOGGER = Logger.getLogger(RosettaResourceDescriptionStrategy.class);

    public boolean createEObjectDescriptions(EObject eObject, IAcceptor<IEObjectDescription> acceptor) {
        if (this.getQualifiedNameProvider() == null) {
            return false;
        }
        try {
            if (eObject instanceof RosettaExpression) {
                return false;
            }
            if (eObject instanceof RosettaModel) {
                return this.createRosettaModelDescription((RosettaModel)eObject, acceptor);
            }
            if (eObject instanceof Attribute) {
                return this.createAttributeDescription((Attribute)eObject, acceptor);
            }
            if (eObject instanceof RosettaRule) {
                return this.createRosettaRuleDescription((RosettaRule)eObject, acceptor);
            }
        }
        catch (Exception exc) {
            LOGGER.error((Object)exc.getMessage(), (Throwable)exc);
            return true;
        }
        return super.createEObjectDescriptions(eObject, acceptor);
    }

    private boolean createRosettaModelDescription(RosettaModel model, IAcceptor<IEObjectDescription> acceptor) {
        QualifiedName qualifiedName = this.getQualifiedNameProvider().getFullyQualifiedName((EObject)model);
        acceptor.accept((Object)new RosettaModelDescription(qualifiedName, model));
        return true;
    }

    private boolean createAttributeDescription(Attribute attr, IAcceptor<IEObjectDescription> acceptor) {
        QualifiedName qualifiedName = this.getQualifiedNameProvider().getFullyQualifiedName((EObject)attr);
        String typeCall = this.serialize(attr.getTypeCall());
        String cardinality = this.serialize(attr.getCard());
        String ruleReferences = this.serialize(attr.getRuleReferences());
        String labels = this.serialize(attr.getLabels());
        acceptor.accept((Object)new AttributeDescription(qualifiedName, attr, typeCall, cardinality, ruleReferences, labels));
        return false;
    }

    private boolean createRosettaRuleDescription(RosettaRule rule, IAcceptor<IEObjectDescription> acceptor) {
        QualifiedName qualifiedName = this.getQualifiedNameProvider().getFullyQualifiedName((EObject)rule);
        String input = this.serialize(rule.getInput());
        String expression = this.serialize(rule.getExpression());
        if (qualifiedName != null) {
            acceptor.accept((Object)new RuleDescription(qualifiedName, rule, input, expression));
        }
        return false;
    }

    private String serialize(EObject eObject) {
        if (eObject == null) {
            return null;
        }
        ICompositeNode node = NodeModelUtils.getNode((EObject)eObject);
        if (node != null) {
            return node.getText();
        }
        return null;
    }

    private String serialize(EList<? extends EObject> list) {
        if (list.isEmpty()) {
            return null;
        }
        return list.stream().map(e -> this.serialize((EObject)e)).filter(s -> s != null).collect(Collectors.joining(","));
    }
}

