/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.utils;

import com.regnosys.rosetta.utils.Interval;
import com.regnosys.rosetta.utils.OptionalUtil;
import java.math.BigDecimal;
import java.math.MathContext;
import java.util.Objects;
import java.util.Optional;

public class BigDecimalInterval
extends Interval<BigDecimal> {
    public BigDecimalInterval(Optional<BigDecimal> min, Optional<BigDecimal> max) {
        super(min, max);
    }

    public static BigDecimalInterval bounded(BigDecimal min, BigDecimal max) {
        return new BigDecimalInterval(Optional.of(min), Optional.of(max));
    }

    public static BigDecimalInterval boundedLeft(BigDecimal min) {
        return new BigDecimalInterval(Optional.of(min), Optional.empty());
    }

    public static BigDecimalInterval boundedRight(BigDecimal max) {
        return new BigDecimalInterval(Optional.empty(), Optional.of(max));
    }

    public static BigDecimalInterval unbounded() {
        return new BigDecimalInterval(Optional.empty(), Optional.empty());
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        BigDecimalInterval other = (BigDecimalInterval)object;
        return this.boundEquals(this.getMin(), other.getMin()) && this.boundEquals(this.getMax(), other.getMax());
    }

    private boolean boundEquals(Optional<BigDecimal> a, Optional<BigDecimal> b) {
        return Objects.equals(a, b) || OptionalUtil.zipWith(a, b, (x, y) -> x.compareTo((BigDecimal)y) == 0).orElse(false) != false;
    }

    public BigDecimalInterval minimalCover(BigDecimalInterval other) {
        return new BigDecimalInterval(OptionalUtil.zipWith(this.getMin(), other.getMin(), BigDecimal::min), OptionalUtil.zipWith(this.getMax(), other.getMax(), BigDecimal::max));
    }

    public BigDecimalInterval add(BigDecimalInterval other) {
        return new BigDecimalInterval(OptionalUtil.zipWith(this.getMin(), other.getMin(), BigDecimal::add), OptionalUtil.zipWith(this.getMax(), other.getMax(), BigDecimal::add));
    }

    public BigDecimalInterval subtract(BigDecimalInterval other) {
        return new BigDecimalInterval(OptionalUtil.zipWith(this.getMin(), other.getMin(), BigDecimal::subtract), OptionalUtil.zipWith(this.getMax(), other.getMax(), BigDecimal::subtract));
    }

    public BigDecimalInterval multiply(BigDecimalInterval other) {
        BigDecimalOrInfinite mina = BigDecimalInterval.withSignedInfinite(this.getMin(), false);
        BigDecimalOrInfinite maxa = BigDecimalInterval.withSignedInfinite(this.getMax(), true);
        BigDecimalOrInfinite minb = BigDecimalInterval.withSignedInfinite(other.getMin(), false);
        BigDecimalOrInfinite maxb = BigDecimalInterval.withSignedInfinite(other.getMax(), true);
        BigDecimalOrInfinite mult1 = mina.multiply(minb);
        BigDecimalOrInfinite mult2 = mina.multiply(maxb);
        BigDecimalOrInfinite mult3 = maxa.multiply(minb);
        BigDecimalOrInfinite mult4 = maxa.multiply(maxb);
        BigDecimalOrInfinite min = mult1.min(mult2).min(mult3).min(mult4);
        BigDecimalOrInfinite max = mult1.max(mult2).max(mult3).max(mult4);
        return new BigDecimalInterval(min.finiteValue, max.finiteValue);
    }

    public BigDecimalInterval divide(BigDecimalInterval other) {
        return this.multiply(other.invert());
    }

    public BigDecimalInterval invert() {
        if (this.strictlyIncludes(BigDecimal.ZERO)) {
            return BigDecimalInterval.unbounded();
        }
        BigDecimalOrInfinite min = BigDecimalInterval.invert(this.getMax(), false);
        BigDecimalOrInfinite max = BigDecimalInterval.invert(this.getMin(), true);
        return new BigDecimalInterval(min.finiteValue, max.finiteValue);
    }

    private static BigDecimalOrInfinite invert(Optional<BigDecimal> x, boolean defaultSign) {
        return x.map(v -> {
            if (v.compareTo(BigDecimal.ZERO) == 0) {
                return BigDecimalOrInfinite.infinite(defaultSign);
            }
            return BigDecimalOrInfinite.of(BigDecimal.ONE.divide((BigDecimal)v, MathContext.DECIMAL128));
        }).orElse(BigDecimalOrInfinite.of(BigDecimal.ZERO));
    }

    private static BigDecimalOrInfinite withSignedInfinite(Optional<BigDecimal> finiteValue, boolean defaultSign) {
        return finiteValue.map(v -> BigDecimalOrInfinite.of(v)).orElseGet(() -> BigDecimalOrInfinite.infinite(defaultSign));
    }

    private static class BigDecimalOrInfinite {
        private final Optional<BigDecimal> finiteValue;
        private final boolean sign;

        private BigDecimalOrInfinite(Optional<BigDecimal> finiteValue, boolean sign) {
            this.finiteValue = finiteValue;
            this.sign = sign;
        }

        public static BigDecimalOrInfinite of(BigDecimal finiteValue) {
            return new BigDecimalOrInfinite(Optional.of(finiteValue), finiteValue.compareTo(BigDecimal.ZERO) >= 0);
        }

        public static BigDecimalOrInfinite infinite(boolean sign) {
            return new BigDecimalOrInfinite(Optional.empty(), sign);
        }

        public boolean isFinite() {
            return this.finiteValue.isPresent();
        }

        public BigDecimalOrInfinite multiply(BigDecimalOrInfinite other) {
            Optional<BigDecimal> resultFiniteValue = OptionalUtil.zipWith(this.finiteValue, other.finiteValue, BigDecimal::multiply).or(() -> {
                if (this.isZero()) {
                    return this.finiteValue;
                }
                if (other.isZero()) {
                    return other.finiteValue;
                }
                return Optional.empty();
            });
            boolean resultSign = this.sign == other.sign;
            return new BigDecimalOrInfinite(resultFiniteValue, resultSign);
        }

        public boolean isZero() {
            return this.finiteValue.map(v -> v.compareTo(BigDecimal.ZERO) == 0).orElse(false);
        }

        public BigDecimalOrInfinite min(BigDecimalOrInfinite other) {
            Optional<BigDecimal> resultFiniteValue = OptionalUtil.zipWith(this.finiteValue, other.finiteValue, BigDecimal::min).or(() -> {
                if (this.isFinite()) {
                    if (other.sign) {
                        return this.finiteValue;
                    }
                    return Optional.empty();
                }
                if (other.isFinite()) {
                    if (this.sign) {
                        return other.finiteValue;
                    }
                    return Optional.empty();
                }
                return Optional.empty();
            });
            boolean resultSign = this.sign && other.sign;
            return new BigDecimalOrInfinite(resultFiniteValue, resultSign);
        }

        public BigDecimalOrInfinite max(BigDecimalOrInfinite other) {
            Optional<BigDecimal> resultFiniteValue = OptionalUtil.zipWith(this.finiteValue, other.finiteValue, BigDecimal::max).or(() -> {
                if (this.isFinite()) {
                    if (other.sign) {
                        return Optional.empty();
                    }
                    return this.finiteValue;
                }
                if (other.isFinite()) {
                    if (this.sign) {
                        return Optional.empty();
                    }
                    return other.finiteValue;
                }
                return Optional.empty();
            });
            boolean resultSign = this.sign || other.sign;
            return new BigDecimalOrInfinite(resultFiniteValue, resultSign);
        }
    }
}

