/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.common.model;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.cache.CacheBuilder;
import com.google.inject.AbstractModule;
import com.google.inject.matcher.AbstractMatcher;
import com.google.inject.matcher.Matcher;
import com.google.inject.matcher.Matchers;
import com.regnosys.rosetta.common.model.CachingMethodInterceptor;
import com.rosetta.model.lib.functions.RosettaFunction;
import java.lang.reflect.Method;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Set;
import org.aopalliance.intercept.MethodInterceptor;

public class FunctionMemoisingModule
extends AbstractModule {
    public static final String DEFAULT_SUFFIX = "Default";
    public static final String EVALUATE_METHOD_NAME = "evaluate";
    private final Set<String> packages;
    private final Set<String> debugFunctions;

    public FunctionMemoisingModule(Set<String> packages, Set<String> debugFunctions) {
        this.packages = packages;
        this.debugFunctions = debugFunctions;
    }

    protected void configure() {
        CacheBuilder<Object, Object> cacheBuilder = FunctionMemoisingModule.configureCacheBuilder();
        Matcher<Class> classMatcher = this.createClassMatcher();
        this.binder().bindInterceptor(classMatcher, FunctionMemoisingModule.isEvaluateMethod(), new MethodInterceptor[]{new CachingMethodInterceptor(cacheBuilder, this.debugFunctions)});
    }

    private static CacheBuilder<Object, Object> configureCacheBuilder() {
        CacheBuilder cacheBuilder = CacheBuilder.newBuilder();
        cacheBuilder.expireAfterAccess(Duration.of(5L, ChronoUnit.MINUTES));
        cacheBuilder.maximumSize(250L);
        return cacheBuilder;
    }

    private Matcher<Class> createClassMatcher() {
        Matcher classMatcher = Matchers.subclassesOf(RosettaFunction.class).and(FunctionMemoisingModule.isDefaultImpl());
        for (String aPackage : this.packages) {
            classMatcher = classMatcher.and(Matchers.inSubpackage((String)aPackage));
        }
        return classMatcher;
    }

    @VisibleForTesting
    public static AbstractMatcher<Method> isEvaluateMethod() {
        return new AbstractMatcher<Method>(){

            public boolean matches(Method method) {
                return method.getName().equals(FunctionMemoisingModule.EVALUATE_METHOD_NAME) && !method.isSynthetic();
            }
        };
    }

    private static Matcher<Class> isDefaultImpl() {
        return new AbstractMatcher<Class>(){

            public boolean matches(Class aClass) {
                return aClass.getName().endsWith(FunctionMemoisingModule.DEFAULT_SUFFIX);
            }
        };
    }
}

