/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.common.serialisation.xml;

import java.time.ZoneOffset;
import java.time.zone.ZoneRules;
import java.time.zone.ZoneRulesException;
import java.time.zone.ZoneRulesProvider;
import java.util.Collections;
import java.util.NavigableMap;
import java.util.Set;
import java.util.TreeMap;

public class UnknownZoneProvider
extends ZoneRulesProvider {
    private static final String UNKNOWN_ZONE_ID = "Unknown";
    private static final ZoneRules UNKNOWN_ZONE_RULES = ZoneRules.of(ZoneOffset.UTC);
    private static final Set<String> ZONE_IDS = Collections.singleton("Unknown");

    @Override
    protected Set<String> provideZoneIds() {
        return ZONE_IDS;
    }

    @Override
    protected ZoneRules provideRules(String zoneId, boolean forCaching) {
        if (forCaching) {
            return null;
        }
        if (UNKNOWN_ZONE_ID.equals(zoneId)) {
            return UNKNOWN_ZONE_RULES;
        }
        throw new ZoneRulesException("Unknown zone ID: " + zoneId);
    }

    @Override
    protected NavigableMap<String, ZoneRules> provideVersions(String zoneId) {
        if (UNKNOWN_ZONE_ID.equals(zoneId)) {
            TreeMap<String, ZoneRules> versionMap = new TreeMap<String, ZoneRules>();
            versionMap.put("1", UNKNOWN_ZONE_RULES);
            return versionMap;
        }
        throw new ZoneRulesException("Unknown zone ID: " + zoneId);
    }
}

