/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.basics.currency;

import com.google.common.base.Splitter;
import com.google.common.collect.ComparisonChain;
import com.google.common.math.DoubleMath;
import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.currency.CurrencyAmount;
import com.opengamma.strata.basics.currency.FxConvertible;
import com.opengamma.strata.basics.currency.FxRateProvider;
import com.opengamma.strata.collect.ArgChecker;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;
import org.joda.convert.FromString;
import org.joda.convert.ToString;

public class Money
implements FxConvertible<Money>,
Comparable<Money>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final Currency currency;
    private final BigDecimal amount;

    public static Money of(CurrencyAmount currencyAmount) {
        Currency currency = currencyAmount.getCurrency();
        BigDecimal roundedAmount = BigDecimal.valueOf(currencyAmount.getAmount()).setScale(currency.getMinorUnitDigits(), RoundingMode.HALF_UP);
        return new Money(currency, roundedAmount);
    }

    public static Money of(Currency currency, double amount) {
        BigDecimal roundedAmount = BigDecimal.valueOf(amount).setScale(currency.getMinorUnitDigits(), RoundingMode.HALF_UP);
        return new Money(currency, roundedAmount);
    }

    public static Money of(Currency currency, BigDecimal amount) {
        BigDecimal roundedAmount = amount.setScale(currency.getMinorUnitDigits(), RoundingMode.HALF_UP);
        return new Money(currency, roundedAmount);
    }

    @FromString
    public static Money parse(String amountStr) {
        ArgChecker.notNull((Object)amountStr, (String)"amountStr");
        List split = Splitter.on((char)' ').splitToList((CharSequence)amountStr);
        if (split.size() != 2) {
            throw new IllegalArgumentException("Unable to parse amount, invalid format: " + amountStr);
        }
        try {
            Currency cur = Currency.parse((String)split.get(0));
            return new Money(cur, new BigDecimal((String)split.get(1)));
        }
        catch (RuntimeException ex) {
            throw new IllegalArgumentException("Unable to parse amount: " + amountStr, ex);
        }
    }

    private Money(Currency currency, BigDecimal amount) {
        ArgChecker.notNull((Object)currency, (String)"currency");
        ArgChecker.notNull((Object)amount, (String)"amount");
        this.currency = currency;
        this.amount = amount;
    }

    public Currency getCurrency() {
        return this.currency;
    }

    public BigDecimal getAmount() {
        return this.amount;
    }

    public Money convertedTo(Currency resultCurrency, BigDecimal fxRate) {
        if (this.currency.equals(resultCurrency)) {
            if (DoubleMath.fuzzyEquals((double)fxRate.doubleValue(), (double)1.0, (double)1.0E-8)) {
                return this;
            }
            throw new IllegalArgumentException("FX rate must be 1 when no conversion required");
        }
        return Money.of(resultCurrency, this.amount.multiply(fxRate));
    }

    @Override
    public Money convertedTo(Currency resultCurrency, FxRateProvider rateProvider) {
        if (this.currency.equals(resultCurrency)) {
            return this;
        }
        double converted = rateProvider.convert(this.amount.doubleValue(), this.currency, resultCurrency);
        return Money.of(resultCurrency, converted);
    }

    @Override
    public int compareTo(Money other) {
        return ComparisonChain.start().compare((Comparable)this.currency, (Comparable)other.currency).compare((Comparable)this.amount, (Comparable)other.amount).result();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            Money other = (Money)obj;
            return this.currency.equals(other.currency) && this.amount.equals(other.amount);
        }
        return false;
    }

    public int hashCode() {
        return this.currency.hashCode() * 31 + this.amount.hashCode();
    }

    @ToString
    public String toString() {
        return this.currency + " " + this.amount.toString();
    }
}

