/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.basics.date;

import com.google.common.base.Splitter;
import com.opengamma.strata.basics.date.HolidayCalendar;
import com.opengamma.strata.basics.date.NoHolidaysCalendar;
import com.opengamma.strata.basics.date.WeekendHolidayCalendar;
import com.opengamma.strata.collect.named.ExtendedEnum;

public final class HolidayCalendars {
    public static final HolidayCalendar NO_HOLIDAYS = NoHolidaysCalendar.INSTANCE;
    public static final HolidayCalendar SAT_SUN = WeekendHolidayCalendar.SAT_SUN;
    public static final HolidayCalendar FRI_SAT = WeekendHolidayCalendar.FRI_SAT;
    public static final HolidayCalendar THU_FRI = WeekendHolidayCalendar.THU_FRI;
    private static final ExtendedEnum<HolidayCalendar> ENUM_LOOKUP = ExtendedEnum.of(HolidayCalendar.class);

    public static HolidayCalendar of(String uniqueName) {
        if (uniqueName.contains("+")) {
            return Splitter.on((char)'+').splitToList((CharSequence)uniqueName).stream().map(HolidayCalendars::of).reduce(NO_HOLIDAYS, HolidayCalendar::combinedWith);
        }
        return (HolidayCalendar)ENUM_LOOKUP.lookup(uniqueName);
    }

    public static ExtendedEnum<HolidayCalendar> extendedEnum() {
        return ENUM_LOOKUP;
    }

    private HolidayCalendars() {
    }
}

