/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.basics.date;

import com.opengamma.strata.basics.date.DateAdjusters;
import com.opengamma.strata.basics.date.DayCount;
import com.opengamma.strata.basics.date.LocalDateUtils;
import com.opengamma.strata.basics.schedule.Frequency;
import java.time.LocalDate;

enum StandardDayCounts implements DayCount
{
    ONE_ONE("1/1"){

        @Override
        public double calculateYearFraction(LocalDate firstDate, LocalDate secondDate, DayCount.ScheduleInfo scheduleInfo) {
            return 1.0;
        }

        @Override
        public int calculateDays(LocalDate firstDate, LocalDate secondDate) {
            return 1;
        }
    }
    ,
    ACT_ACT_ISDA("Act/Act ISDA"){

        @Override
        public double calculateYearFraction(LocalDate firstDate, LocalDate secondDate, DayCount.ScheduleInfo scheduleInfo) {
            int y1 = firstDate.getYear();
            int y2 = secondDate.getYear();
            double firstYearLength = firstDate.lengthOfYear();
            if (y1 == y2) {
                double actualDays = LocalDateUtils.doy(secondDate) - LocalDateUtils.doy(firstDate);
                return actualDays / firstYearLength;
            }
            double firstRemainderOfYear = firstYearLength - (double)LocalDateUtils.doy(firstDate) + 1.0;
            double secondRemainderOfYear = LocalDateUtils.doy(secondDate) - 1;
            double secondYearLength = secondDate.lengthOfYear();
            return firstRemainderOfYear / firstYearLength + secondRemainderOfYear / secondYearLength + (double)(y2 - y1 - 1);
        }

        @Override
        public int calculateDays(LocalDate firstDate, LocalDate secondDate) {
            long actualDays = LocalDateUtils.daysBetween(firstDate, secondDate);
            return Math.toIntExact(actualDays);
        }
    }
    ,
    ACT_ACT_ICMA("Act/Act ICMA"){

        @Override
        public double calculateYearFraction(LocalDate firstDate, LocalDate secondDate, DayCount.ScheduleInfo scheduleInfo) {
            if (firstDate.equals(secondDate)) {
                return 0.0;
            }
            LocalDate scheduleStartDate = scheduleInfo.getStartDate();
            LocalDate scheduleEndDate = scheduleInfo.getEndDate();
            LocalDate nextCouponDate = scheduleInfo.getPeriodEndDate(firstDate);
            Frequency freq = scheduleInfo.getFrequency();
            boolean eom = scheduleInfo.isEndOfMonthConvention();
            if (nextCouponDate.equals(scheduleEndDate)) {
                return this.finalPeriod(firstDate, secondDate, freq, eom);
            }
            if (firstDate.equals(scheduleStartDate)) {
                return this.initPeriod(firstDate, secondDate, nextCouponDate, freq, eom);
            }
            double actualDays = LocalDateUtils.daysBetween(firstDate, secondDate);
            double periodDays = LocalDateUtils.daysBetween(firstDate, nextCouponDate);
            return actualDays / ((double)freq.eventsPerYear() * periodDays);
        }

        private double initPeriod(LocalDate startDate, LocalDate endDate, LocalDate couponDate, Frequency freq, boolean eom) {
            LocalDate currentNominal = couponDate;
            LocalDate prevNominal = this.eom(couponDate, currentNominal.minus(freq), eom);
            double result = 0.0;
            while (prevNominal.isAfter(startDate)) {
                result += this.calc(prevNominal, currentNominal, startDate, endDate, freq);
                currentNominal = prevNominal;
                prevNominal = this.eom(couponDate, currentNominal.minus(freq), eom);
            }
            return result + this.calc(prevNominal, currentNominal, startDate, endDate, freq);
        }

        private double finalPeriod(LocalDate couponDate, LocalDate endDate, Frequency freq, boolean eom) {
            LocalDate curNominal = couponDate;
            LocalDate nextNominal = this.eom(couponDate, curNominal.plus(freq), eom);
            double result = 0.0;
            while (nextNominal.isBefore(endDate)) {
                result += this.calc(curNominal, nextNominal, curNominal, endDate, freq);
                curNominal = nextNominal;
                nextNominal = this.eom(couponDate, curNominal.plus(freq), eom);
            }
            return result + this.calc(curNominal, nextNominal, curNominal, endDate, freq);
        }

        private LocalDate eom(LocalDate base, LocalDate calc, boolean eom) {
            return eom && base.getDayOfMonth() == base.lengthOfMonth() ? calc.withDayOfMonth(calc.lengthOfMonth()) : calc;
        }

        private double calc(LocalDate prevNominal, LocalDate curNominal, LocalDate start, LocalDate end, Frequency freq) {
            if (end.isAfter(prevNominal)) {
                long curNominalEpochDay = curNominal.toEpochDay();
                long prevNominalEpochDay = prevNominal.toEpochDay();
                long startEpochDay = start.toEpochDay();
                long endEpochDay = end.toEpochDay();
                double periodDays = curNominalEpochDay - prevNominalEpochDay;
                double actualDays = Math.min(endEpochDay, curNominalEpochDay) - Math.max(startEpochDay, prevNominalEpochDay);
                return actualDays / ((double)freq.eventsPerYear() * periodDays);
            }
            return 0.0;
        }

        @Override
        public int calculateDays(LocalDate firstDate, LocalDate secondDate) {
            long actualDays = LocalDateUtils.daysBetween(firstDate, secondDate);
            return Math.toIntExact(actualDays);
        }
    }
    ,
    ACT_ACT_AFB("Act/Act AFB"){

        @Override
        public double calculateYearFraction(LocalDate firstDate, LocalDate secondDate, DayCount.ScheduleInfo scheduleInfo) {
            LocalDate end = secondDate;
            LocalDate start = secondDate.minusYears(1L);
            int years = 0;
            while (!start.isBefore(firstDate)) {
                end = start;
                start = secondDate.minusYears(++years + 1);
            }
            long actualDays = LocalDateUtils.daysBetween(firstDate, end);
            LocalDate nextLeap = DateAdjusters.nextOrSameLeapDay(firstDate);
            return (double)years + (double)actualDays / (nextLeap.isBefore(end) ? 366.0 : 365.0);
        }

        @Override
        public int calculateDays(LocalDate firstDate, LocalDate secondDate) {
            long actualDays = LocalDateUtils.daysBetween(firstDate, secondDate);
            return Math.toIntExact(actualDays);
        }
    }
    ,
    ACT_ACT_YEAR("Act/Act Year"){

        @Override
        public double calculateYearFraction(LocalDate firstDate, LocalDate secondDate, DayCount.ScheduleInfo scheduleInfo) {
            LocalDate startDate = firstDate;
            int yearsAdded = 0;
            while (secondDate.compareTo(startDate.plusYears(1L)) > 0) {
                startDate = firstDate.plusYears(++yearsAdded);
            }
            double actualDays = LocalDateUtils.daysBetween(startDate, secondDate);
            double actualDaysInYear = LocalDateUtils.daysBetween(startDate, startDate.plusYears(1L));
            return (double)yearsAdded + actualDays / actualDaysInYear;
        }

        @Override
        public int calculateDays(LocalDate firstDate, LocalDate secondDate) {
            long actualDays = LocalDateUtils.daysBetween(firstDate, secondDate);
            return Math.toIntExact(actualDays);
        }
    }
    ,
    ACT_365_ACTUAL("Act/365 Actual"){

        @Override
        public double calculateYearFraction(LocalDate firstDate, LocalDate secondDate, DayCount.ScheduleInfo scheduleInfo) {
            long actualDays = LocalDateUtils.daysBetween(firstDate, secondDate);
            LocalDate nextLeap = DateAdjusters.nextLeapDay(firstDate);
            return (double)actualDays / (nextLeap.isAfter(secondDate) ? 365.0 : 366.0);
        }

        @Override
        public int calculateDays(LocalDate firstDate, LocalDate secondDate) {
            long actualDays = LocalDateUtils.daysBetween(firstDate, secondDate);
            return Math.toIntExact(actualDays);
        }
    }
    ,
    ACT_365L("Act/365L"){

        @Override
        public double calculateYearFraction(LocalDate firstDate, LocalDate secondDate, DayCount.ScheduleInfo scheduleInfo) {
            long actualDays = LocalDateUtils.daysBetween(firstDate, secondDate);
            if (firstDate.equals(secondDate)) {
                return 0.0;
            }
            LocalDate nextCouponDate = scheduleInfo.getPeriodEndDate(firstDate);
            if (scheduleInfo.getFrequency().isAnnual()) {
                LocalDate nextLeap = DateAdjusters.nextLeapDay(firstDate);
                return (double)actualDays / (nextLeap.isAfter(nextCouponDate) ? 365.0 : 366.0);
            }
            return (double)actualDays / (nextCouponDate.isLeapYear() ? 366.0 : 365.0);
        }

        @Override
        public int calculateDays(LocalDate firstDate, LocalDate secondDate) {
            long actualDays = LocalDateUtils.daysBetween(firstDate, secondDate);
            return Math.toIntExact(actualDays);
        }
    }
    ,
    ACT_360("Act/360"){

        @Override
        public double calculateYearFraction(LocalDate firstDate, LocalDate secondDate, DayCount.ScheduleInfo scheduleInfo) {
            return (double)LocalDateUtils.daysBetween(firstDate, secondDate) / 360.0;
        }

        @Override
        public int calculateDays(LocalDate firstDate, LocalDate secondDate) {
            long actualDays = LocalDateUtils.daysBetween(firstDate, secondDate);
            return Math.toIntExact(actualDays);
        }
    }
    ,
    ACT_364("Act/364"){

        @Override
        public double calculateYearFraction(LocalDate firstDate, LocalDate secondDate, DayCount.ScheduleInfo scheduleInfo) {
            return (double)LocalDateUtils.daysBetween(firstDate, secondDate) / 364.0;
        }

        @Override
        public int calculateDays(LocalDate firstDate, LocalDate secondDate) {
            long actualDays = LocalDateUtils.daysBetween(firstDate, secondDate);
            return Math.toIntExact(actualDays);
        }
    }
    ,
    ACT_365F("Act/365F"){

        @Override
        public double calculateYearFraction(LocalDate firstDate, LocalDate secondDate, DayCount.ScheduleInfo scheduleInfo) {
            return (double)LocalDateUtils.daysBetween(firstDate, secondDate) / 365.0;
        }

        @Override
        public int calculateDays(LocalDate firstDate, LocalDate secondDate) {
            long actualDays = LocalDateUtils.daysBetween(firstDate, secondDate);
            return Math.toIntExact(actualDays);
        }
    }
    ,
    ACT_365_25("Act/365.25"){

        @Override
        public double calculateYearFraction(LocalDate firstDate, LocalDate secondDate, DayCount.ScheduleInfo scheduleInfo) {
            return (double)LocalDateUtils.daysBetween(firstDate, secondDate) / 365.25;
        }

        @Override
        public int calculateDays(LocalDate firstDate, LocalDate secondDate) {
            long actualDays = LocalDateUtils.daysBetween(firstDate, secondDate);
            return Math.toIntExact(actualDays);
        }
    }
    ,
    NL_365("NL/365"){

        @Override
        public double calculateYearFraction(LocalDate firstDate, LocalDate secondDate, DayCount.ScheduleInfo scheduleInfo) {
            long actualDays = LocalDateUtils.daysBetween(firstDate, secondDate);
            int numberOfLeapDays = 0;
            LocalDate temp = DateAdjusters.nextLeapDay(firstDate);
            while (!temp.isAfter(secondDate)) {
                ++numberOfLeapDays;
                temp = DateAdjusters.nextLeapDay(temp);
            }
            return (double)(actualDays - (long)numberOfLeapDays) / 365.0;
        }

        @Override
        public int calculateDays(LocalDate firstDate, LocalDate secondDate) {
            long actualDays = LocalDateUtils.daysBetween(firstDate, secondDate);
            int numberOfLeapDays = 0;
            LocalDate temp = DateAdjusters.nextLeapDay(firstDate);
            while (!temp.isAfter(secondDate)) {
                ++numberOfLeapDays;
                temp = DateAdjusters.nextLeapDay(temp);
            }
            return Math.toIntExact(actualDays) - numberOfLeapDays;
        }
    }
    ,
    THIRTY_360_ISDA("30/360 ISDA"){

        @Override
        public double calculateYearFraction(LocalDate firstDate, LocalDate secondDate, DayCount.ScheduleInfo scheduleInfo) {
            int d1 = firstDate.getDayOfMonth();
            int d2 = secondDate.getDayOfMonth();
            if (d1 == 31) {
                d1 = 30;
            }
            if (d2 == 31 && d1 == 30) {
                d2 = 30;
            }
            return StandardDayCounts.thirty360(firstDate.getYear(), firstDate.getMonthValue(), d1, secondDate.getYear(), secondDate.getMonthValue(), d2);
        }

        @Override
        public int calculateDays(LocalDate firstDate, LocalDate secondDate) {
            int d1 = firstDate.getDayOfMonth();
            int d2 = secondDate.getDayOfMonth();
            if (d1 == 31) {
                d1 = 30;
            }
            if (d2 == 31 && d1 == 30) {
                d2 = 30;
            }
            return StandardDayCounts.thirty360Days(firstDate.getYear(), firstDate.getMonthValue(), d1, secondDate.getYear(), secondDate.getMonthValue(), d2);
        }
    }
    ,
    THIRTY_U_360("30U/360"){

        @Override
        public double calculateYearFraction(LocalDate firstDate, LocalDate secondDate, DayCount.ScheduleInfo scheduleInfo) {
            if (scheduleInfo.isEndOfMonthConvention()) {
                return THIRTY_U_360_EOM.calculateYearFraction(firstDate, secondDate, scheduleInfo);
            }
            return THIRTY_360_ISDA.calculateYearFraction(firstDate, secondDate, scheduleInfo);
        }

        @Override
        public int calculateDays(LocalDate firstDate, LocalDate secondDate) {
            return THIRTY_360_ISDA.days(firstDate, secondDate);
        }
    }
    ,
    THIRTY_U_360_EOM("30U/360 EOM"){

        @Override
        public double calculateYearFraction(LocalDate firstDate, LocalDate secondDate, DayCount.ScheduleInfo scheduleInfo) {
            int d1 = firstDate.getDayOfMonth();
            int d2 = secondDate.getDayOfMonth();
            if (StandardDayCounts.lastDayOfFebruary(firstDate)) {
                if (StandardDayCounts.lastDayOfFebruary(secondDate)) {
                    d2 = 30;
                }
                d1 = 30;
            }
            if (d1 == 31) {
                d1 = 30;
            }
            if (d2 == 31 && d1 == 30) {
                d2 = 30;
            }
            return StandardDayCounts.thirty360(firstDate.getYear(), firstDate.getMonthValue(), d1, secondDate.getYear(), secondDate.getMonthValue(), d2);
        }

        @Override
        public int calculateDays(LocalDate firstDate, LocalDate secondDate) {
            int d1 = firstDate.getDayOfMonth();
            int d2 = secondDate.getDayOfMonth();
            if (StandardDayCounts.lastDayOfFebruary(firstDate)) {
                if (StandardDayCounts.lastDayOfFebruary(secondDate)) {
                    d2 = 30;
                }
                d1 = 30;
            }
            if (d1 == 31) {
                d1 = 30;
            }
            if (d2 == 31 && d1 == 30) {
                d2 = 30;
            }
            return StandardDayCounts.thirty360Days(firstDate.getYear(), firstDate.getMonthValue(), d1, secondDate.getYear(), secondDate.getMonthValue(), d2);
        }
    }
    ,
    THIRTY_360_PSA("30/360 PSA"){

        @Override
        public double calculateYearFraction(LocalDate firstDate, LocalDate secondDate, DayCount.ScheduleInfo scheduleInfo) {
            int d1 = firstDate.getDayOfMonth();
            int d2 = secondDate.getDayOfMonth();
            if (d1 == 31 || StandardDayCounts.lastDayOfFebruary(firstDate)) {
                d1 = 30;
            }
            if (d2 == 31 && d1 == 30) {
                d2 = 30;
            }
            return StandardDayCounts.thirty360(firstDate.getYear(), firstDate.getMonthValue(), d1, secondDate.getYear(), secondDate.getMonthValue(), d2);
        }

        @Override
        public int calculateDays(LocalDate firstDate, LocalDate secondDate) {
            int d1 = firstDate.getDayOfMonth();
            int d2 = secondDate.getDayOfMonth();
            if (d1 == 31 || StandardDayCounts.lastDayOfFebruary(firstDate)) {
                d1 = 30;
            }
            if (d2 == 31 && d1 == 30) {
                d2 = 30;
            }
            return StandardDayCounts.thirty360Days(firstDate.getYear(), firstDate.getMonthValue(), d1, secondDate.getYear(), secondDate.getMonthValue(), d2);
        }
    }
    ,
    THIRTY_E_360_ISDA("30E/360 ISDA"){

        @Override
        public double calculateYearFraction(LocalDate firstDate, LocalDate secondDate, DayCount.ScheduleInfo scheduleInfo) {
            int d1 = firstDate.getDayOfMonth();
            int d2 = secondDate.getDayOfMonth();
            if (d1 == 31 || StandardDayCounts.lastDayOfFebruary(firstDate)) {
                d1 = 30;
            }
            if (d2 == 31 || StandardDayCounts.lastDayOfFebruary(secondDate) && !secondDate.equals(scheduleInfo.getEndDate())) {
                d2 = 30;
            }
            return StandardDayCounts.thirty360(firstDate.getYear(), firstDate.getMonthValue(), d1, secondDate.getYear(), secondDate.getMonthValue(), d2);
        }

        @Override
        public int calculateDays(LocalDate firstDate, LocalDate secondDate) {
            int d1 = firstDate.getDayOfMonth();
            int d2 = secondDate.getDayOfMonth();
            if (d1 == 31 || StandardDayCounts.lastDayOfFebruary(firstDate)) {
                d1 = 30;
            }
            if (d2 == 31 || StandardDayCounts.lastDayOfFebruary(secondDate)) {
                d2 = 30;
            }
            return StandardDayCounts.thirty360Days(firstDate.getYear(), firstDate.getMonthValue(), d1, secondDate.getYear(), secondDate.getMonthValue(), d2);
        }
    }
    ,
    THIRTY_E_360("30E/360"){

        @Override
        public double calculateYearFraction(LocalDate firstDate, LocalDate secondDate, DayCount.ScheduleInfo scheduleInfo) {
            int d1 = firstDate.getDayOfMonth();
            int d2 = secondDate.getDayOfMonth();
            if (d1 == 31) {
                d1 = 30;
            }
            if (d2 == 31) {
                d2 = 30;
            }
            return StandardDayCounts.thirty360(firstDate.getYear(), firstDate.getMonthValue(), d1, secondDate.getYear(), secondDate.getMonthValue(), d2);
        }

        @Override
        public int calculateDays(LocalDate firstDate, LocalDate secondDate) {
            int d1 = firstDate.getDayOfMonth();
            int d2 = secondDate.getDayOfMonth();
            if (d1 == 31) {
                d1 = 30;
            }
            if (d2 == 31) {
                d2 = 30;
            }
            return StandardDayCounts.thirty360Days(firstDate.getYear(), firstDate.getMonthValue(), d1, secondDate.getYear(), secondDate.getMonthValue(), d2);
        }
    }
    ,
    THIRTY_EPLUS_360("30E+/360"){

        @Override
        public double calculateYearFraction(LocalDate firstDate, LocalDate secondDate, DayCount.ScheduleInfo scheduleInfo) {
            int d1 = firstDate.getDayOfMonth();
            int d2 = secondDate.getDayOfMonth();
            int m1 = firstDate.getMonthValue();
            int m2 = secondDate.getMonthValue();
            if (d1 == 31) {
                d1 = 30;
            }
            if (d2 == 31) {
                d2 = 1;
                ++m2;
            }
            return StandardDayCounts.thirty360(firstDate.getYear(), m1, d1, secondDate.getYear(), m2, d2);
        }

        @Override
        public int calculateDays(LocalDate firstDate, LocalDate secondDate) {
            int d1 = firstDate.getDayOfMonth();
            int d2 = secondDate.getDayOfMonth();
            int m1 = firstDate.getMonthValue();
            int m2 = secondDate.getMonthValue();
            if (d1 == 31) {
                d1 = 30;
            }
            if (d2 == 31) {
                d2 = 1;
                ++m2;
            }
            return StandardDayCounts.thirty360Days(firstDate.getYear(), m1, d1, secondDate.getYear(), m2, d2);
        }
    };

    private final String name;

    private StandardDayCounts(String name) {
        this.name = name;
    }

    private static double thirty360(int y1, int m1, int d1, int y2, int m2, int d2) {
        return (double)(360 * (y2 - y1) + 30 * (m2 - m1) + (d2 - d1)) / 360.0;
    }

    private static int thirty360Days(int y1, int m1, int d1, int y2, int m2, int d2) {
        return 360 * (y2 - y1) + 30 * (m2 - m1) + (d2 - d1);
    }

    private static boolean lastDayOfFebruary(LocalDate date) {
        return date.getMonthValue() == 2 && date.getDayOfMonth() == date.lengthOfMonth();
    }

    @Override
    public double yearFraction(LocalDate firstDate, LocalDate secondDate, DayCount.ScheduleInfo scheduleInfo) {
        if (secondDate.isBefore(firstDate)) {
            throw new IllegalArgumentException("Dates must be in time-line order");
        }
        return this.calculateYearFraction(firstDate, secondDate, scheduleInfo);
    }

    @Override
    public int days(LocalDate firstDate, LocalDate secondDate) {
        if (secondDate.isBefore(firstDate)) {
            throw new IllegalArgumentException("Dates must be in time-line order");
        }
        return this.calculateDays(firstDate, secondDate);
    }

    @Override
    public double relativeYearFraction(LocalDate firstDate, LocalDate secondDate, DayCount.ScheduleInfo scheduleInfo) {
        if (secondDate.isBefore(firstDate)) {
            return -this.calculateYearFraction(secondDate, firstDate, scheduleInfo);
        }
        return this.calculateYearFraction(firstDate, secondDate, scheduleInfo);
    }

    abstract double calculateYearFraction(LocalDate var1, LocalDate var2, DayCount.ScheduleInfo var3);

    abstract int calculateDays(LocalDate var1, LocalDate var2);

    @Override
    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }
}

