/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.basics.schedule;

import com.opengamma.strata.basics.schedule.DayRollConventions;
import com.opengamma.strata.basics.schedule.Frequency;
import com.opengamma.strata.basics.schedule.RollConventions;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.named.ExtendedEnum;
import com.opengamma.strata.collect.named.Named;
import java.time.DayOfWeek;
import java.time.LocalDate;
import org.joda.convert.FromString;
import org.joda.convert.ToString;

public interface RollConvention
extends Named {
    @FromString
    public static RollConvention of(String uniqueName) {
        ArgChecker.notNull((Object)uniqueName, (String)"uniqueName");
        return (RollConvention)RollConvention.extendedEnum().lookup(uniqueName);
    }

    public static RollConvention ofDayOfMonth(int dayOfMonth) {
        return DayRollConventions.Dom.of(dayOfMonth);
    }

    public static RollConvention ofDayOfWeek(DayOfWeek dayOfWeek) {
        return DayRollConventions.Dow.of(dayOfWeek);
    }

    public static ExtendedEnum<RollConvention> extendedEnum() {
        return RollConventions.ENUM_LOOKUP;
    }

    public LocalDate adjust(LocalDate var1);

    default public boolean matches(LocalDate date) {
        ArgChecker.notNull((Object)date, (String)"date");
        return date.equals(this.adjust(date));
    }

    default public LocalDate next(LocalDate date, Frequency periodicFrequency) {
        ArgChecker.notNull((Object)date, (String)"date");
        ArgChecker.notNull((Object)periodicFrequency, (String)"periodicFrequency");
        LocalDate calculated = this.adjust(date.plus(periodicFrequency));
        if (!calculated.isAfter(date)) {
            calculated = this.adjust(date.plusMonths(1L));
        }
        return calculated;
    }

    default public LocalDate previous(LocalDate date, Frequency periodicFrequency) {
        ArgChecker.notNull((Object)date, (String)"date");
        ArgChecker.notNull((Object)periodicFrequency, (String)"periodicFrequency");
        LocalDate calculated = this.adjust(date.minus(periodicFrequency));
        if (!calculated.isBefore(date)) {
            calculated = this.adjust(date.minusMonths(1L));
        }
        return calculated;
    }

    default public int getDayOfMonth() {
        return 0;
    }

    @ToString
    public String getName();
}

