/*
 * Decompiled with CFR 0.152.
 */
package cdm.base.datetime;

import cdm.base.datetime.BusinessCenters;
import cdm.base.datetime.BusinessDayConventionEnum;
import cdm.base.datetime.DateRange;
import cdm.base.datetime.meta.BusinessDateRangeMeta;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.model.lib.records.Date;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="BusinessDateRange", builder=BusinessDateRangeBuilderImpl.class, version="5.27.0")
@RuneDataType(value="BusinessDateRange", model="cdm", builder=BusinessDateRangeBuilderImpl.class, version="5.27.0")
public interface BusinessDateRange
extends DateRange {
    public static final BusinessDateRangeMeta metaData = new BusinessDateRangeMeta();

    public BusinessDayConventionEnum getBusinessDayConvention();

    public BusinessCenters getBusinessCenters();

    @Override
    public BusinessDateRange build();

    @Override
    public BusinessDateRangeBuilder toBuilder();

    public static BusinessDateRangeBuilder builder() {
        return new BusinessDateRangeBuilderImpl();
    }

    default public RosettaMetaData<? extends BusinessDateRange> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends BusinessDateRange> getType() {
        return BusinessDateRange.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("startDate"), Date.class, (Object)this.getStartDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("endDate"), Date.class, (Object)this.getEndDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("businessDayConvention"), BusinessDayConventionEnum.class, (Object)this.getBusinessDayConvention(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("businessCenters"), processor, BusinessCenters.class, this.getBusinessCenters(), new AttributeMeta[0]);
    }

    public static class BusinessDateRangeBuilderImpl
    extends DateRange.DateRangeBuilderImpl
    implements BusinessDateRangeBuilder {
        protected BusinessDayConventionEnum businessDayConvention;
        protected BusinessCenters.BusinessCentersBuilder businessCenters;

        @Override
        @RosettaAttribute(value="businessDayConvention", isRequired=true)
        @RuneAttribute(value="businessDayConvention", isRequired=true)
        public BusinessDayConventionEnum getBusinessDayConvention() {
            return this.businessDayConvention;
        }

        @Override
        @RosettaAttribute(value="businessCenters")
        @RuneAttribute(value="businessCenters")
        public BusinessCenters.BusinessCentersBuilder getBusinessCenters() {
            return this.businessCenters;
        }

        @Override
        public BusinessCenters.BusinessCentersBuilder getOrCreateBusinessCenters() {
            BusinessCenters.BusinessCentersBuilder result = this.businessCenters != null ? this.businessCenters : (this.businessCenters = BusinessCenters.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="startDate", isRequired=true)
        @RuneAttribute(value="startDate", isRequired=true)
        public BusinessDateRangeBuilder setStartDate(Date _startDate) {
            this.startDate = _startDate == null ? null : _startDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="endDate", isRequired=true)
        @RuneAttribute(value="endDate", isRequired=true)
        public BusinessDateRangeBuilder setEndDate(Date _endDate) {
            this.endDate = _endDate == null ? null : _endDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="businessDayConvention", isRequired=true)
        @RuneAttribute(value="businessDayConvention", isRequired=true)
        public BusinessDateRangeBuilder setBusinessDayConvention(BusinessDayConventionEnum _businessDayConvention) {
            this.businessDayConvention = _businessDayConvention == null ? null : _businessDayConvention;
            return this;
        }

        @Override
        @RosettaAttribute(value="businessCenters")
        @RuneAttribute(value="businessCenters")
        public BusinessDateRangeBuilder setBusinessCenters(BusinessCenters _businessCenters) {
            this.businessCenters = _businessCenters == null ? null : _businessCenters.toBuilder();
            return this;
        }

        @Override
        public BusinessDateRange build() {
            return new BusinessDateRangeImpl(this);
        }

        @Override
        public BusinessDateRangeBuilder toBuilder() {
            return this;
        }

        @Override
        public BusinessDateRangeBuilder prune() {
            super.prune();
            if (this.businessCenters != null && !this.businessCenters.prune().hasData()) {
                this.businessCenters = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getBusinessDayConvention() != null) {
                return true;
            }
            return this.getBusinessCenters() != null && this.getBusinessCenters().hasData();
        }

        @Override
        public BusinessDateRangeBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            BusinessDateRangeBuilder o = (BusinessDateRangeBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getBusinessCenters(), (RosettaModelObjectBuilder)o.getBusinessCenters(), this::setBusinessCenters);
            merger.mergeBasic((Object)this.getBusinessDayConvention(), (Object)o.getBusinessDayConvention(), this::setBusinessDayConvention, new AttributeMeta[0]);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            BusinessDateRange _that = (BusinessDateRange)this.getType().cast(o);
            if (!Objects.equals((Object)this.businessDayConvention, (Object)_that.getBusinessDayConvention())) {
                return false;
            }
            return Objects.equals(this.businessCenters, _that.getBusinessCenters());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.businessDayConvention != null ? ((Object)((Object)this.businessDayConvention)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.businessCenters != null ? this.businessCenters.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "BusinessDateRangeBuilder {businessDayConvention=" + (Object)((Object)this.businessDayConvention) + ", businessCenters=" + this.businessCenters + '}' + " " + super.toString();
        }
    }

    public static interface BusinessDateRangeBuilder
    extends BusinessDateRange,
    DateRange.DateRangeBuilder {
        public BusinessCenters.BusinessCentersBuilder getOrCreateBusinessCenters();

        @Override
        public BusinessCenters.BusinessCentersBuilder getBusinessCenters();

        @Override
        public BusinessDateRangeBuilder setStartDate(Date var1);

        @Override
        public BusinessDateRangeBuilder setEndDate(Date var1);

        public BusinessDateRangeBuilder setBusinessDayConvention(BusinessDayConventionEnum var1);

        public BusinessDateRangeBuilder setBusinessCenters(BusinessCenters var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("startDate"), Date.class, (Object)this.getStartDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("endDate"), Date.class, (Object)this.getEndDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("businessDayConvention"), BusinessDayConventionEnum.class, (Object)this.getBusinessDayConvention(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("businessCenters"), processor, BusinessCenters.BusinessCentersBuilder.class, this.getBusinessCenters(), new AttributeMeta[0]);
        }

        @Override
        public BusinessDateRangeBuilder prune();
    }

    public static class BusinessDateRangeImpl
    extends DateRange.DateRangeImpl
    implements BusinessDateRange {
        private final BusinessDayConventionEnum businessDayConvention;
        private final BusinessCenters businessCenters;

        protected BusinessDateRangeImpl(BusinessDateRangeBuilder builder) {
            super(builder);
            this.businessDayConvention = builder.getBusinessDayConvention();
            this.businessCenters = Optional.ofNullable(builder.getBusinessCenters()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="businessDayConvention", isRequired=true)
        @RuneAttribute(value="businessDayConvention", isRequired=true)
        public BusinessDayConventionEnum getBusinessDayConvention() {
            return this.businessDayConvention;
        }

        @Override
        @RosettaAttribute(value="businessCenters")
        @RuneAttribute(value="businessCenters")
        public BusinessCenters getBusinessCenters() {
            return this.businessCenters;
        }

        @Override
        public BusinessDateRange build() {
            return this;
        }

        @Override
        public BusinessDateRangeBuilder toBuilder() {
            BusinessDateRangeBuilder builder = BusinessDateRange.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(BusinessDateRangeBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getBusinessDayConvention()).ifPresent(builder::setBusinessDayConvention);
            Optional.ofNullable(this.getBusinessCenters()).ifPresent(builder::setBusinessCenters);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            BusinessDateRange _that = (BusinessDateRange)this.getType().cast(o);
            if (!Objects.equals((Object)this.businessDayConvention, (Object)_that.getBusinessDayConvention())) {
                return false;
            }
            return Objects.equals(this.businessCenters, _that.getBusinessCenters());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.businessDayConvention != null ? ((Object)((Object)this.businessDayConvention)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.businessCenters != null ? this.businessCenters.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "BusinessDateRange {businessDayConvention=" + (Object)((Object)this.businessDayConvention) + ", businessCenters=" + this.businessCenters + '}' + " " + super.toString();
        }
    }
}

