/*
 * Decompiled with CFR 0.152.
 */
package cdm.base.datetime.functions;

import cdm.base.datetime.BusinessCenterEnum;
import cdm.base.datetime.functions.AddDays;
import cdm.base.datetime.functions.IsBusinessDay;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.expression.MapperMaths;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.records.Date;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;

@ImplementedBy(value=AddBusinessDaysDefault.class)
public abstract class AddBusinessDays
implements RosettaFunction {
    @Inject
    protected AddBusinessDays addBusinessDays;
    @Inject
    protected AddDays addDays;
    @Inject
    protected IsBusinessDay isBusinessDay;

    public Date evaluate(Date originalDate, Integer offsetBusinessDays, List<BusinessCenterEnum> businessCenters) {
        Date shiftedDate = this.doEvaluate(originalDate, offsetBusinessDays, businessCenters);
        return shiftedDate;
    }

    protected abstract Date doEvaluate(Date var1, Integer var2, List<BusinessCenterEnum> var3);

    protected abstract MapperS<Boolean> isGoodBusinessDay(Date var1, Integer var2, List<BusinessCenterEnum> var3);

    protected abstract MapperS<Integer> shift(Date var1, Integer var2, List<BusinessCenterEnum> var3);

    protected abstract MapperS<Date> shiftedByOne(Date var1, Integer var2, List<BusinessCenterEnum> var3);

    protected abstract MapperS<Boolean> isShiftedGood(Date var1, Integer var2, List<BusinessCenterEnum> var3);

    protected abstract MapperS<Integer> newShift(Date var1, Integer var2, List<BusinessCenterEnum> var3);

    protected abstract MapperS<Integer> newOffset(Date var1, Integer var2, List<BusinessCenterEnum> var3);

    protected abstract MapperS<Boolean> done(Date var1, Integer var2, List<BusinessCenterEnum> var3);

    protected abstract MapperS<Date> newDate(Date var1, Integer var2, List<BusinessCenterEnum> var3);

    public static class AddBusinessDaysDefault
    extends AddBusinessDays {
        @Override
        protected Date doEvaluate(Date originalDate, Integer offsetBusinessDays, List<BusinessCenterEnum> businessCenters) {
            if (businessCenters == null) {
                businessCenters = Collections.emptyList();
            }
            Date shiftedDate = null;
            return this.assignOutput(shiftedDate, originalDate, offsetBusinessDays, businessCenters);
        }

        protected Date assignOutput(Date shiftedDate, Date originalDate, Integer offsetBusinessDays, List<BusinessCenterEnum> businessCenters) {
            shiftedDate = (Date)this.newDate(originalDate, offsetBusinessDays, businessCenters).get();
            return shiftedDate;
        }

        @Override
        protected MapperS<Boolean> isGoodBusinessDay(Date originalDate, Integer offsetBusinessDays, List<BusinessCenterEnum> businessCenters) {
            return MapperS.of((Object)this.isBusinessDay.evaluate(originalDate, businessCenters));
        }

        @Override
        protected MapperS<Integer> shift(Date originalDate, Integer offsetBusinessDays, List<BusinessCenterEnum> businessCenters) {
            if (ExpressionOperators.lessThan((Mapper)MapperS.of((Object)offsetBusinessDays), (Mapper)MapperS.of((Object)0), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                return MapperS.of((Object)-1);
            }
            return MapperS.of((Object)1);
        }

        @Override
        protected MapperS<Date> shiftedByOne(Date originalDate, Integer offsetBusinessDays, List<BusinessCenterEnum> businessCenters) {
            return MapperS.of((Object)this.addDays.evaluate(originalDate, (Integer)this.shift(originalDate, offsetBusinessDays, businessCenters).get()));
        }

        @Override
        protected MapperS<Boolean> isShiftedGood(Date originalDate, Integer offsetBusinessDays, List<BusinessCenterEnum> businessCenters) {
            return MapperS.of((Object)this.isBusinessDay.evaluate((Date)this.shiftedByOne(originalDate, offsetBusinessDays, businessCenters).get(), businessCenters));
        }

        @Override
        protected MapperS<Integer> newShift(Date originalDate, Integer offsetBusinessDays, List<BusinessCenterEnum> businessCenters) {
            if (((Boolean)this.isShiftedGood(originalDate, offsetBusinessDays, businessCenters).getOrDefault((Object)false)).booleanValue()) {
                return this.shift(originalDate, offsetBusinessDays, businessCenters);
            }
            return MapperS.of((Object)0);
        }

        @Override
        protected MapperS<Integer> newOffset(Date originalDate, Integer offsetBusinessDays, List<BusinessCenterEnum> businessCenters) {
            if (ExpressionOperators.areEqual((Mapper)MapperS.of((Object)offsetBusinessDays), (Mapper)MapperS.of((Object)0), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                return MapperS.of((Object)0);
            }
            return MapperMaths.subtract((Mapper)MapperS.of((Object)offsetBusinessDays), this.newShift(originalDate, offsetBusinessDays, businessCenters));
        }

        @Override
        protected MapperS<Boolean> done(Date originalDate, Integer offsetBusinessDays, List<BusinessCenterEnum> businessCenters) {
            return ExpressionOperators.areEqual((Mapper)MapperS.of((Object)offsetBusinessDays), (Mapper)MapperS.of((Object)0), (CardinalityOperator)CardinalityOperator.All).and(ExpressionOperators.areEqual(this.isGoodBusinessDay(originalDate, offsetBusinessDays, businessCenters), (Mapper)MapperS.of((Object)true), (CardinalityOperator)CardinalityOperator.All)).asMapper();
        }

        @Override
        protected MapperS<Date> newDate(Date originalDate, Integer offsetBusinessDays, List<BusinessCenterEnum> businessCenters) {
            if (((Boolean)this.done(originalDate, offsetBusinessDays, businessCenters).getOrDefault((Object)false)).booleanValue()) {
                return MapperS.of((Object)originalDate);
            }
            return MapperS.of((Object)this.addBusinessDays.evaluate((Date)this.shiftedByOne(originalDate, offsetBusinessDays, businessCenters).get(), (Integer)this.newOffset(originalDate, offsetBusinessDays, businessCenters).get(), businessCenters));
        }
    }
}

