/*
 * Decompiled with CFR 0.152.
 */
package cdm.base.math;

import com.rosetta.model.lib.annotations.RosettaEnum;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

@RosettaEnum(value="FinancialUnitEnum")
public enum FinancialUnitEnum {
    CONTRACT("Contract", null),
    CONTRACTUAL_PRODUCT("ContractualProduct", null),
    INDEX_UNIT("IndexUnit", null),
    LOG_NORMAL_VOLATILITY("LogNormalVolatility", null),
    SHARE("Share", null),
    VALUE_PER_DAY("ValuePerDay", null),
    VALUE_PER_PERCENT("ValuePerPercent", null),
    WEIGHT("Weight", null);

    private static Map<String, FinancialUnitEnum> values;
    private final String rosettaName;
    private final String displayName;

    private FinancialUnitEnum(String rosettaName, String displayName) {
        this.rosettaName = rosettaName;
        this.displayName = displayName;
    }

    public static FinancialUnitEnum fromDisplayName(String name) {
        FinancialUnitEnum value = values.get(name);
        if (value == null) {
            throw new IllegalArgumentException("No enum constant with display name \"" + name + "\".");
        }
        return value;
    }

    public String toString() {
        return this.toDisplayString();
    }

    public String toDisplayString() {
        return this.displayName != null ? this.displayName : this.rosettaName;
    }

    static {
        ConcurrentHashMap<String, FinancialUnitEnum> map = new ConcurrentHashMap<String, FinancialUnitEnum>();
        for (FinancialUnitEnum instance : FinancialUnitEnum.values()) {
            map.put(instance.toDisplayString(), instance);
        }
        values = Collections.unmodifiableMap(map);
    }
}

