/*
 * Decompiled with CFR 0.152.
 */
package cdm.base.math;

import cdm.base.datetime.Frequency;
import cdm.base.math.DatedValue;
import cdm.base.math.Measure;
import cdm.base.math.MeasureSchedule;
import cdm.base.math.UnitType;
import cdm.base.math.meta.QuantityScheduleMeta;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="QuantitySchedule", builder=QuantityScheduleBuilderImpl.class, version="5.27.0")
@RuneDataType(value="QuantitySchedule", model="cdm", builder=QuantityScheduleBuilderImpl.class, version="5.27.0")
public interface QuantitySchedule
extends MeasureSchedule {
    public static final QuantityScheduleMeta metaData = new QuantityScheduleMeta();

    public Measure getMultiplier();

    public Frequency getFrequency();

    @Override
    public QuantitySchedule build();

    @Override
    public QuantityScheduleBuilder toBuilder();

    public static QuantityScheduleBuilder builder() {
        return new QuantityScheduleBuilderImpl();
    }

    default public RosettaMetaData<? extends QuantitySchedule> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends QuantitySchedule> getType() {
        return QuantitySchedule.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("value"), BigDecimal.class, (Object)this.getValue(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("unit"), processor, UnitType.class, this.getUnit(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("datedValue"), processor, DatedValue.class, this.getDatedValue(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("multiplier"), processor, Measure.class, this.getMultiplier(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("frequency"), processor, Frequency.class, this.getFrequency(), new AttributeMeta[0]);
    }

    public static class QuantityScheduleBuilderImpl
    extends MeasureSchedule.MeasureScheduleBuilderImpl
    implements QuantityScheduleBuilder {
        protected Measure.MeasureBuilder multiplier;
        protected Frequency.FrequencyBuilder frequency;

        @Override
        @RosettaAttribute(value="multiplier")
        @RuneAttribute(value="multiplier")
        public Measure.MeasureBuilder getMultiplier() {
            return this.multiplier;
        }

        @Override
        public Measure.MeasureBuilder getOrCreateMultiplier() {
            Measure.MeasureBuilder result = this.multiplier != null ? this.multiplier : (this.multiplier = Measure.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="frequency")
        @RuneAttribute(value="frequency")
        public Frequency.FrequencyBuilder getFrequency() {
            return this.frequency;
        }

        @Override
        public Frequency.FrequencyBuilder getOrCreateFrequency() {
            Frequency.FrequencyBuilder result = this.frequency != null ? this.frequency : (this.frequency = Frequency.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="value")
        @RuneAttribute(value="value")
        public QuantityScheduleBuilder setValue(BigDecimal _value) {
            this.value = _value == null ? null : _value;
            return this;
        }

        @Override
        @RosettaAttribute(value="unit")
        @RuneAttribute(value="unit")
        public QuantityScheduleBuilder setUnit(UnitType _unit) {
            this.unit = _unit == null ? null : _unit.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="datedValue")
        @RuneAttribute(value="datedValue")
        public QuantityScheduleBuilder addDatedValue(DatedValue _datedValue) {
            if (_datedValue != null) {
                this.datedValue.add(_datedValue.toBuilder());
            }
            return this;
        }

        @Override
        public QuantityScheduleBuilder addDatedValue(DatedValue _datedValue, int idx) {
            this.getIndex(this.datedValue, idx, () -> _datedValue.toBuilder());
            return this;
        }

        @Override
        public QuantityScheduleBuilder addDatedValue(List<? extends DatedValue> datedValues) {
            if (datedValues != null) {
                for (DatedValue datedValue : datedValues) {
                    this.datedValue.add(datedValue.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="datedValue")
        public QuantityScheduleBuilder setDatedValue(List<? extends DatedValue> datedValues) {
            this.datedValue = datedValues == null ? new ArrayList() : (List)datedValues.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="multiplier")
        @RuneAttribute(value="multiplier")
        public QuantityScheduleBuilder setMultiplier(Measure _multiplier) {
            this.multiplier = _multiplier == null ? null : _multiplier.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="frequency")
        @RuneAttribute(value="frequency")
        public QuantityScheduleBuilder setFrequency(Frequency _frequency) {
            this.frequency = _frequency == null ? null : _frequency.toBuilder();
            return this;
        }

        @Override
        public QuantitySchedule build() {
            return new QuantityScheduleImpl(this);
        }

        @Override
        public QuantityScheduleBuilder toBuilder() {
            return this;
        }

        @Override
        public QuantityScheduleBuilder prune() {
            super.prune();
            if (this.multiplier != null && !this.multiplier.prune().hasData()) {
                this.multiplier = null;
            }
            if (this.frequency != null && !this.frequency.prune().hasData()) {
                this.frequency = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getMultiplier() != null && this.getMultiplier().hasData()) {
                return true;
            }
            return this.getFrequency() != null && this.getFrequency().hasData();
        }

        @Override
        public QuantityScheduleBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            QuantityScheduleBuilder o = (QuantityScheduleBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getMultiplier(), (RosettaModelObjectBuilder)o.getMultiplier(), this::setMultiplier);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getFrequency(), (RosettaModelObjectBuilder)o.getFrequency(), this::setFrequency);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            QuantitySchedule _that = (QuantitySchedule)this.getType().cast(o);
            if (!Objects.equals(this.multiplier, _that.getMultiplier())) {
                return false;
            }
            return Objects.equals(this.frequency, _that.getFrequency());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.multiplier != null ? this.multiplier.hashCode() : 0);
            _result = 31 * _result + (this.frequency != null ? this.frequency.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "QuantityScheduleBuilder {multiplier=" + this.multiplier + ", frequency=" + this.frequency + '}' + " " + super.toString();
        }
    }

    public static interface QuantityScheduleBuilder
    extends QuantitySchedule,
    MeasureSchedule.MeasureScheduleBuilder {
        public Measure.MeasureBuilder getOrCreateMultiplier();

        @Override
        public Measure.MeasureBuilder getMultiplier();

        public Frequency.FrequencyBuilder getOrCreateFrequency();

        @Override
        public Frequency.FrequencyBuilder getFrequency();

        @Override
        public QuantityScheduleBuilder setValue(BigDecimal var1);

        @Override
        public QuantityScheduleBuilder setUnit(UnitType var1);

        @Override
        public QuantityScheduleBuilder addDatedValue(DatedValue var1);

        @Override
        public QuantityScheduleBuilder addDatedValue(DatedValue var1, int var2);

        @Override
        public QuantityScheduleBuilder addDatedValue(List<? extends DatedValue> var1);

        @Override
        public QuantityScheduleBuilder setDatedValue(List<? extends DatedValue> var1);

        public QuantityScheduleBuilder setMultiplier(Measure var1);

        public QuantityScheduleBuilder setFrequency(Frequency var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("value"), BigDecimal.class, (Object)this.getValue(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("unit"), processor, UnitType.UnitTypeBuilder.class, (RosettaModelObjectBuilder)this.getUnit(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("datedValue"), processor, DatedValue.DatedValueBuilder.class, this.getDatedValue(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("multiplier"), processor, Measure.MeasureBuilder.class, this.getMultiplier(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("frequency"), processor, Frequency.FrequencyBuilder.class, this.getFrequency(), new AttributeMeta[0]);
        }

        @Override
        public QuantityScheduleBuilder prune();
    }

    public static class QuantityScheduleImpl
    extends MeasureSchedule.MeasureScheduleImpl
    implements QuantitySchedule {
        private final Measure multiplier;
        private final Frequency frequency;

        protected QuantityScheduleImpl(QuantityScheduleBuilder builder) {
            super(builder);
            this.multiplier = Optional.ofNullable(builder.getMultiplier()).map(f -> f.build()).orElse(null);
            this.frequency = Optional.ofNullable(builder.getFrequency()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="multiplier")
        @RuneAttribute(value="multiplier")
        public Measure getMultiplier() {
            return this.multiplier;
        }

        @Override
        @RosettaAttribute(value="frequency")
        @RuneAttribute(value="frequency")
        public Frequency getFrequency() {
            return this.frequency;
        }

        @Override
        public QuantitySchedule build() {
            return this;
        }

        @Override
        public QuantityScheduleBuilder toBuilder() {
            QuantityScheduleBuilder builder = QuantitySchedule.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(QuantityScheduleBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getMultiplier()).ifPresent(builder::setMultiplier);
            Optional.ofNullable(this.getFrequency()).ifPresent(builder::setFrequency);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            QuantitySchedule _that = (QuantitySchedule)this.getType().cast(o);
            if (!Objects.equals(this.multiplier, _that.getMultiplier())) {
                return false;
            }
            return Objects.equals(this.frequency, _that.getFrequency());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.multiplier != null ? this.multiplier.hashCode() : 0);
            _result = 31 * _result + (this.frequency != null ? this.frequency.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "QuantitySchedule {multiplier=" + this.multiplier + ", frequency=" + this.frequency + '}' + " " + super.toString();
        }
    }
}

