/*
 * Decompiled with CFR 0.152.
 */
package cdm.base.math.processor;

import cdm.base.math.FinancialUnitEnum;
import cdm.base.math.UnitType;
import com.regnosys.rosetta.common.translation.MappingContext;
import com.regnosys.rosetta.common.translation.MappingProcessor;
import com.regnosys.rosetta.common.translation.MappingProcessorUtils;
import com.regnosys.rosetta.common.translation.Path;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.path.RosettaPath;
import java.util.List;
import java.util.Optional;

public class OpenUnitsMappingProcessor
extends MappingProcessor {
    public OpenUnitsMappingProcessor(RosettaPath modelPath, List<Path> synonymPaths, MappingContext context) {
        super(modelPath, synonymPaths, context);
    }

    public <T> void mapBasic(Path openUnitPath, Optional<T> instance, RosettaModelObjectBuilder parent) {
        UnitType.UnitTypeBuilder unitTypeBuilder = (UnitType.UnitTypeBuilder)parent;
        this.setQuantityUnit(unitTypeBuilder, this.getSingleUnderlierPath(openUnitPath, "equity"), FinancialUnitEnum.SHARE);
        this.setQuantityUnit(unitTypeBuilder, this.getSingleUnderlierPath(openUnitPath, "bond"), FinancialUnitEnum.SHARE);
        this.setQuantityUnit(unitTypeBuilder, this.getSingleUnderlierPath(openUnitPath, "index"), FinancialUnitEnum.INDEX_UNIT);
        this.setQuantityUnit(unitTypeBuilder, this.getBasketConstituentPath(openUnitPath, "equity"), FinancialUnitEnum.SHARE);
        this.setQuantityUnit(unitTypeBuilder, this.getBasketConstituentPath(openUnitPath, "bond"), FinancialUnitEnum.SHARE);
        this.setQuantityUnit(unitTypeBuilder, this.getBasketConstituentPath(openUnitPath, "index"), FinancialUnitEnum.INDEX_UNIT);
    }

    private Path getSingleUnderlierPath(Path openUnitPath, String lastElement) {
        return openUnitPath.getParent().addElement(lastElement);
    }

    private Path getBasketConstituentPath(Path openUnitPath, String lastElement) {
        return openUnitPath.getParent().getParent().addElement(lastElement);
    }

    private void setQuantityUnit(UnitType.UnitTypeBuilder unitTypeBuilder, Path synonymPath, FinancialUnitEnum financialUnit) {
        MappingProcessorUtils.getNonNullMappedValue((List)this.getMappings(), (Path)synonymPath, (String[])new String[0]).ifPresent(x -> unitTypeBuilder.setFinancialUnit(financialUnit));
    }
}

