/*
 * Decompiled with CFR 0.152.
 */
package cdm.base.staticdata.asset.common;

import com.rosetta.model.lib.annotations.RosettaEnum;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

@RosettaEnum(value="IssuerTypeEnum")
public enum IssuerTypeEnum {
    SUPRA_NATIONAL("SupraNational", null),
    SOVEREIGN_CENTRAL_BANK("SovereignCentralBank", null),
    QUASI_GOVERNMENT("QuasiGovernment", null),
    REGIONAL_GOVERNMENT("RegionalGovernment", null),
    CORPORATE("Corporate", null),
    FUND("Fund", null),
    SPECIAL_PURPOSE_VEHICLE("SpecialPurposeVehicle", null);

    private static Map<String, IssuerTypeEnum> values;
    private final String rosettaName;
    private final String displayName;

    private IssuerTypeEnum(String rosettaName, String displayName) {
        this.rosettaName = rosettaName;
        this.displayName = displayName;
    }

    public static IssuerTypeEnum fromDisplayName(String name) {
        IssuerTypeEnum value = values.get(name);
        if (value == null) {
            throw new IllegalArgumentException("No enum constant with display name \"" + name + "\".");
        }
        return value;
    }

    public String toString() {
        return this.toDisplayString();
    }

    public String toDisplayString() {
        return this.displayName != null ? this.displayName : this.rosettaName;
    }

    static {
        ConcurrentHashMap<String, IssuerTypeEnum> map = new ConcurrentHashMap<String, IssuerTypeEnum>();
        for (IssuerTypeEnum instance : IssuerTypeEnum.values()) {
            map.put(instance.toDisplayString(), instance);
        }
        values = Collections.unmodifiableMap(map);
    }
}

