/*
 * Decompiled with CFR 0.152.
 */
package cdm.event.common.functions;

import cdm.base.math.ArithmeticOperationEnum;
import cdm.base.math.FinancialUnitEnum;
import cdm.base.math.NonNegativeQuantitySchedule;
import cdm.base.math.QuantityChangeDirectionEnum;
import cdm.base.math.QuantitySchedule;
import cdm.base.math.UnitType;
import cdm.base.math.functions.FilterQuantityByFinancialUnit;
import cdm.event.common.PrimitiveInstruction;
import cdm.event.common.QuantityChangeInstruction;
import cdm.event.common.StockSplitInstruction;
import cdm.event.common.TradeState;
import cdm.event.common.functions.Create_TradeState;
import cdm.observable.asset.CashPrice;
import cdm.observable.asset.Price;
import cdm.observable.asset.PriceComposite;
import cdm.observable.asset.PriceExpressionEnum;
import cdm.observable.asset.PriceTypeEnum;
import cdm.observable.asset.metafields.FieldWithMetaPriceSchedule;
import cdm.product.common.settlement.PriceQuantity;
import cdm.product.template.TradeLot;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.expression.MapperMaths;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=Create_StockSplitDefault.class)
public abstract class Create_StockSplit
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected Create_TradeState create_TradeState;
    @Inject
    protected FilterQuantityByFinancialUnit filterQuantityByFinancialUnit;

    public TradeState evaluate(StockSplitInstruction stockSplitInstruction, TradeState before) {
        TradeState after;
        TradeState.TradeStateBuilder afterBuilder = this.doEvaluate(stockSplitInstruction, before);
        if (afterBuilder == null) {
            after = null;
        } else {
            after = afterBuilder.build();
            this.objectValidator.validate(TradeState.class, (RosettaModelObject)after);
        }
        return after;
    }

    protected abstract TradeState.TradeStateBuilder doEvaluate(StockSplitInstruction var1, TradeState var2);

    protected abstract MapperS<BigDecimal> preSplitNumberOfShares(StockSplitInstruction var1, TradeState var2);

    protected abstract MapperS<? extends NonNegativeQuantitySchedule> postSplitNumberOfShares(StockSplitInstruction var1, TradeState var2);

    protected abstract MapperS<? extends FieldWithMetaPriceSchedule> preSplitPrice(StockSplitInstruction var1, TradeState var2);

    protected abstract MapperS<? extends Price> postSplitPrice(StockSplitInstruction var1, TradeState var2);

    protected abstract MapperS<? extends PriceQuantity> postSplitPriceQuantity(StockSplitInstruction var1, TradeState var2);

    protected abstract MapperS<? extends QuantityChangeInstruction> quantityChangeInstruction(StockSplitInstruction var1, TradeState var2);

    protected abstract MapperS<? extends PrimitiveInstruction> primitiveInstruction(StockSplitInstruction var1, TradeState var2);

    public static class Create_StockSplitDefault
    extends Create_StockSplit {
        @Override
        protected TradeState.TradeStateBuilder doEvaluate(StockSplitInstruction stockSplitInstruction, TradeState before) {
            TradeState.TradeStateBuilder after = TradeState.builder();
            return this.assignOutput(after, stockSplitInstruction, before);
        }

        protected TradeState.TradeStateBuilder assignOutput(TradeState.TradeStateBuilder after, StockSplitInstruction stockSplitInstruction, TradeState before) {
            after = (TradeState.TradeStateBuilder)this.toBuilder(this.create_TradeState.evaluate((PrimitiveInstruction)this.primitiveInstruction(stockSplitInstruction, before).get(), before));
            return Optional.ofNullable(after).map(o -> o.prune()).orElse(null);
        }

        @Override
        protected MapperS<BigDecimal> preSplitNumberOfShares(StockSplitInstruction stockSplitInstruction, TradeState before) {
            return MapperS.of((Object)((QuantitySchedule)MapperC.of(this.filterQuantityByFinancialUnit.evaluate(MapperS.of((Object)((TradeLot)MapperS.of((Object)before).map("getTrade", tradeState -> tradeState.getTrade()).map("getTradableProduct", trade -> trade.getTradableProduct()).mapC("getTradeLot", tradableProduct -> tradableProduct.getTradeLot()).get())).mapC("getPriceQuantity", tradeLot -> tradeLot.getPriceQuantity()).mapC("getQuantity", priceQuantity -> priceQuantity.getQuantity()).map("Type coercion", fieldWithMetaNonNegativeQuantitySchedule -> fieldWithMetaNonNegativeQuantitySchedule.getValue()).getMulti(), FinancialUnitEnum.SHARE)).get())).map("getValue", quantitySchedule -> quantitySchedule.getValue());
        }

        @Override
        protected MapperS<? extends NonNegativeQuantitySchedule> postSplitNumberOfShares(StockSplitInstruction stockSplitInstruction, TradeState before) {
            return MapperS.of((Object)NonNegativeQuantitySchedule.builder().setValue((BigDecimal)MapperMaths.multiply(this.preSplitNumberOfShares(stockSplitInstruction, before), (Mapper)MapperS.of((Object)stockSplitInstruction).map("getAdjustmentRatio", _stockSplitInstruction -> _stockSplitInstruction.getAdjustmentRatio())).get()).setUnit(UnitType.builder().setFinancialUnit(FinancialUnitEnum.SHARE).build()).build());
        }

        @Override
        protected MapperS<? extends FieldWithMetaPriceSchedule> preSplitPrice(StockSplitInstruction stockSplitInstruction, TradeState before) {
            MapperC thenArg = MapperS.of((Object)before).map("getTrade", tradeState -> tradeState.getTrade()).map("getTradableProduct", trade -> trade.getTradableProduct()).mapC("getTradeLot", tradableProduct -> tradableProduct.getTradeLot()).mapC("getPriceQuantity", tradeLot -> tradeLot.getPriceQuantity()).mapC("getPrice", priceQuantity -> priceQuantity.getPrice()).filterItemNullSafe(item -> ExpressionOperators.areEqual((Mapper)item.map("Type coercion", fieldWithMetaPriceSchedule -> fieldWithMetaPriceSchedule == null ? null : fieldWithMetaPriceSchedule.getValue()).map("getPerUnitOf", priceSchedule -> priceSchedule.getPerUnitOf()).map("getFinancialUnit", unitType -> unitType.getFinancialUnit()), (Mapper)MapperS.of((Object)((Object)FinancialUnitEnum.SHARE)), (CardinalityOperator)CardinalityOperator.All).get());
            return MapperS.of((Object)((FieldWithMetaPriceSchedule)thenArg.get()));
        }

        @Override
        protected MapperS<? extends Price> postSplitPrice(StockSplitInstruction stockSplitInstruction, TradeState before) {
            return MapperS.of((Object)Price.builder().setValue((BigDecimal)MapperMaths.divide((Mapper)this.preSplitPrice(stockSplitInstruction, before).map("Type coercion", fieldWithMetaPriceSchedule0 -> fieldWithMetaPriceSchedule0 == null ? null : fieldWithMetaPriceSchedule0.getValue()).map("getValue", priceSchedule -> priceSchedule.getValue()), (Mapper)MapperS.of((Object)stockSplitInstruction).map("getAdjustmentRatio", _stockSplitInstruction -> _stockSplitInstruction.getAdjustmentRatio())).get()).setUnit((UnitType)this.preSplitPrice(stockSplitInstruction, before).map("Type coercion", fieldWithMetaPriceSchedule1 -> fieldWithMetaPriceSchedule1 == null ? null : fieldWithMetaPriceSchedule1.getValue()).map("getUnit", priceSchedule -> priceSchedule.getUnit()).get()).setPerUnitOf((UnitType)this.preSplitPrice(stockSplitInstruction, before).map("Type coercion", fieldWithMetaPriceSchedule2 -> fieldWithMetaPriceSchedule2 == null ? null : fieldWithMetaPriceSchedule2.getValue()).map("getPerUnitOf", priceSchedule -> priceSchedule.getPerUnitOf()).get()).setPriceType((PriceTypeEnum)((Object)this.preSplitPrice(stockSplitInstruction, before).map("Type coercion", fieldWithMetaPriceSchedule3 -> fieldWithMetaPriceSchedule3 == null ? null : fieldWithMetaPriceSchedule3.getValue()).map("getPriceType", priceSchedule -> priceSchedule.getPriceType()).get())).setPriceExpression((PriceExpressionEnum)((Object)this.preSplitPrice(stockSplitInstruction, before).map("Type coercion", fieldWithMetaPriceSchedule4 -> fieldWithMetaPriceSchedule4 == null ? null : fieldWithMetaPriceSchedule4.getValue()).map("getPriceExpression", priceSchedule -> priceSchedule.getPriceExpression()).get())).setComposite((PriceComposite)this.preSplitPrice(stockSplitInstruction, before).map("Type coercion", fieldWithMetaPriceSchedule5 -> fieldWithMetaPriceSchedule5 == null ? null : fieldWithMetaPriceSchedule5.getValue()).map("getComposite", priceSchedule -> priceSchedule.getComposite()).get()).setArithmeticOperator((ArithmeticOperationEnum)((Object)this.preSplitPrice(stockSplitInstruction, before).map("Type coercion", fieldWithMetaPriceSchedule6 -> fieldWithMetaPriceSchedule6 == null ? null : fieldWithMetaPriceSchedule6.getValue()).map("getArithmeticOperator", priceSchedule -> priceSchedule.getArithmeticOperator()).get())).setCashPrice((CashPrice)this.preSplitPrice(stockSplitInstruction, before).map("Type coercion", fieldWithMetaPriceSchedule7 -> fieldWithMetaPriceSchedule7 == null ? null : fieldWithMetaPriceSchedule7.getValue()).map("getCashPrice", priceSchedule -> priceSchedule.getCashPrice()).get()).setDatedValue(Collections.emptyList()).build());
        }

        @Override
        protected MapperS<? extends PriceQuantity> postSplitPriceQuantity(StockSplitInstruction stockSplitInstruction, TradeState before) {
            return MapperS.of((Object)PriceQuantity.builder().setPriceValue(new ArrayList(this.postSplitPrice(stockSplitInstruction, before).getMulti())).setQuantityValue(new ArrayList(this.postSplitNumberOfShares(stockSplitInstruction, before).getMulti())).build());
        }

        @Override
        protected MapperS<? extends QuantityChangeInstruction> quantityChangeInstruction(StockSplitInstruction stockSplitInstruction, TradeState before) {
            return MapperS.of((Object)QuantityChangeInstruction.builder().setChange(new ArrayList(this.postSplitPriceQuantity(stockSplitInstruction, before).getMulti())).setDirection(QuantityChangeDirectionEnum.REPLACE).setLotIdentifier(Collections.emptyList()).build());
        }

        @Override
        protected MapperS<? extends PrimitiveInstruction> primitiveInstruction(StockSplitInstruction stockSplitInstruction, TradeState before) {
            return MapperS.of((Object)PrimitiveInstruction.builder().setQuantityChange((QuantityChangeInstruction)this.quantityChangeInstruction(stockSplitInstruction, before).get()).build());
        }
    }
}

