/*
 * Decompiled with CFR 0.152.
 */
package cdm.event.common.validation.datarule;

import cdm.event.common.BillingSummary;
import cdm.event.common.RecordAmountTypeEnum;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="BillingSummaryAccountTotal")
@ImplementedBy(value=Default.class)
public interface BillingSummaryAccountTotal
extends Validator<BillingSummary> {
    public static final String NAME = "BillingSummaryAccountTotal";
    public static final String DEFINITION = "if summaryAmountType = RecordAmountTypeEnum -> AccountTotal then summaryTransfer -> payerReceiver -> payerAccountReference exists and summaryTransfer -> payerReceiver -> receiverAccountReference exists";

    public static class NoOp
    implements BillingSummaryAccountTotal {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, BillingSummary billingSummary) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements BillingSummaryAccountTotal {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, BillingSummary billingSummary) {
            ComparisonResult result = this.executeDataRule(billingSummary);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)BillingSummaryAccountTotal.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"BillingSummary", (RosettaPath)path, (String)BillingSummaryAccountTotal.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)BillingSummaryAccountTotal.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"BillingSummary", (RosettaPath)path, (String)BillingSummaryAccountTotal.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(BillingSummary billingSummary) {
            try {
                if (ExpressionOperators.areEqual((Mapper)MapperS.of((Object)billingSummary).map("getSummaryAmountType", _billingSummary -> _billingSummary.getSummaryAmountType()), (Mapper)MapperS.of((Object)((Object)RecordAmountTypeEnum.ACCOUNT_TOTAL)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return ExpressionOperators.exists((Mapper)MapperS.of((Object)billingSummary).map("getSummaryTransfer", _billingSummary -> _billingSummary.getSummaryTransfer()).map("getPayerReceiver", transfer -> transfer.getPayerReceiver()).map("getPayerAccountReference", partyReferencePayerReceiver -> partyReferencePayerReceiver.getPayerAccountReference())).and(ExpressionOperators.exists((Mapper)MapperS.of((Object)billingSummary).map("getSummaryTransfer", _billingSummary -> _billingSummary.getSummaryTransfer()).map("getPayerReceiver", transfer -> transfer.getPayerReceiver()).map("getReceiverAccountReference", partyReferencePayerReceiver -> partyReferencePayerReceiver.getReceiverAccountReference())));
                }
                return ComparisonResult.successEmptyOperand((String)"");
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

