/*
 * Decompiled with CFR 0.152.
 */
package cdm.event.common.validation.datarule;

import cdm.event.common.Instruction;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="InstructionNewTrade")
@ImplementedBy(value=Default.class)
public interface InstructionNewTrade
extends Validator<Instruction> {
    public static final String NAME = "InstructionNewTrade";
    public static final String DEFINITION = "(if primitiveInstruction -> execution exists then before is absent) and (if before is absent then primitiveInstruction -> execution exists)";

    public static class NoOp
    implements InstructionNewTrade {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, Instruction instruction) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements InstructionNewTrade {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, Instruction instruction) {
            ComparisonResult result = this.executeDataRule(instruction);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)InstructionNewTrade.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"Instruction", (RosettaPath)path, (String)InstructionNewTrade.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)InstructionNewTrade.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"Instruction", (RosettaPath)path, (String)InstructionNewTrade.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(Instruction instruction) {
            try {
                ComparisonResult ifThenElseResult0 = ExpressionOperators.exists((Mapper)MapperS.of((Object)instruction).map("getPrimitiveInstruction", _instruction -> _instruction.getPrimitiveInstruction()).map("getExecution", primitiveInstruction -> primitiveInstruction.getExecution())).getOrDefault(Boolean.valueOf(false)) != false ? ExpressionOperators.notExists((Mapper)MapperS.of((Object)instruction).map("getBefore", _instruction -> _instruction.getBefore())) : ComparisonResult.successEmptyOperand((String)"");
                ComparisonResult ifThenElseResult1 = ExpressionOperators.notExists((Mapper)MapperS.of((Object)instruction).map("getBefore", _instruction -> _instruction.getBefore())).getOrDefault(Boolean.valueOf(false)) != false ? ExpressionOperators.exists((Mapper)MapperS.of((Object)instruction).map("getPrimitiveInstruction", _instruction -> _instruction.getPrimitiveInstruction()).map("getExecution", primitiveInstruction -> primitiveInstruction.getExecution())) : ComparisonResult.successEmptyOperand((String)"");
                return ifThenElseResult0.and(ifThenElseResult1);
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

