/*
 * Decompiled with CFR 0.152.
 */
package cdm.event.position;

import cdm.base.math.Quantity;
import cdm.base.staticdata.asset.common.Security;
import cdm.base.staticdata.identifier.AssignedIdentifier;
import cdm.base.staticdata.party.PartyRole;
import cdm.event.position.InventoryRecord;
import cdm.event.position.meta.AvailableInventoryRecordMeta;
import cdm.observable.asset.Price;
import cdm.product.collateral.CollateralProvisions;
import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="AvailableInventoryRecord", builder=AvailableInventoryRecordBuilderImpl.class, version="5.27.0")
@RuneDataType(value="AvailableInventoryRecord", model="cdm", builder=AvailableInventoryRecordBuilderImpl.class, version="5.27.0")
public interface AvailableInventoryRecord
extends InventoryRecord {
    public static final AvailableInventoryRecordMeta metaData = new AvailableInventoryRecordMeta();

    public ZonedDateTime getExpirationDateTime();

    public List<? extends CollateralProvisions> getCollateral();

    public List<? extends PartyRole> getPartyRole();

    public Quantity getAvailableQuantity();

    public Price getInterestRate();

    @Override
    public AvailableInventoryRecord build();

    @Override
    public AvailableInventoryRecordBuilder toBuilder();

    public static AvailableInventoryRecordBuilder builder() {
        return new AvailableInventoryRecordBuilderImpl();
    }

    default public RosettaMetaData<? extends AvailableInventoryRecord> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends AvailableInventoryRecord> getType() {
        return AvailableInventoryRecord.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("identifer"), processor, AssignedIdentifier.class, this.getIdentifer(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("security"), processor, Security.class, this.getSecurity(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("expirationDateTime"), ZonedDateTime.class, (Object)this.getExpirationDateTime(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("collateral"), processor, CollateralProvisions.class, this.getCollateral(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("partyRole"), processor, PartyRole.class, this.getPartyRole(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("availableQuantity"), processor, Quantity.class, this.getAvailableQuantity(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("interestRate"), processor, Price.class, this.getInterestRate(), new AttributeMeta[0]);
    }

    public static class AvailableInventoryRecordBuilderImpl
    extends InventoryRecord.InventoryRecordBuilderImpl
    implements AvailableInventoryRecordBuilder {
        protected ZonedDateTime expirationDateTime;
        protected List<CollateralProvisions.CollateralProvisionsBuilder> collateral = new ArrayList<CollateralProvisions.CollateralProvisionsBuilder>();
        protected List<PartyRole.PartyRoleBuilder> partyRole = new ArrayList<PartyRole.PartyRoleBuilder>();
        protected Quantity.QuantityBuilder availableQuantity;
        protected Price.PriceBuilder interestRate;

        @Override
        @RosettaAttribute(value="expirationDateTime")
        @RuneAttribute(value="expirationDateTime")
        public ZonedDateTime getExpirationDateTime() {
            return this.expirationDateTime;
        }

        @Override
        @RosettaAttribute(value="collateral")
        @RuneAttribute(value="collateral")
        public List<? extends CollateralProvisions.CollateralProvisionsBuilder> getCollateral() {
            return this.collateral;
        }

        @Override
        public CollateralProvisions.CollateralProvisionsBuilder getOrCreateCollateral(int index) {
            if (this.collateral == null) {
                this.collateral = new ArrayList<CollateralProvisions.CollateralProvisionsBuilder>();
            }
            return (CollateralProvisions.CollateralProvisionsBuilder)this.getIndex(this.collateral, index, () -> {
                CollateralProvisions.CollateralProvisionsBuilder newCollateral = CollateralProvisions.builder();
                return newCollateral;
            });
        }

        @Override
        @RosettaAttribute(value="partyRole")
        @RuneAttribute(value="partyRole")
        public List<? extends PartyRole.PartyRoleBuilder> getPartyRole() {
            return this.partyRole;
        }

        @Override
        public PartyRole.PartyRoleBuilder getOrCreatePartyRole(int index) {
            if (this.partyRole == null) {
                this.partyRole = new ArrayList<PartyRole.PartyRoleBuilder>();
            }
            return (PartyRole.PartyRoleBuilder)this.getIndex(this.partyRole, index, () -> {
                PartyRole.PartyRoleBuilder newPartyRole = PartyRole.builder();
                return newPartyRole;
            });
        }

        @Override
        @RosettaAttribute(value="availableQuantity")
        @RuneAttribute(value="availableQuantity")
        public Quantity.QuantityBuilder getAvailableQuantity() {
            return this.availableQuantity;
        }

        @Override
        public Quantity.QuantityBuilder getOrCreateAvailableQuantity() {
            Quantity.QuantityBuilder result = this.availableQuantity != null ? this.availableQuantity : (this.availableQuantity = Quantity.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="interestRate")
        @RuneAttribute(value="interestRate")
        public Price.PriceBuilder getInterestRate() {
            return this.interestRate;
        }

        @Override
        public Price.PriceBuilder getOrCreateInterestRate() {
            Price.PriceBuilder result = this.interestRate != null ? this.interestRate : (this.interestRate = Price.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="identifer", isRequired=true)
        @RuneAttribute(value="identifer", isRequired=true)
        public AvailableInventoryRecordBuilder setIdentifer(AssignedIdentifier _identifer) {
            this.identifer = _identifer == null ? null : _identifer.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="security", isRequired=true)
        @RuneAttribute(value="security", isRequired=true)
        public AvailableInventoryRecordBuilder setSecurity(Security _security) {
            this.security = _security == null ? null : _security.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="expirationDateTime")
        @RuneAttribute(value="expirationDateTime")
        public AvailableInventoryRecordBuilder setExpirationDateTime(ZonedDateTime _expirationDateTime) {
            this.expirationDateTime = _expirationDateTime == null ? null : _expirationDateTime;
            return this;
        }

        @Override
        @RosettaAttribute(value="collateral")
        @RuneAttribute(value="collateral")
        public AvailableInventoryRecordBuilder addCollateral(CollateralProvisions _collateral) {
            if (_collateral != null) {
                this.collateral.add(_collateral.toBuilder());
            }
            return this;
        }

        @Override
        public AvailableInventoryRecordBuilder addCollateral(CollateralProvisions _collateral, int idx) {
            this.getIndex(this.collateral, idx, () -> _collateral.toBuilder());
            return this;
        }

        @Override
        public AvailableInventoryRecordBuilder addCollateral(List<? extends CollateralProvisions> collaterals) {
            if (collaterals != null) {
                for (CollateralProvisions collateralProvisions : collaterals) {
                    this.collateral.add(collateralProvisions.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="collateral")
        public AvailableInventoryRecordBuilder setCollateral(List<? extends CollateralProvisions> collaterals) {
            this.collateral = collaterals == null ? new ArrayList<CollateralProvisions.CollateralProvisionsBuilder>() : (List)collaterals.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="partyRole")
        @RuneAttribute(value="partyRole")
        public AvailableInventoryRecordBuilder addPartyRole(PartyRole _partyRole) {
            if (_partyRole != null) {
                this.partyRole.add(_partyRole.toBuilder());
            }
            return this;
        }

        @Override
        public AvailableInventoryRecordBuilder addPartyRole(PartyRole _partyRole, int idx) {
            this.getIndex(this.partyRole, idx, () -> _partyRole.toBuilder());
            return this;
        }

        @Override
        public AvailableInventoryRecordBuilder addPartyRole(List<? extends PartyRole> partyRoles) {
            if (partyRoles != null) {
                for (PartyRole partyRole : partyRoles) {
                    this.partyRole.add(partyRole.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="partyRole")
        public AvailableInventoryRecordBuilder setPartyRole(List<? extends PartyRole> partyRoles) {
            this.partyRole = partyRoles == null ? new ArrayList<PartyRole.PartyRoleBuilder>() : (List)partyRoles.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="availableQuantity")
        @RuneAttribute(value="availableQuantity")
        public AvailableInventoryRecordBuilder setAvailableQuantity(Quantity _availableQuantity) {
            this.availableQuantity = _availableQuantity == null ? null : _availableQuantity.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="interestRate")
        @RuneAttribute(value="interestRate")
        public AvailableInventoryRecordBuilder setInterestRate(Price _interestRate) {
            this.interestRate = _interestRate == null ? null : _interestRate.toBuilder();
            return this;
        }

        @Override
        public AvailableInventoryRecord build() {
            return new AvailableInventoryRecordImpl(this);
        }

        @Override
        public AvailableInventoryRecordBuilder toBuilder() {
            return this;
        }

        @Override
        public AvailableInventoryRecordBuilder prune() {
            super.prune();
            this.collateral = this.collateral.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.partyRole = this.partyRole.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.availableQuantity != null && !this.availableQuantity.prune().hasData()) {
                this.availableQuantity = null;
            }
            if (this.interestRate != null && !this.interestRate.prune().hasData()) {
                this.interestRate = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getExpirationDateTime() != null) {
                return true;
            }
            if (this.getCollateral() != null && this.getCollateral().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getPartyRole() != null && this.getPartyRole().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getAvailableQuantity() != null && this.getAvailableQuantity().hasData()) {
                return true;
            }
            return this.getInterestRate() != null && this.getInterestRate().hasData();
        }

        @Override
        public AvailableInventoryRecordBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            AvailableInventoryRecordBuilder o = (AvailableInventoryRecordBuilder)other;
            merger.mergeRosetta(this.getCollateral(), o.getCollateral(), this::getOrCreateCollateral);
            merger.mergeRosetta(this.getPartyRole(), o.getPartyRole(), this::getOrCreatePartyRole);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getAvailableQuantity(), (RosettaModelObjectBuilder)o.getAvailableQuantity(), this::setAvailableQuantity);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getInterestRate(), (RosettaModelObjectBuilder)o.getInterestRate(), this::setInterestRate);
            merger.mergeBasic((Object)this.getExpirationDateTime(), (Object)o.getExpirationDateTime(), this::setExpirationDateTime, new AttributeMeta[0]);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            AvailableInventoryRecord _that = (AvailableInventoryRecord)this.getType().cast(o);
            if (!Objects.equals(this.expirationDateTime, _that.getExpirationDateTime())) {
                return false;
            }
            if (!ListEquals.listEquals(this.collateral, _that.getCollateral())) {
                return false;
            }
            if (!ListEquals.listEquals(this.partyRole, _that.getPartyRole())) {
                return false;
            }
            if (!Objects.equals(this.availableQuantity, _that.getAvailableQuantity())) {
                return false;
            }
            return Objects.equals(this.interestRate, _that.getInterestRate());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.expirationDateTime != null ? this.expirationDateTime.hashCode() : 0);
            _result = 31 * _result + (this.collateral != null ? this.collateral.hashCode() : 0);
            _result = 31 * _result + (this.partyRole != null ? this.partyRole.hashCode() : 0);
            _result = 31 * _result + (this.availableQuantity != null ? this.availableQuantity.hashCode() : 0);
            _result = 31 * _result + (this.interestRate != null ? this.interestRate.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "AvailableInventoryRecordBuilder {expirationDateTime=" + this.expirationDateTime + ", collateral=" + this.collateral + ", partyRole=" + this.partyRole + ", availableQuantity=" + this.availableQuantity + ", interestRate=" + this.interestRate + '}' + " " + super.toString();
        }
    }

    public static interface AvailableInventoryRecordBuilder
    extends AvailableInventoryRecord,
    InventoryRecord.InventoryRecordBuilder {
        public CollateralProvisions.CollateralProvisionsBuilder getOrCreateCollateral(int var1);

        public List<? extends CollateralProvisions.CollateralProvisionsBuilder> getCollateral();

        public PartyRole.PartyRoleBuilder getOrCreatePartyRole(int var1);

        public List<? extends PartyRole.PartyRoleBuilder> getPartyRole();

        public Quantity.QuantityBuilder getOrCreateAvailableQuantity();

        @Override
        public Quantity.QuantityBuilder getAvailableQuantity();

        public Price.PriceBuilder getOrCreateInterestRate();

        @Override
        public Price.PriceBuilder getInterestRate();

        @Override
        public AvailableInventoryRecordBuilder setIdentifer(AssignedIdentifier var1);

        @Override
        public AvailableInventoryRecordBuilder setSecurity(Security var1);

        public AvailableInventoryRecordBuilder setExpirationDateTime(ZonedDateTime var1);

        public AvailableInventoryRecordBuilder addCollateral(CollateralProvisions var1);

        public AvailableInventoryRecordBuilder addCollateral(CollateralProvisions var1, int var2);

        public AvailableInventoryRecordBuilder addCollateral(List<? extends CollateralProvisions> var1);

        public AvailableInventoryRecordBuilder setCollateral(List<? extends CollateralProvisions> var1);

        public AvailableInventoryRecordBuilder addPartyRole(PartyRole var1);

        public AvailableInventoryRecordBuilder addPartyRole(PartyRole var1, int var2);

        public AvailableInventoryRecordBuilder addPartyRole(List<? extends PartyRole> var1);

        public AvailableInventoryRecordBuilder setPartyRole(List<? extends PartyRole> var1);

        public AvailableInventoryRecordBuilder setAvailableQuantity(Quantity var1);

        public AvailableInventoryRecordBuilder setInterestRate(Price var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("identifer"), processor, AssignedIdentifier.AssignedIdentifierBuilder.class, (RosettaModelObjectBuilder)this.getIdentifer(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("security"), processor, Security.SecurityBuilder.class, (RosettaModelObjectBuilder)this.getSecurity(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("expirationDateTime"), ZonedDateTime.class, (Object)this.getExpirationDateTime(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("collateral"), processor, CollateralProvisions.CollateralProvisionsBuilder.class, this.getCollateral(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("partyRole"), processor, PartyRole.PartyRoleBuilder.class, this.getPartyRole(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("availableQuantity"), processor, Quantity.QuantityBuilder.class, this.getAvailableQuantity(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("interestRate"), processor, Price.PriceBuilder.class, this.getInterestRate(), new AttributeMeta[0]);
        }

        @Override
        public AvailableInventoryRecordBuilder prune();
    }

    public static class AvailableInventoryRecordImpl
    extends InventoryRecord.InventoryRecordImpl
    implements AvailableInventoryRecord {
        private final ZonedDateTime expirationDateTime;
        private final List<? extends CollateralProvisions> collateral;
        private final List<? extends PartyRole> partyRole;
        private final Quantity availableQuantity;
        private final Price interestRate;

        protected AvailableInventoryRecordImpl(AvailableInventoryRecordBuilder builder) {
            super(builder);
            this.expirationDateTime = builder.getExpirationDateTime();
            this.collateral = Optional.ofNullable(builder.getCollateral()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.partyRole = Optional.ofNullable(builder.getPartyRole()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.availableQuantity = Optional.ofNullable(builder.getAvailableQuantity()).map(f -> f.build()).orElse(null);
            this.interestRate = Optional.ofNullable(builder.getInterestRate()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="expirationDateTime")
        @RuneAttribute(value="expirationDateTime")
        public ZonedDateTime getExpirationDateTime() {
            return this.expirationDateTime;
        }

        @Override
        @RosettaAttribute(value="collateral")
        @RuneAttribute(value="collateral")
        public List<? extends CollateralProvisions> getCollateral() {
            return this.collateral;
        }

        @Override
        @RosettaAttribute(value="partyRole")
        @RuneAttribute(value="partyRole")
        public List<? extends PartyRole> getPartyRole() {
            return this.partyRole;
        }

        @Override
        @RosettaAttribute(value="availableQuantity")
        @RuneAttribute(value="availableQuantity")
        public Quantity getAvailableQuantity() {
            return this.availableQuantity;
        }

        @Override
        @RosettaAttribute(value="interestRate")
        @RuneAttribute(value="interestRate")
        public Price getInterestRate() {
            return this.interestRate;
        }

        @Override
        public AvailableInventoryRecord build() {
            return this;
        }

        @Override
        public AvailableInventoryRecordBuilder toBuilder() {
            AvailableInventoryRecordBuilder builder = AvailableInventoryRecord.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(AvailableInventoryRecordBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getExpirationDateTime()).ifPresent(builder::setExpirationDateTime);
            Optional.ofNullable(this.getCollateral()).ifPresent(builder::setCollateral);
            Optional.ofNullable(this.getPartyRole()).ifPresent(builder::setPartyRole);
            Optional.ofNullable(this.getAvailableQuantity()).ifPresent(builder::setAvailableQuantity);
            Optional.ofNullable(this.getInterestRate()).ifPresent(builder::setInterestRate);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            AvailableInventoryRecord _that = (AvailableInventoryRecord)this.getType().cast(o);
            if (!Objects.equals(this.expirationDateTime, _that.getExpirationDateTime())) {
                return false;
            }
            if (!ListEquals.listEquals(this.collateral, _that.getCollateral())) {
                return false;
            }
            if (!ListEquals.listEquals(this.partyRole, _that.getPartyRole())) {
                return false;
            }
            if (!Objects.equals(this.availableQuantity, _that.getAvailableQuantity())) {
                return false;
            }
            return Objects.equals(this.interestRate, _that.getInterestRate());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.expirationDateTime != null ? this.expirationDateTime.hashCode() : 0);
            _result = 31 * _result + (this.collateral != null ? this.collateral.hashCode() : 0);
            _result = 31 * _result + (this.partyRole != null ? this.partyRole.hashCode() : 0);
            _result = 31 * _result + (this.availableQuantity != null ? this.availableQuantity.hashCode() : 0);
            _result = 31 * _result + (this.interestRate != null ? this.interestRate.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "AvailableInventoryRecord {expirationDateTime=" + this.expirationDateTime + ", collateral=" + this.collateral + ", partyRole=" + this.partyRole + ", availableQuantity=" + this.availableQuantity + ", interestRate=" + this.interestRate + '}' + " " + super.toString();
        }
    }
}

