/*
 * Decompiled with CFR 0.152.
 */
package cdm.observable.asset.processor;

import cdm.base.staticdata.party.AncillaryRoleEnum;
import cdm.legaldocumentation.contract.processor.PartyMappingHelper;
import cdm.observable.asset.CalculationAgent;
import com.regnosys.rosetta.common.translation.MappingContext;
import com.regnosys.rosetta.common.translation.MappingProcessor;
import com.regnosys.rosetta.common.translation.Path;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.path.RosettaPath;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CalculationAgentPartyMappingProcessor
extends MappingProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(CalculationAgentPartyMappingProcessor.class);
    private static final RosettaPath OPTIONAL_EARLY_TERMINATION_SUB_PATH = RosettaPath.valueOf((String)"optionalEarlyTermination");
    private static final RosettaPath MANDATORY_EARLY_TERMINATION_SUB_PATH = RosettaPath.valueOf((String)"mandatoryEarlyTermination");
    private static final RosettaPath FALLBACK_REFERENCE_PRICE_SUB_PATH = RosettaPath.valueOf((String)"fallbackReferencePrice");
    private static final RosettaPath ECONOMIC_TERMS_ENDS_WITH = RosettaPath.valueOf((String)"product.contractualProduct.economicTerms");

    public CalculationAgentPartyMappingProcessor(RosettaPath modelPath, List<Path> synonymPaths, MappingContext context) {
        super(modelPath, synonymPaths, context);
    }

    public <T> void mapBasic(Path synonymPath, Optional<T> instance, RosettaModelObjectBuilder parent) {
        this.getAncillaryRoleEnum().ifPresent(role -> PartyMappingHelper.getInstanceOrThrow(this.getContext()).setAncillaryRoleEnum(this.getModelPath(), synonymPath, ((CalculationAgent.CalculationAgentBuilder)parent)::setCalculationAgentParty, (AncillaryRoleEnum)((Object)role)));
    }

    protected Optional<AncillaryRoleEnum> getAncillaryRoleEnum() {
        if (this.getModelPath().containsPath(OPTIONAL_EARLY_TERMINATION_SUB_PATH)) {
            return Optional.of(AncillaryRoleEnum.CALCULATION_AGENT_OPTIONAL_EARLY_TERMINATION);
        }
        if (this.getModelPath().containsPath(MANDATORY_EARLY_TERMINATION_SUB_PATH)) {
            return Optional.of(AncillaryRoleEnum.CALCULATION_AGENT_MANDATORY_EARLY_TERMINATION);
        }
        if (this.getModelPath().containsPath(FALLBACK_REFERENCE_PRICE_SUB_PATH)) {
            return Optional.of(AncillaryRoleEnum.CALCULATION_AGENT_FALLBACK);
        }
        if (this.getModelPath().getParent().getParent().endsWith(ECONOMIC_TERMS_ENDS_WITH)) {
            return Optional.of(AncillaryRoleEnum.CALCULATION_AGENT_INDEPENDENT);
        }
        return Optional.empty();
    }
}

