/*
 * Decompiled with CFR 0.152.
 */
package cdm.observable.event;

import cdm.observable.event.meta.PubliclyAvailableInformationMeta;
import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="PubliclyAvailableInformation", builder=PubliclyAvailableInformationBuilderImpl.class, version="5.27.0")
@RuneDataType(value="PubliclyAvailableInformation", model="cdm", builder=PubliclyAvailableInformationBuilderImpl.class, version="5.27.0")
public interface PubliclyAvailableInformation
extends RosettaModelObject {
    public static final PubliclyAvailableInformationMeta metaData = new PubliclyAvailableInformationMeta();

    public Boolean getStandardPublicSources();

    public List<String> getPublicSource();

    public Integer getSpecifiedNumber();

    public PubliclyAvailableInformation build();

    public PubliclyAvailableInformationBuilder toBuilder();

    public static PubliclyAvailableInformationBuilder builder() {
        return new PubliclyAvailableInformationBuilderImpl();
    }

    default public RosettaMetaData<? extends PubliclyAvailableInformation> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends PubliclyAvailableInformation> getType() {
        return PubliclyAvailableInformation.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("standardPublicSources"), Boolean.class, (Object)this.getStandardPublicSources(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("publicSource"), String.class, this.getPublicSource(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("specifiedNumber"), Integer.class, (Object)this.getSpecifiedNumber(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class PubliclyAvailableInformationBuilderImpl
    implements PubliclyAvailableInformationBuilder {
        protected Boolean standardPublicSources;
        protected List<String> publicSource = new ArrayList<String>();
        protected Integer specifiedNumber;

        @Override
        @RosettaAttribute(value="standardPublicSources")
        @RuneAttribute(value="standardPublicSources")
        public Boolean getStandardPublicSources() {
            return this.standardPublicSources;
        }

        @Override
        @RosettaAttribute(value="publicSource")
        @RuneAttribute(value="publicSource")
        public List<String> getPublicSource() {
            return this.publicSource;
        }

        @Override
        @RosettaAttribute(value="specifiedNumber")
        @RuneAttribute(value="specifiedNumber")
        public Integer getSpecifiedNumber() {
            return this.specifiedNumber;
        }

        @Override
        @RosettaAttribute(value="standardPublicSources")
        @RuneAttribute(value="standardPublicSources")
        public PubliclyAvailableInformationBuilder setStandardPublicSources(Boolean _standardPublicSources) {
            this.standardPublicSources = _standardPublicSources == null ? null : _standardPublicSources;
            return this;
        }

        @Override
        @RosettaAttribute(value="publicSource")
        @RuneAttribute(value="publicSource")
        public PubliclyAvailableInformationBuilder addPublicSource(String _publicSource) {
            if (_publicSource != null) {
                this.publicSource.add(_publicSource);
            }
            return this;
        }

        @Override
        public PubliclyAvailableInformationBuilder addPublicSource(String _publicSource, int idx) {
            this.getIndex(this.publicSource, idx, () -> _publicSource);
            return this;
        }

        @Override
        public PubliclyAvailableInformationBuilder addPublicSource(List<String> publicSources) {
            if (publicSources != null) {
                for (String toAdd : publicSources) {
                    this.publicSource.add(toAdd);
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="publicSource")
        public PubliclyAvailableInformationBuilder setPublicSource(List<String> publicSources) {
            this.publicSource = publicSources == null ? new ArrayList<String>() : (List)publicSources.stream().collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="specifiedNumber")
        @RuneAttribute(value="specifiedNumber")
        public PubliclyAvailableInformationBuilder setSpecifiedNumber(Integer _specifiedNumber) {
            this.specifiedNumber = _specifiedNumber == null ? null : _specifiedNumber;
            return this;
        }

        @Override
        public PubliclyAvailableInformation build() {
            return new PubliclyAvailableInformationImpl(this);
        }

        @Override
        public PubliclyAvailableInformationBuilder toBuilder() {
            return this;
        }

        @Override
        public PubliclyAvailableInformationBuilder prune() {
            return this;
        }

        public boolean hasData() {
            if (this.getStandardPublicSources() != null) {
                return true;
            }
            if (this.getPublicSource() != null && !this.getPublicSource().isEmpty()) {
                return true;
            }
            return this.getSpecifiedNumber() != null;
        }

        public PubliclyAvailableInformationBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            PubliclyAvailableInformationBuilder o = (PubliclyAvailableInformationBuilder)other;
            merger.mergeBasic((Object)this.getStandardPublicSources(), (Object)o.getStandardPublicSources(), this::setStandardPublicSources, new AttributeMeta[0]);
            merger.mergeBasic(this.getPublicSource(), o.getPublicSource(), this::addPublicSource);
            merger.mergeBasic((Object)this.getSpecifiedNumber(), (Object)o.getSpecifiedNumber(), this::setSpecifiedNumber, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            PubliclyAvailableInformation _that = this.getType().cast(o);
            if (!Objects.equals(this.standardPublicSources, _that.getStandardPublicSources())) {
                return false;
            }
            if (!ListEquals.listEquals(this.publicSource, _that.getPublicSource())) {
                return false;
            }
            return Objects.equals(this.specifiedNumber, _that.getSpecifiedNumber());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.standardPublicSources != null ? this.standardPublicSources.hashCode() : 0);
            _result = 31 * _result + (this.publicSource != null ? this.publicSource.hashCode() : 0);
            _result = 31 * _result + (this.specifiedNumber != null ? this.specifiedNumber.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "PubliclyAvailableInformationBuilder {standardPublicSources=" + this.standardPublicSources + ", publicSource=" + this.publicSource + ", specifiedNumber=" + this.specifiedNumber + '}';
        }
    }

    public static interface PubliclyAvailableInformationBuilder
    extends PubliclyAvailableInformation,
    RosettaModelObjectBuilder {
        public PubliclyAvailableInformationBuilder setStandardPublicSources(Boolean var1);

        public PubliclyAvailableInformationBuilder addPublicSource(String var1);

        public PubliclyAvailableInformationBuilder addPublicSource(String var1, int var2);

        public PubliclyAvailableInformationBuilder addPublicSource(List<String> var1);

        public PubliclyAvailableInformationBuilder setPublicSource(List<String> var1);

        public PubliclyAvailableInformationBuilder setSpecifiedNumber(Integer var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("standardPublicSources"), Boolean.class, (Object)this.getStandardPublicSources(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("publicSource"), String.class, this.getPublicSource(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("specifiedNumber"), Integer.class, (Object)this.getSpecifiedNumber(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        public PubliclyAvailableInformationBuilder prune();
    }

    public static class PubliclyAvailableInformationImpl
    implements PubliclyAvailableInformation {
        private final Boolean standardPublicSources;
        private final List<String> publicSource;
        private final Integer specifiedNumber;

        protected PubliclyAvailableInformationImpl(PubliclyAvailableInformationBuilder builder) {
            this.standardPublicSources = builder.getStandardPublicSources();
            this.publicSource = Optional.ofNullable(builder.getPublicSource()).filter(_l -> !_l.isEmpty()).map(ImmutableList::copyOf).orElse(null);
            this.specifiedNumber = builder.getSpecifiedNumber();
        }

        @Override
        @RosettaAttribute(value="standardPublicSources")
        @RuneAttribute(value="standardPublicSources")
        public Boolean getStandardPublicSources() {
            return this.standardPublicSources;
        }

        @Override
        @RosettaAttribute(value="publicSource")
        @RuneAttribute(value="publicSource")
        public List<String> getPublicSource() {
            return this.publicSource;
        }

        @Override
        @RosettaAttribute(value="specifiedNumber")
        @RuneAttribute(value="specifiedNumber")
        public Integer getSpecifiedNumber() {
            return this.specifiedNumber;
        }

        @Override
        public PubliclyAvailableInformation build() {
            return this;
        }

        @Override
        public PubliclyAvailableInformationBuilder toBuilder() {
            PubliclyAvailableInformationBuilder builder = PubliclyAvailableInformation.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(PubliclyAvailableInformationBuilder builder) {
            Optional.ofNullable(this.getStandardPublicSources()).ifPresent(builder::setStandardPublicSources);
            Optional.ofNullable(this.getPublicSource()).ifPresent(builder::setPublicSource);
            Optional.ofNullable(this.getSpecifiedNumber()).ifPresent(builder::setSpecifiedNumber);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            PubliclyAvailableInformation _that = this.getType().cast(o);
            if (!Objects.equals(this.standardPublicSources, _that.getStandardPublicSources())) {
                return false;
            }
            if (!ListEquals.listEquals(this.publicSource, _that.getPublicSource())) {
                return false;
            }
            return Objects.equals(this.specifiedNumber, _that.getSpecifiedNumber());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.standardPublicSources != null ? this.standardPublicSources.hashCode() : 0);
            _result = 31 * _result + (this.publicSource != null ? this.publicSource.hashCode() : 0);
            _result = 31 * _result + (this.specifiedNumber != null ? this.specifiedNumber.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "PubliclyAvailableInformation {standardPublicSources=" + this.standardPublicSources + ", publicSource=" + this.publicSource + ", specifiedNumber=" + this.specifiedNumber + '}';
        }
    }
}

