/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.collateral;

import cdm.base.staticdata.identifier.Identifier;
import cdm.event.common.CollateralPortfolio;
import cdm.event.common.metafields.ReferenceWithMetaCollateralPortfolio;
import cdm.product.collateral.CollateralProvisions;
import cdm.product.collateral.IndependentAmount;
import cdm.product.collateral.meta.CollateralMeta;
import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.GlobalKey;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.annotations.RuneMetaType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.model.metafields.MetaFields;
import com.rosetta.util.ListEquals;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="Collateral", builder=CollateralBuilderImpl.class, version="5.27.0")
@RuneDataType(value="Collateral", model="cdm", builder=CollateralBuilderImpl.class, version="5.27.0")
public interface Collateral
extends RosettaModelObject,
GlobalKey {
    public static final CollateralMeta metaData = new CollateralMeta();

    public IndependentAmount getIndependentAmount();

    public List<? extends Identifier> getPortfolioIdentifier();

    public List<? extends ReferenceWithMetaCollateralPortfolio> getCollateralPortfolio();

    public CollateralProvisions getCollateralProvisions();

    public MetaFields getMeta();

    public Collateral build();

    public CollateralBuilder toBuilder();

    public static CollateralBuilder builder() {
        return new CollateralBuilderImpl();
    }

    default public RosettaMetaData<? extends Collateral> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends Collateral> getType() {
        return Collateral.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("independentAmount"), processor, IndependentAmount.class, this.getIndependentAmount(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("portfolioIdentifier"), processor, Identifier.class, this.getPortfolioIdentifier(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("collateralPortfolio"), processor, ReferenceWithMetaCollateralPortfolio.class, this.getCollateralPortfolio(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("collateralProvisions"), processor, CollateralProvisions.class, this.getCollateralProvisions(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("meta"), processor, MetaFields.class, (RosettaModelObject)this.getMeta(), new AttributeMeta[0]);
    }

    public static class CollateralBuilderImpl
    implements CollateralBuilder {
        protected IndependentAmount.IndependentAmountBuilder independentAmount;
        protected List<Identifier.IdentifierBuilder> portfolioIdentifier = new ArrayList<Identifier.IdentifierBuilder>();
        protected List<ReferenceWithMetaCollateralPortfolio.ReferenceWithMetaCollateralPortfolioBuilder> collateralPortfolio = new ArrayList<ReferenceWithMetaCollateralPortfolio.ReferenceWithMetaCollateralPortfolioBuilder>();
        protected CollateralProvisions.CollateralProvisionsBuilder collateralProvisions;
        protected MetaFields.MetaFieldsBuilder meta;

        @Override
        @RosettaAttribute(value="independentAmount")
        @RuneAttribute(value="independentAmount")
        public IndependentAmount.IndependentAmountBuilder getIndependentAmount() {
            return this.independentAmount;
        }

        @Override
        public IndependentAmount.IndependentAmountBuilder getOrCreateIndependentAmount() {
            IndependentAmount.IndependentAmountBuilder result = this.independentAmount != null ? this.independentAmount : (this.independentAmount = IndependentAmount.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="portfolioIdentifier")
        @RuneAttribute(value="portfolioIdentifier")
        public List<? extends Identifier.IdentifierBuilder> getPortfolioIdentifier() {
            return this.portfolioIdentifier;
        }

        @Override
        public Identifier.IdentifierBuilder getOrCreatePortfolioIdentifier(int index) {
            if (this.portfolioIdentifier == null) {
                this.portfolioIdentifier = new ArrayList<Identifier.IdentifierBuilder>();
            }
            return (Identifier.IdentifierBuilder)this.getIndex(this.portfolioIdentifier, index, () -> {
                Identifier.IdentifierBuilder newPortfolioIdentifier = Identifier.builder();
                return newPortfolioIdentifier;
            });
        }

        @Override
        @RosettaAttribute(value="collateralPortfolio")
        @RuneAttribute(value="collateralPortfolio")
        public List<? extends ReferenceWithMetaCollateralPortfolio.ReferenceWithMetaCollateralPortfolioBuilder> getCollateralPortfolio() {
            return this.collateralPortfolio;
        }

        @Override
        public ReferenceWithMetaCollateralPortfolio.ReferenceWithMetaCollateralPortfolioBuilder getOrCreateCollateralPortfolio(int index) {
            if (this.collateralPortfolio == null) {
                this.collateralPortfolio = new ArrayList<ReferenceWithMetaCollateralPortfolio.ReferenceWithMetaCollateralPortfolioBuilder>();
            }
            return (ReferenceWithMetaCollateralPortfolio.ReferenceWithMetaCollateralPortfolioBuilder)this.getIndex(this.collateralPortfolio, index, () -> {
                ReferenceWithMetaCollateralPortfolio.ReferenceWithMetaCollateralPortfolioBuilder newCollateralPortfolio = ReferenceWithMetaCollateralPortfolio.builder();
                return newCollateralPortfolio;
            });
        }

        @Override
        @RosettaAttribute(value="collateralProvisions")
        @RuneAttribute(value="collateralProvisions")
        public CollateralProvisions.CollateralProvisionsBuilder getCollateralProvisions() {
            return this.collateralProvisions;
        }

        @Override
        public CollateralProvisions.CollateralProvisionsBuilder getOrCreateCollateralProvisions() {
            CollateralProvisions.CollateralProvisionsBuilder result = this.collateralProvisions != null ? this.collateralProvisions : (this.collateralProvisions = CollateralProvisions.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="meta")
        @RuneAttribute(value="meta")
        @RuneMetaType
        public MetaFields.MetaFieldsBuilder getMeta() {
            return this.meta;
        }

        @Override
        public MetaFields.MetaFieldsBuilder getOrCreateMeta() {
            MetaFields.MetaFieldsBuilder result = this.meta != null ? this.meta : (this.meta = MetaFields.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="independentAmount")
        @RuneAttribute(value="independentAmount")
        public CollateralBuilder setIndependentAmount(IndependentAmount _independentAmount) {
            this.independentAmount = _independentAmount == null ? null : _independentAmount.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="portfolioIdentifier")
        @RuneAttribute(value="portfolioIdentifier")
        public CollateralBuilder addPortfolioIdentifier(Identifier _portfolioIdentifier) {
            if (_portfolioIdentifier != null) {
                this.portfolioIdentifier.add(_portfolioIdentifier.toBuilder());
            }
            return this;
        }

        @Override
        public CollateralBuilder addPortfolioIdentifier(Identifier _portfolioIdentifier, int idx) {
            this.getIndex(this.portfolioIdentifier, idx, () -> _portfolioIdentifier.toBuilder());
            return this;
        }

        @Override
        public CollateralBuilder addPortfolioIdentifier(List<? extends Identifier> portfolioIdentifiers) {
            if (portfolioIdentifiers != null) {
                for (Identifier identifier : portfolioIdentifiers) {
                    this.portfolioIdentifier.add(identifier.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="portfolioIdentifier")
        public CollateralBuilder setPortfolioIdentifier(List<? extends Identifier> portfolioIdentifiers) {
            this.portfolioIdentifier = portfolioIdentifiers == null ? new ArrayList<Identifier.IdentifierBuilder>() : (List)portfolioIdentifiers.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="collateralPortfolio")
        @RuneAttribute(value="collateralPortfolio")
        public CollateralBuilder addCollateralPortfolio(ReferenceWithMetaCollateralPortfolio _collateralPortfolio) {
            if (_collateralPortfolio != null) {
                this.collateralPortfolio.add(_collateralPortfolio.toBuilder());
            }
            return this;
        }

        @Override
        public CollateralBuilder addCollateralPortfolio(ReferenceWithMetaCollateralPortfolio _collateralPortfolio, int idx) {
            this.getIndex(this.collateralPortfolio, idx, () -> _collateralPortfolio.toBuilder());
            return this;
        }

        @Override
        public CollateralBuilder addCollateralPortfolioValue(CollateralPortfolio _collateralPortfolio) {
            this.getOrCreateCollateralPortfolio(-1).setValue(_collateralPortfolio.toBuilder());
            return this;
        }

        @Override
        public CollateralBuilder addCollateralPortfolioValue(CollateralPortfolio _collateralPortfolio, int idx) {
            this.getOrCreateCollateralPortfolio(idx).setValue(_collateralPortfolio.toBuilder());
            return this;
        }

        @Override
        public CollateralBuilder addCollateralPortfolio(List<? extends ReferenceWithMetaCollateralPortfolio> collateralPortfolios) {
            if (collateralPortfolios != null) {
                for (ReferenceWithMetaCollateralPortfolio referenceWithMetaCollateralPortfolio : collateralPortfolios) {
                    this.collateralPortfolio.add(referenceWithMetaCollateralPortfolio.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="collateralPortfolio")
        public CollateralBuilder setCollateralPortfolio(List<? extends ReferenceWithMetaCollateralPortfolio> collateralPortfolios) {
            this.collateralPortfolio = collateralPortfolios == null ? new ArrayList<ReferenceWithMetaCollateralPortfolio.ReferenceWithMetaCollateralPortfolioBuilder>() : (List)collateralPortfolios.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public CollateralBuilder addCollateralPortfolioValue(List<? extends CollateralPortfolio> collateralPortfolios) {
            if (collateralPortfolios != null) {
                for (CollateralPortfolio collateralPortfolio : collateralPortfolios) {
                    this.addCollateralPortfolioValue(collateralPortfolio);
                }
            }
            return this;
        }

        @Override
        public CollateralBuilder setCollateralPortfolioValue(List<? extends CollateralPortfolio> collateralPortfolios) {
            this.collateralPortfolio.clear();
            if (collateralPortfolios != null) {
                collateralPortfolios.forEach(this::addCollateralPortfolioValue);
            }
            return this;
        }

        @Override
        @RosettaAttribute(value="collateralProvisions")
        @RuneAttribute(value="collateralProvisions")
        public CollateralBuilder setCollateralProvisions(CollateralProvisions _collateralProvisions) {
            this.collateralProvisions = _collateralProvisions == null ? null : _collateralProvisions.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="meta")
        @RuneAttribute(value="meta")
        @RuneMetaType
        public CollateralBuilder setMeta(MetaFields _meta) {
            this.meta = _meta == null ? null : _meta.toBuilder();
            return this;
        }

        @Override
        public Collateral build() {
            return new CollateralImpl(this);
        }

        @Override
        public CollateralBuilder toBuilder() {
            return this;
        }

        @Override
        public CollateralBuilder prune() {
            if (this.independentAmount != null && !this.independentAmount.prune().hasData()) {
                this.independentAmount = null;
            }
            this.portfolioIdentifier = this.portfolioIdentifier.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.collateralPortfolio = this.collateralPortfolio.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.collateralProvisions != null && !this.collateralProvisions.prune().hasData()) {
                this.collateralProvisions = null;
            }
            if (this.meta != null && !this.meta.prune().hasData()) {
                this.meta = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getIndependentAmount() != null && this.getIndependentAmount().hasData()) {
                return true;
            }
            if (this.getPortfolioIdentifier() != null && this.getPortfolioIdentifier().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getCollateralPortfolio() != null && this.getCollateralPortfolio().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            return this.getCollateralProvisions() != null && this.getCollateralProvisions().hasData();
        }

        public CollateralBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            CollateralBuilder o = (CollateralBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getIndependentAmount(), (RosettaModelObjectBuilder)o.getIndependentAmount(), this::setIndependentAmount);
            merger.mergeRosetta(this.getPortfolioIdentifier(), o.getPortfolioIdentifier(), this::getOrCreatePortfolioIdentifier);
            merger.mergeRosetta(this.getCollateralPortfolio(), o.getCollateralPortfolio(), this::getOrCreateCollateralPortfolio);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCollateralProvisions(), (RosettaModelObjectBuilder)o.getCollateralProvisions(), this::setCollateralProvisions);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getMeta(), (RosettaModelObjectBuilder)o.getMeta(), this::setMeta);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            Collateral _that = this.getType().cast(o);
            if (!Objects.equals(this.independentAmount, _that.getIndependentAmount())) {
                return false;
            }
            if (!ListEquals.listEquals(this.portfolioIdentifier, _that.getPortfolioIdentifier())) {
                return false;
            }
            if (!ListEquals.listEquals(this.collateralPortfolio, _that.getCollateralPortfolio())) {
                return false;
            }
            if (!Objects.equals(this.collateralProvisions, _that.getCollateralProvisions())) {
                return false;
            }
            return Objects.equals(this.meta, _that.getMeta());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.independentAmount != null ? this.independentAmount.hashCode() : 0);
            _result = 31 * _result + (this.portfolioIdentifier != null ? this.portfolioIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.collateralPortfolio != null ? this.collateralPortfolio.hashCode() : 0);
            _result = 31 * _result + (this.collateralProvisions != null ? this.collateralProvisions.hashCode() : 0);
            _result = 31 * _result + (this.meta != null ? this.meta.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "CollateralBuilder {independentAmount=" + this.independentAmount + ", portfolioIdentifier=" + this.portfolioIdentifier + ", collateralPortfolio=" + this.collateralPortfolio + ", collateralProvisions=" + this.collateralProvisions + ", meta=" + this.meta + '}';
        }
    }

    public static interface CollateralBuilder
    extends Collateral,
    RosettaModelObjectBuilder,
    GlobalKey.GlobalKeyBuilder {
        public IndependentAmount.IndependentAmountBuilder getOrCreateIndependentAmount();

        @Override
        public IndependentAmount.IndependentAmountBuilder getIndependentAmount();

        public Identifier.IdentifierBuilder getOrCreatePortfolioIdentifier(int var1);

        public List<? extends Identifier.IdentifierBuilder> getPortfolioIdentifier();

        public ReferenceWithMetaCollateralPortfolio.ReferenceWithMetaCollateralPortfolioBuilder getOrCreateCollateralPortfolio(int var1);

        public List<? extends ReferenceWithMetaCollateralPortfolio.ReferenceWithMetaCollateralPortfolioBuilder> getCollateralPortfolio();

        public CollateralProvisions.CollateralProvisionsBuilder getOrCreateCollateralProvisions();

        @Override
        public CollateralProvisions.CollateralProvisionsBuilder getCollateralProvisions();

        public MetaFields.MetaFieldsBuilder getOrCreateMeta();

        public MetaFields.MetaFieldsBuilder getMeta();

        public CollateralBuilder setIndependentAmount(IndependentAmount var1);

        public CollateralBuilder addPortfolioIdentifier(Identifier var1);

        public CollateralBuilder addPortfolioIdentifier(Identifier var1, int var2);

        public CollateralBuilder addPortfolioIdentifier(List<? extends Identifier> var1);

        public CollateralBuilder setPortfolioIdentifier(List<? extends Identifier> var1);

        public CollateralBuilder addCollateralPortfolio(ReferenceWithMetaCollateralPortfolio var1);

        public CollateralBuilder addCollateralPortfolio(ReferenceWithMetaCollateralPortfolio var1, int var2);

        public CollateralBuilder addCollateralPortfolioValue(CollateralPortfolio var1);

        public CollateralBuilder addCollateralPortfolioValue(CollateralPortfolio var1, int var2);

        public CollateralBuilder addCollateralPortfolio(List<? extends ReferenceWithMetaCollateralPortfolio> var1);

        public CollateralBuilder setCollateralPortfolio(List<? extends ReferenceWithMetaCollateralPortfolio> var1);

        public CollateralBuilder addCollateralPortfolioValue(List<? extends CollateralPortfolio> var1);

        public CollateralBuilder setCollateralPortfolioValue(List<? extends CollateralPortfolio> var1);

        public CollateralBuilder setCollateralProvisions(CollateralProvisions var1);

        public CollateralBuilder setMeta(MetaFields var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("independentAmount"), processor, IndependentAmount.IndependentAmountBuilder.class, this.getIndependentAmount(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("portfolioIdentifier"), processor, Identifier.IdentifierBuilder.class, this.getPortfolioIdentifier(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("collateralPortfolio"), processor, ReferenceWithMetaCollateralPortfolio.ReferenceWithMetaCollateralPortfolioBuilder.class, this.getCollateralPortfolio(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("collateralProvisions"), processor, CollateralProvisions.CollateralProvisionsBuilder.class, this.getCollateralProvisions(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("meta"), processor, MetaFields.MetaFieldsBuilder.class, (RosettaModelObjectBuilder)this.getMeta(), new AttributeMeta[0]);
        }

        public CollateralBuilder prune();
    }

    public static class CollateralImpl
    implements Collateral {
        private final IndependentAmount independentAmount;
        private final List<? extends Identifier> portfolioIdentifier;
        private final List<? extends ReferenceWithMetaCollateralPortfolio> collateralPortfolio;
        private final CollateralProvisions collateralProvisions;
        private final MetaFields meta;

        protected CollateralImpl(CollateralBuilder builder) {
            this.independentAmount = Optional.ofNullable(builder.getIndependentAmount()).map(f -> f.build()).orElse(null);
            this.portfolioIdentifier = Optional.ofNullable(builder.getPortfolioIdentifier()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.collateralPortfolio = Optional.ofNullable(builder.getCollateralPortfolio()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.collateralProvisions = Optional.ofNullable(builder.getCollateralProvisions()).map(f -> f.build()).orElse(null);
            this.meta = Optional.ofNullable(builder.getMeta()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="independentAmount")
        @RuneAttribute(value="independentAmount")
        public IndependentAmount getIndependentAmount() {
            return this.independentAmount;
        }

        @Override
        @RosettaAttribute(value="portfolioIdentifier")
        @RuneAttribute(value="portfolioIdentifier")
        public List<? extends Identifier> getPortfolioIdentifier() {
            return this.portfolioIdentifier;
        }

        @Override
        @RosettaAttribute(value="collateralPortfolio")
        @RuneAttribute(value="collateralPortfolio")
        public List<? extends ReferenceWithMetaCollateralPortfolio> getCollateralPortfolio() {
            return this.collateralPortfolio;
        }

        @Override
        @RosettaAttribute(value="collateralProvisions")
        @RuneAttribute(value="collateralProvisions")
        public CollateralProvisions getCollateralProvisions() {
            return this.collateralProvisions;
        }

        @Override
        @RosettaAttribute(value="meta")
        @RuneAttribute(value="meta")
        @RuneMetaType
        public MetaFields getMeta() {
            return this.meta;
        }

        @Override
        public Collateral build() {
            return this;
        }

        @Override
        public CollateralBuilder toBuilder() {
            CollateralBuilder builder = Collateral.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(CollateralBuilder builder) {
            Optional.ofNullable(this.getIndependentAmount()).ifPresent(builder::setIndependentAmount);
            Optional.ofNullable(this.getPortfolioIdentifier()).ifPresent(builder::setPortfolioIdentifier);
            Optional.ofNullable(this.getCollateralPortfolio()).ifPresent(builder::setCollateralPortfolio);
            Optional.ofNullable(this.getCollateralProvisions()).ifPresent(builder::setCollateralProvisions);
            Optional.ofNullable(this.getMeta()).ifPresent(builder::setMeta);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            Collateral _that = this.getType().cast(o);
            if (!Objects.equals(this.independentAmount, _that.getIndependentAmount())) {
                return false;
            }
            if (!ListEquals.listEquals(this.portfolioIdentifier, _that.getPortfolioIdentifier())) {
                return false;
            }
            if (!ListEquals.listEquals(this.collateralPortfolio, _that.getCollateralPortfolio())) {
                return false;
            }
            if (!Objects.equals(this.collateralProvisions, _that.getCollateralProvisions())) {
                return false;
            }
            return Objects.equals(this.meta, _that.getMeta());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.independentAmount != null ? this.independentAmount.hashCode() : 0);
            _result = 31 * _result + (this.portfolioIdentifier != null ? this.portfolioIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.collateralPortfolio != null ? this.collateralPortfolio.hashCode() : 0);
            _result = 31 * _result + (this.collateralProvisions != null ? this.collateralProvisions.hashCode() : 0);
            _result = 31 * _result + (this.meta != null ? this.meta.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "Collateral {independentAmount=" + this.independentAmount + ", portfolioIdentifier=" + this.portfolioIdentifier + ", collateralPortfolio=" + this.collateralPortfolio + ", collateralProvisions=" + this.collateralProvisions + ", meta=" + this.meta + '}';
        }
    }
}

