/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.template;

import cdm.product.asset.CommodityPayout;
import cdm.product.asset.CreditDefaultPayout;
import cdm.product.asset.InterestRatePayout;
import cdm.product.common.settlement.Cashflow;
import cdm.product.template.AssetPayout;
import cdm.product.template.FixedPricePayout;
import cdm.product.template.ForwardPayout;
import cdm.product.template.OptionPayout;
import cdm.product.template.PerformancePayout;
import cdm.product.template.SecurityPayout;
import cdm.product.template.meta.PayoutMeta;
import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.GlobalKey;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.annotations.RuneMetaType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.model.metafields.MetaFields;
import com.rosetta.util.ListEquals;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="Payout", builder=PayoutBuilderImpl.class, version="5.27.0")
@RuneDataType(value="Payout", model="cdm", builder=PayoutBuilderImpl.class, version="5.27.0")
public interface Payout
extends RosettaModelObject,
GlobalKey {
    public static final PayoutMeta metaData = new PayoutMeta();

    public List<? extends InterestRatePayout> getInterestRatePayout();

    public CreditDefaultPayout getCreditDefaultPayout();

    public List<? extends OptionPayout> getOptionPayout();

    public List<? extends CommodityPayout> getCommodityPayout();

    public List<? extends ForwardPayout> getForwardPayout();

    public List<? extends FixedPricePayout> getFixedPricePayout();

    public List<? extends SecurityPayout> getSecurityPayout();

    public List<? extends Cashflow> getCashflow();

    public List<? extends PerformancePayout> getPerformancePayout();

    public List<? extends AssetPayout> getAssetPayout();

    public MetaFields getMeta();

    public Payout build();

    public PayoutBuilder toBuilder();

    public static PayoutBuilder builder() {
        return new PayoutBuilderImpl();
    }

    default public RosettaMetaData<? extends Payout> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends Payout> getType() {
        return Payout.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("interestRatePayout"), processor, InterestRatePayout.class, this.getInterestRatePayout(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("creditDefaultPayout"), processor, CreditDefaultPayout.class, this.getCreditDefaultPayout(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("optionPayout"), processor, OptionPayout.class, this.getOptionPayout(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("commodityPayout"), processor, CommodityPayout.class, this.getCommodityPayout(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("forwardPayout"), processor, ForwardPayout.class, this.getForwardPayout(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("fixedPricePayout"), processor, FixedPricePayout.class, this.getFixedPricePayout(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("securityPayout"), processor, SecurityPayout.class, this.getSecurityPayout(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("cashflow"), processor, Cashflow.class, this.getCashflow(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("performancePayout"), processor, PerformancePayout.class, this.getPerformancePayout(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("assetPayout"), processor, AssetPayout.class, this.getAssetPayout(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("meta"), processor, MetaFields.class, (RosettaModelObject)this.getMeta(), new AttributeMeta[0]);
    }

    public static class PayoutBuilderImpl
    implements PayoutBuilder {
        protected List<InterestRatePayout.InterestRatePayoutBuilder> interestRatePayout = new ArrayList<InterestRatePayout.InterestRatePayoutBuilder>();
        protected CreditDefaultPayout.CreditDefaultPayoutBuilder creditDefaultPayout;
        protected List<OptionPayout.OptionPayoutBuilder> optionPayout = new ArrayList<OptionPayout.OptionPayoutBuilder>();
        protected List<CommodityPayout.CommodityPayoutBuilder> commodityPayout = new ArrayList<CommodityPayout.CommodityPayoutBuilder>();
        protected List<ForwardPayout.ForwardPayoutBuilder> forwardPayout = new ArrayList<ForwardPayout.ForwardPayoutBuilder>();
        protected List<FixedPricePayout.FixedPricePayoutBuilder> fixedPricePayout = new ArrayList<FixedPricePayout.FixedPricePayoutBuilder>();
        protected List<SecurityPayout.SecurityPayoutBuilder> securityPayout = new ArrayList<SecurityPayout.SecurityPayoutBuilder>();
        protected List<Cashflow.CashflowBuilder> cashflow = new ArrayList<Cashflow.CashflowBuilder>();
        protected List<PerformancePayout.PerformancePayoutBuilder> performancePayout = new ArrayList<PerformancePayout.PerformancePayoutBuilder>();
        protected List<AssetPayout.AssetPayoutBuilder> assetPayout = new ArrayList<AssetPayout.AssetPayoutBuilder>();
        protected MetaFields.MetaFieldsBuilder meta;

        @Override
        @RosettaAttribute(value="interestRatePayout")
        @RuneAttribute(value="interestRatePayout")
        public List<? extends InterestRatePayout.InterestRatePayoutBuilder> getInterestRatePayout() {
            return this.interestRatePayout;
        }

        @Override
        public InterestRatePayout.InterestRatePayoutBuilder getOrCreateInterestRatePayout(int index) {
            if (this.interestRatePayout == null) {
                this.interestRatePayout = new ArrayList<InterestRatePayout.InterestRatePayoutBuilder>();
            }
            return (InterestRatePayout.InterestRatePayoutBuilder)this.getIndex(this.interestRatePayout, index, () -> {
                InterestRatePayout.InterestRatePayoutBuilder newInterestRatePayout = InterestRatePayout.builder();
                return newInterestRatePayout;
            });
        }

        @Override
        @RosettaAttribute(value="creditDefaultPayout")
        @RuneAttribute(value="creditDefaultPayout")
        public CreditDefaultPayout.CreditDefaultPayoutBuilder getCreditDefaultPayout() {
            return this.creditDefaultPayout;
        }

        @Override
        public CreditDefaultPayout.CreditDefaultPayoutBuilder getOrCreateCreditDefaultPayout() {
            CreditDefaultPayout.CreditDefaultPayoutBuilder result = this.creditDefaultPayout != null ? this.creditDefaultPayout : (this.creditDefaultPayout = CreditDefaultPayout.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="optionPayout")
        @RuneAttribute(value="optionPayout")
        public List<? extends OptionPayout.OptionPayoutBuilder> getOptionPayout() {
            return this.optionPayout;
        }

        @Override
        public OptionPayout.OptionPayoutBuilder getOrCreateOptionPayout(int index) {
            if (this.optionPayout == null) {
                this.optionPayout = new ArrayList<OptionPayout.OptionPayoutBuilder>();
            }
            return (OptionPayout.OptionPayoutBuilder)this.getIndex(this.optionPayout, index, () -> {
                OptionPayout.OptionPayoutBuilder newOptionPayout = OptionPayout.builder();
                return newOptionPayout;
            });
        }

        @Override
        @RosettaAttribute(value="commodityPayout")
        @RuneAttribute(value="commodityPayout")
        public List<? extends CommodityPayout.CommodityPayoutBuilder> getCommodityPayout() {
            return this.commodityPayout;
        }

        @Override
        public CommodityPayout.CommodityPayoutBuilder getOrCreateCommodityPayout(int index) {
            if (this.commodityPayout == null) {
                this.commodityPayout = new ArrayList<CommodityPayout.CommodityPayoutBuilder>();
            }
            return (CommodityPayout.CommodityPayoutBuilder)this.getIndex(this.commodityPayout, index, () -> {
                CommodityPayout.CommodityPayoutBuilder newCommodityPayout = CommodityPayout.builder();
                return newCommodityPayout;
            });
        }

        @Override
        @RosettaAttribute(value="forwardPayout")
        @RuneAttribute(value="forwardPayout")
        public List<? extends ForwardPayout.ForwardPayoutBuilder> getForwardPayout() {
            return this.forwardPayout;
        }

        @Override
        public ForwardPayout.ForwardPayoutBuilder getOrCreateForwardPayout(int index) {
            if (this.forwardPayout == null) {
                this.forwardPayout = new ArrayList<ForwardPayout.ForwardPayoutBuilder>();
            }
            return (ForwardPayout.ForwardPayoutBuilder)this.getIndex(this.forwardPayout, index, () -> {
                ForwardPayout.ForwardPayoutBuilder newForwardPayout = ForwardPayout.builder();
                return newForwardPayout;
            });
        }

        @Override
        @RosettaAttribute(value="fixedPricePayout")
        @RuneAttribute(value="fixedPricePayout")
        public List<? extends FixedPricePayout.FixedPricePayoutBuilder> getFixedPricePayout() {
            return this.fixedPricePayout;
        }

        @Override
        public FixedPricePayout.FixedPricePayoutBuilder getOrCreateFixedPricePayout(int index) {
            if (this.fixedPricePayout == null) {
                this.fixedPricePayout = new ArrayList<FixedPricePayout.FixedPricePayoutBuilder>();
            }
            return (FixedPricePayout.FixedPricePayoutBuilder)this.getIndex(this.fixedPricePayout, index, () -> {
                FixedPricePayout.FixedPricePayoutBuilder newFixedPricePayout = FixedPricePayout.builder();
                return newFixedPricePayout;
            });
        }

        @Override
        @RosettaAttribute(value="securityPayout")
        @RuneAttribute(value="securityPayout")
        public List<? extends SecurityPayout.SecurityPayoutBuilder> getSecurityPayout() {
            return this.securityPayout;
        }

        @Override
        public SecurityPayout.SecurityPayoutBuilder getOrCreateSecurityPayout(int index) {
            if (this.securityPayout == null) {
                this.securityPayout = new ArrayList<SecurityPayout.SecurityPayoutBuilder>();
            }
            return (SecurityPayout.SecurityPayoutBuilder)this.getIndex(this.securityPayout, index, () -> {
                SecurityPayout.SecurityPayoutBuilder newSecurityPayout = SecurityPayout.builder();
                return newSecurityPayout;
            });
        }

        @Override
        @RosettaAttribute(value="cashflow")
        @RuneAttribute(value="cashflow")
        public List<? extends Cashflow.CashflowBuilder> getCashflow() {
            return this.cashflow;
        }

        @Override
        public Cashflow.CashflowBuilder getOrCreateCashflow(int index) {
            if (this.cashflow == null) {
                this.cashflow = new ArrayList<Cashflow.CashflowBuilder>();
            }
            return (Cashflow.CashflowBuilder)this.getIndex(this.cashflow, index, () -> {
                Cashflow.CashflowBuilder newCashflow = Cashflow.builder();
                return newCashflow;
            });
        }

        @Override
        @RosettaAttribute(value="performancePayout")
        @RuneAttribute(value="performancePayout")
        public List<? extends PerformancePayout.PerformancePayoutBuilder> getPerformancePayout() {
            return this.performancePayout;
        }

        @Override
        public PerformancePayout.PerformancePayoutBuilder getOrCreatePerformancePayout(int index) {
            if (this.performancePayout == null) {
                this.performancePayout = new ArrayList<PerformancePayout.PerformancePayoutBuilder>();
            }
            return (PerformancePayout.PerformancePayoutBuilder)this.getIndex(this.performancePayout, index, () -> {
                PerformancePayout.PerformancePayoutBuilder newPerformancePayout = PerformancePayout.builder();
                return newPerformancePayout;
            });
        }

        @Override
        @RosettaAttribute(value="assetPayout")
        @RuneAttribute(value="assetPayout")
        public List<? extends AssetPayout.AssetPayoutBuilder> getAssetPayout() {
            return this.assetPayout;
        }

        @Override
        public AssetPayout.AssetPayoutBuilder getOrCreateAssetPayout(int index) {
            if (this.assetPayout == null) {
                this.assetPayout = new ArrayList<AssetPayout.AssetPayoutBuilder>();
            }
            return (AssetPayout.AssetPayoutBuilder)this.getIndex(this.assetPayout, index, () -> {
                AssetPayout.AssetPayoutBuilder newAssetPayout = AssetPayout.builder();
                return newAssetPayout;
            });
        }

        @Override
        @RosettaAttribute(value="meta")
        @RuneAttribute(value="meta")
        @RuneMetaType
        public MetaFields.MetaFieldsBuilder getMeta() {
            return this.meta;
        }

        @Override
        public MetaFields.MetaFieldsBuilder getOrCreateMeta() {
            MetaFields.MetaFieldsBuilder result = this.meta != null ? this.meta : (this.meta = MetaFields.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="interestRatePayout")
        @RuneAttribute(value="interestRatePayout")
        public PayoutBuilder addInterestRatePayout(InterestRatePayout _interestRatePayout) {
            if (_interestRatePayout != null) {
                this.interestRatePayout.add(_interestRatePayout.toBuilder());
            }
            return this;
        }

        @Override
        public PayoutBuilder addInterestRatePayout(InterestRatePayout _interestRatePayout, int idx) {
            this.getIndex(this.interestRatePayout, idx, () -> _interestRatePayout.toBuilder());
            return this;
        }

        @Override
        public PayoutBuilder addInterestRatePayout(List<? extends InterestRatePayout> interestRatePayouts) {
            if (interestRatePayouts != null) {
                for (InterestRatePayout interestRatePayout : interestRatePayouts) {
                    this.interestRatePayout.add(interestRatePayout.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="interestRatePayout")
        public PayoutBuilder setInterestRatePayout(List<? extends InterestRatePayout> interestRatePayouts) {
            this.interestRatePayout = interestRatePayouts == null ? new ArrayList<InterestRatePayout.InterestRatePayoutBuilder>() : (List)interestRatePayouts.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="creditDefaultPayout")
        @RuneAttribute(value="creditDefaultPayout")
        public PayoutBuilder setCreditDefaultPayout(CreditDefaultPayout _creditDefaultPayout) {
            this.creditDefaultPayout = _creditDefaultPayout == null ? null : _creditDefaultPayout.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="optionPayout")
        @RuneAttribute(value="optionPayout")
        public PayoutBuilder addOptionPayout(OptionPayout _optionPayout) {
            if (_optionPayout != null) {
                this.optionPayout.add(_optionPayout.toBuilder());
            }
            return this;
        }

        @Override
        public PayoutBuilder addOptionPayout(OptionPayout _optionPayout, int idx) {
            this.getIndex(this.optionPayout, idx, () -> _optionPayout.toBuilder());
            return this;
        }

        @Override
        public PayoutBuilder addOptionPayout(List<? extends OptionPayout> optionPayouts) {
            if (optionPayouts != null) {
                for (OptionPayout optionPayout : optionPayouts) {
                    this.optionPayout.add(optionPayout.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="optionPayout")
        public PayoutBuilder setOptionPayout(List<? extends OptionPayout> optionPayouts) {
            this.optionPayout = optionPayouts == null ? new ArrayList<OptionPayout.OptionPayoutBuilder>() : (List)optionPayouts.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="commodityPayout")
        @RuneAttribute(value="commodityPayout")
        public PayoutBuilder addCommodityPayout(CommodityPayout _commodityPayout) {
            if (_commodityPayout != null) {
                this.commodityPayout.add(_commodityPayout.toBuilder());
            }
            return this;
        }

        @Override
        public PayoutBuilder addCommodityPayout(CommodityPayout _commodityPayout, int idx) {
            this.getIndex(this.commodityPayout, idx, () -> _commodityPayout.toBuilder());
            return this;
        }

        @Override
        public PayoutBuilder addCommodityPayout(List<? extends CommodityPayout> commodityPayouts) {
            if (commodityPayouts != null) {
                for (CommodityPayout commodityPayout : commodityPayouts) {
                    this.commodityPayout.add(commodityPayout.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="commodityPayout")
        public PayoutBuilder setCommodityPayout(List<? extends CommodityPayout> commodityPayouts) {
            this.commodityPayout = commodityPayouts == null ? new ArrayList<CommodityPayout.CommodityPayoutBuilder>() : (List)commodityPayouts.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="forwardPayout")
        @RuneAttribute(value="forwardPayout")
        public PayoutBuilder addForwardPayout(ForwardPayout _forwardPayout) {
            if (_forwardPayout != null) {
                this.forwardPayout.add(_forwardPayout.toBuilder());
            }
            return this;
        }

        @Override
        public PayoutBuilder addForwardPayout(ForwardPayout _forwardPayout, int idx) {
            this.getIndex(this.forwardPayout, idx, () -> _forwardPayout.toBuilder());
            return this;
        }

        @Override
        public PayoutBuilder addForwardPayout(List<? extends ForwardPayout> forwardPayouts) {
            if (forwardPayouts != null) {
                for (ForwardPayout forwardPayout : forwardPayouts) {
                    this.forwardPayout.add(forwardPayout.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="forwardPayout")
        public PayoutBuilder setForwardPayout(List<? extends ForwardPayout> forwardPayouts) {
            this.forwardPayout = forwardPayouts == null ? new ArrayList<ForwardPayout.ForwardPayoutBuilder>() : (List)forwardPayouts.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="fixedPricePayout")
        @RuneAttribute(value="fixedPricePayout")
        public PayoutBuilder addFixedPricePayout(FixedPricePayout _fixedPricePayout) {
            if (_fixedPricePayout != null) {
                this.fixedPricePayout.add(_fixedPricePayout.toBuilder());
            }
            return this;
        }

        @Override
        public PayoutBuilder addFixedPricePayout(FixedPricePayout _fixedPricePayout, int idx) {
            this.getIndex(this.fixedPricePayout, idx, () -> _fixedPricePayout.toBuilder());
            return this;
        }

        @Override
        public PayoutBuilder addFixedPricePayout(List<? extends FixedPricePayout> fixedPricePayouts) {
            if (fixedPricePayouts != null) {
                for (FixedPricePayout fixedPricePayout : fixedPricePayouts) {
                    this.fixedPricePayout.add(fixedPricePayout.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="fixedPricePayout")
        public PayoutBuilder setFixedPricePayout(List<? extends FixedPricePayout> fixedPricePayouts) {
            this.fixedPricePayout = fixedPricePayouts == null ? new ArrayList<FixedPricePayout.FixedPricePayoutBuilder>() : (List)fixedPricePayouts.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="securityPayout")
        @RuneAttribute(value="securityPayout")
        public PayoutBuilder addSecurityPayout(SecurityPayout _securityPayout) {
            if (_securityPayout != null) {
                this.securityPayout.add(_securityPayout.toBuilder());
            }
            return this;
        }

        @Override
        public PayoutBuilder addSecurityPayout(SecurityPayout _securityPayout, int idx) {
            this.getIndex(this.securityPayout, idx, () -> _securityPayout.toBuilder());
            return this;
        }

        @Override
        public PayoutBuilder addSecurityPayout(List<? extends SecurityPayout> securityPayouts) {
            if (securityPayouts != null) {
                for (SecurityPayout securityPayout : securityPayouts) {
                    this.securityPayout.add(securityPayout.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="securityPayout")
        public PayoutBuilder setSecurityPayout(List<? extends SecurityPayout> securityPayouts) {
            this.securityPayout = securityPayouts == null ? new ArrayList<SecurityPayout.SecurityPayoutBuilder>() : (List)securityPayouts.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="cashflow")
        @RuneAttribute(value="cashflow")
        public PayoutBuilder addCashflow(Cashflow _cashflow) {
            if (_cashflow != null) {
                this.cashflow.add(_cashflow.toBuilder());
            }
            return this;
        }

        @Override
        public PayoutBuilder addCashflow(Cashflow _cashflow, int idx) {
            this.getIndex(this.cashflow, idx, () -> _cashflow.toBuilder());
            return this;
        }

        @Override
        public PayoutBuilder addCashflow(List<? extends Cashflow> cashflows) {
            if (cashflows != null) {
                for (Cashflow cashflow : cashflows) {
                    this.cashflow.add(cashflow.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="cashflow")
        public PayoutBuilder setCashflow(List<? extends Cashflow> cashflows) {
            this.cashflow = cashflows == null ? new ArrayList<Cashflow.CashflowBuilder>() : (List)cashflows.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="performancePayout")
        @RuneAttribute(value="performancePayout")
        public PayoutBuilder addPerformancePayout(PerformancePayout _performancePayout) {
            if (_performancePayout != null) {
                this.performancePayout.add(_performancePayout.toBuilder());
            }
            return this;
        }

        @Override
        public PayoutBuilder addPerformancePayout(PerformancePayout _performancePayout, int idx) {
            this.getIndex(this.performancePayout, idx, () -> _performancePayout.toBuilder());
            return this;
        }

        @Override
        public PayoutBuilder addPerformancePayout(List<? extends PerformancePayout> performancePayouts) {
            if (performancePayouts != null) {
                for (PerformancePayout performancePayout : performancePayouts) {
                    this.performancePayout.add(performancePayout.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="performancePayout")
        public PayoutBuilder setPerformancePayout(List<? extends PerformancePayout> performancePayouts) {
            this.performancePayout = performancePayouts == null ? new ArrayList<PerformancePayout.PerformancePayoutBuilder>() : (List)performancePayouts.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="assetPayout")
        @RuneAttribute(value="assetPayout")
        public PayoutBuilder addAssetPayout(AssetPayout _assetPayout) {
            if (_assetPayout != null) {
                this.assetPayout.add(_assetPayout.toBuilder());
            }
            return this;
        }

        @Override
        public PayoutBuilder addAssetPayout(AssetPayout _assetPayout, int idx) {
            this.getIndex(this.assetPayout, idx, () -> _assetPayout.toBuilder());
            return this;
        }

        @Override
        public PayoutBuilder addAssetPayout(List<? extends AssetPayout> assetPayouts) {
            if (assetPayouts != null) {
                for (AssetPayout assetPayout : assetPayouts) {
                    this.assetPayout.add(assetPayout.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="assetPayout")
        public PayoutBuilder setAssetPayout(List<? extends AssetPayout> assetPayouts) {
            this.assetPayout = assetPayouts == null ? new ArrayList<AssetPayout.AssetPayoutBuilder>() : (List)assetPayouts.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="meta")
        @RuneAttribute(value="meta")
        @RuneMetaType
        public PayoutBuilder setMeta(MetaFields _meta) {
            this.meta = _meta == null ? null : _meta.toBuilder();
            return this;
        }

        @Override
        public Payout build() {
            return new PayoutImpl(this);
        }

        @Override
        public PayoutBuilder toBuilder() {
            return this;
        }

        @Override
        public PayoutBuilder prune() {
            this.interestRatePayout = this.interestRatePayout.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.creditDefaultPayout != null && !this.creditDefaultPayout.prune().hasData()) {
                this.creditDefaultPayout = null;
            }
            this.optionPayout = this.optionPayout.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.commodityPayout = this.commodityPayout.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.forwardPayout = this.forwardPayout.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.fixedPricePayout = this.fixedPricePayout.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.securityPayout = this.securityPayout.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.cashflow = this.cashflow.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.performancePayout = this.performancePayout.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.assetPayout = this.assetPayout.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.meta != null && !this.meta.prune().hasData()) {
                this.meta = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getInterestRatePayout() != null && this.getInterestRatePayout().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getCreditDefaultPayout() != null && this.getCreditDefaultPayout().hasData()) {
                return true;
            }
            if (this.getOptionPayout() != null && this.getOptionPayout().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getCommodityPayout() != null && this.getCommodityPayout().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getForwardPayout() != null && this.getForwardPayout().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getFixedPricePayout() != null && this.getFixedPricePayout().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getSecurityPayout() != null && this.getSecurityPayout().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getCashflow() != null && this.getCashflow().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getPerformancePayout() != null && this.getPerformancePayout().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            return this.getAssetPayout() != null && this.getAssetPayout().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData());
        }

        public PayoutBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            PayoutBuilder o = (PayoutBuilder)other;
            merger.mergeRosetta(this.getInterestRatePayout(), o.getInterestRatePayout(), this::getOrCreateInterestRatePayout);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCreditDefaultPayout(), (RosettaModelObjectBuilder)o.getCreditDefaultPayout(), this::setCreditDefaultPayout);
            merger.mergeRosetta(this.getOptionPayout(), o.getOptionPayout(), this::getOrCreateOptionPayout);
            merger.mergeRosetta(this.getCommodityPayout(), o.getCommodityPayout(), this::getOrCreateCommodityPayout);
            merger.mergeRosetta(this.getForwardPayout(), o.getForwardPayout(), this::getOrCreateForwardPayout);
            merger.mergeRosetta(this.getFixedPricePayout(), o.getFixedPricePayout(), this::getOrCreateFixedPricePayout);
            merger.mergeRosetta(this.getSecurityPayout(), o.getSecurityPayout(), this::getOrCreateSecurityPayout);
            merger.mergeRosetta(this.getCashflow(), o.getCashflow(), this::getOrCreateCashflow);
            merger.mergeRosetta(this.getPerformancePayout(), o.getPerformancePayout(), this::getOrCreatePerformancePayout);
            merger.mergeRosetta(this.getAssetPayout(), o.getAssetPayout(), this::getOrCreateAssetPayout);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getMeta(), (RosettaModelObjectBuilder)o.getMeta(), this::setMeta);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            Payout _that = this.getType().cast(o);
            if (!ListEquals.listEquals(this.interestRatePayout, _that.getInterestRatePayout())) {
                return false;
            }
            if (!Objects.equals(this.creditDefaultPayout, _that.getCreditDefaultPayout())) {
                return false;
            }
            if (!ListEquals.listEquals(this.optionPayout, _that.getOptionPayout())) {
                return false;
            }
            if (!ListEquals.listEquals(this.commodityPayout, _that.getCommodityPayout())) {
                return false;
            }
            if (!ListEquals.listEquals(this.forwardPayout, _that.getForwardPayout())) {
                return false;
            }
            if (!ListEquals.listEquals(this.fixedPricePayout, _that.getFixedPricePayout())) {
                return false;
            }
            if (!ListEquals.listEquals(this.securityPayout, _that.getSecurityPayout())) {
                return false;
            }
            if (!ListEquals.listEquals(this.cashflow, _that.getCashflow())) {
                return false;
            }
            if (!ListEquals.listEquals(this.performancePayout, _that.getPerformancePayout())) {
                return false;
            }
            if (!ListEquals.listEquals(this.assetPayout, _that.getAssetPayout())) {
                return false;
            }
            return Objects.equals(this.meta, _that.getMeta());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.interestRatePayout != null ? this.interestRatePayout.hashCode() : 0);
            _result = 31 * _result + (this.creditDefaultPayout != null ? this.creditDefaultPayout.hashCode() : 0);
            _result = 31 * _result + (this.optionPayout != null ? this.optionPayout.hashCode() : 0);
            _result = 31 * _result + (this.commodityPayout != null ? this.commodityPayout.hashCode() : 0);
            _result = 31 * _result + (this.forwardPayout != null ? this.forwardPayout.hashCode() : 0);
            _result = 31 * _result + (this.fixedPricePayout != null ? this.fixedPricePayout.hashCode() : 0);
            _result = 31 * _result + (this.securityPayout != null ? this.securityPayout.hashCode() : 0);
            _result = 31 * _result + (this.cashflow != null ? this.cashflow.hashCode() : 0);
            _result = 31 * _result + (this.performancePayout != null ? this.performancePayout.hashCode() : 0);
            _result = 31 * _result + (this.assetPayout != null ? this.assetPayout.hashCode() : 0);
            _result = 31 * _result + (this.meta != null ? this.meta.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "PayoutBuilder {interestRatePayout=" + this.interestRatePayout + ", creditDefaultPayout=" + this.creditDefaultPayout + ", optionPayout=" + this.optionPayout + ", commodityPayout=" + this.commodityPayout + ", forwardPayout=" + this.forwardPayout + ", fixedPricePayout=" + this.fixedPricePayout + ", securityPayout=" + this.securityPayout + ", cashflow=" + this.cashflow + ", performancePayout=" + this.performancePayout + ", assetPayout=" + this.assetPayout + ", meta=" + this.meta + '}';
        }
    }

    public static interface PayoutBuilder
    extends Payout,
    RosettaModelObjectBuilder,
    GlobalKey.GlobalKeyBuilder {
        public InterestRatePayout.InterestRatePayoutBuilder getOrCreateInterestRatePayout(int var1);

        public List<? extends InterestRatePayout.InterestRatePayoutBuilder> getInterestRatePayout();

        public CreditDefaultPayout.CreditDefaultPayoutBuilder getOrCreateCreditDefaultPayout();

        @Override
        public CreditDefaultPayout.CreditDefaultPayoutBuilder getCreditDefaultPayout();

        public OptionPayout.OptionPayoutBuilder getOrCreateOptionPayout(int var1);

        public List<? extends OptionPayout.OptionPayoutBuilder> getOptionPayout();

        public CommodityPayout.CommodityPayoutBuilder getOrCreateCommodityPayout(int var1);

        public List<? extends CommodityPayout.CommodityPayoutBuilder> getCommodityPayout();

        public ForwardPayout.ForwardPayoutBuilder getOrCreateForwardPayout(int var1);

        public List<? extends ForwardPayout.ForwardPayoutBuilder> getForwardPayout();

        public FixedPricePayout.FixedPricePayoutBuilder getOrCreateFixedPricePayout(int var1);

        public List<? extends FixedPricePayout.FixedPricePayoutBuilder> getFixedPricePayout();

        public SecurityPayout.SecurityPayoutBuilder getOrCreateSecurityPayout(int var1);

        public List<? extends SecurityPayout.SecurityPayoutBuilder> getSecurityPayout();

        public Cashflow.CashflowBuilder getOrCreateCashflow(int var1);

        public List<? extends Cashflow.CashflowBuilder> getCashflow();

        public PerformancePayout.PerformancePayoutBuilder getOrCreatePerformancePayout(int var1);

        public List<? extends PerformancePayout.PerformancePayoutBuilder> getPerformancePayout();

        public AssetPayout.AssetPayoutBuilder getOrCreateAssetPayout(int var1);

        public List<? extends AssetPayout.AssetPayoutBuilder> getAssetPayout();

        public MetaFields.MetaFieldsBuilder getOrCreateMeta();

        public MetaFields.MetaFieldsBuilder getMeta();

        public PayoutBuilder addInterestRatePayout(InterestRatePayout var1);

        public PayoutBuilder addInterestRatePayout(InterestRatePayout var1, int var2);

        public PayoutBuilder addInterestRatePayout(List<? extends InterestRatePayout> var1);

        public PayoutBuilder setInterestRatePayout(List<? extends InterestRatePayout> var1);

        public PayoutBuilder setCreditDefaultPayout(CreditDefaultPayout var1);

        public PayoutBuilder addOptionPayout(OptionPayout var1);

        public PayoutBuilder addOptionPayout(OptionPayout var1, int var2);

        public PayoutBuilder addOptionPayout(List<? extends OptionPayout> var1);

        public PayoutBuilder setOptionPayout(List<? extends OptionPayout> var1);

        public PayoutBuilder addCommodityPayout(CommodityPayout var1);

        public PayoutBuilder addCommodityPayout(CommodityPayout var1, int var2);

        public PayoutBuilder addCommodityPayout(List<? extends CommodityPayout> var1);

        public PayoutBuilder setCommodityPayout(List<? extends CommodityPayout> var1);

        public PayoutBuilder addForwardPayout(ForwardPayout var1);

        public PayoutBuilder addForwardPayout(ForwardPayout var1, int var2);

        public PayoutBuilder addForwardPayout(List<? extends ForwardPayout> var1);

        public PayoutBuilder setForwardPayout(List<? extends ForwardPayout> var1);

        public PayoutBuilder addFixedPricePayout(FixedPricePayout var1);

        public PayoutBuilder addFixedPricePayout(FixedPricePayout var1, int var2);

        public PayoutBuilder addFixedPricePayout(List<? extends FixedPricePayout> var1);

        public PayoutBuilder setFixedPricePayout(List<? extends FixedPricePayout> var1);

        public PayoutBuilder addSecurityPayout(SecurityPayout var1);

        public PayoutBuilder addSecurityPayout(SecurityPayout var1, int var2);

        public PayoutBuilder addSecurityPayout(List<? extends SecurityPayout> var1);

        public PayoutBuilder setSecurityPayout(List<? extends SecurityPayout> var1);

        public PayoutBuilder addCashflow(Cashflow var1);

        public PayoutBuilder addCashflow(Cashflow var1, int var2);

        public PayoutBuilder addCashflow(List<? extends Cashflow> var1);

        public PayoutBuilder setCashflow(List<? extends Cashflow> var1);

        public PayoutBuilder addPerformancePayout(PerformancePayout var1);

        public PayoutBuilder addPerformancePayout(PerformancePayout var1, int var2);

        public PayoutBuilder addPerformancePayout(List<? extends PerformancePayout> var1);

        public PayoutBuilder setPerformancePayout(List<? extends PerformancePayout> var1);

        public PayoutBuilder addAssetPayout(AssetPayout var1);

        public PayoutBuilder addAssetPayout(AssetPayout var1, int var2);

        public PayoutBuilder addAssetPayout(List<? extends AssetPayout> var1);

        public PayoutBuilder setAssetPayout(List<? extends AssetPayout> var1);

        public PayoutBuilder setMeta(MetaFields var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("interestRatePayout"), processor, InterestRatePayout.InterestRatePayoutBuilder.class, this.getInterestRatePayout(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("creditDefaultPayout"), processor, CreditDefaultPayout.CreditDefaultPayoutBuilder.class, this.getCreditDefaultPayout(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("optionPayout"), processor, OptionPayout.OptionPayoutBuilder.class, this.getOptionPayout(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("commodityPayout"), processor, CommodityPayout.CommodityPayoutBuilder.class, this.getCommodityPayout(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("forwardPayout"), processor, ForwardPayout.ForwardPayoutBuilder.class, this.getForwardPayout(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("fixedPricePayout"), processor, FixedPricePayout.FixedPricePayoutBuilder.class, this.getFixedPricePayout(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("securityPayout"), processor, SecurityPayout.SecurityPayoutBuilder.class, this.getSecurityPayout(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("cashflow"), processor, Cashflow.CashflowBuilder.class, this.getCashflow(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("performancePayout"), processor, PerformancePayout.PerformancePayoutBuilder.class, this.getPerformancePayout(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("assetPayout"), processor, AssetPayout.AssetPayoutBuilder.class, this.getAssetPayout(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("meta"), processor, MetaFields.MetaFieldsBuilder.class, (RosettaModelObjectBuilder)this.getMeta(), new AttributeMeta[0]);
        }

        public PayoutBuilder prune();
    }

    public static class PayoutImpl
    implements Payout {
        private final List<? extends InterestRatePayout> interestRatePayout;
        private final CreditDefaultPayout creditDefaultPayout;
        private final List<? extends OptionPayout> optionPayout;
        private final List<? extends CommodityPayout> commodityPayout;
        private final List<? extends ForwardPayout> forwardPayout;
        private final List<? extends FixedPricePayout> fixedPricePayout;
        private final List<? extends SecurityPayout> securityPayout;
        private final List<? extends Cashflow> cashflow;
        private final List<? extends PerformancePayout> performancePayout;
        private final List<? extends AssetPayout> assetPayout;
        private final MetaFields meta;

        protected PayoutImpl(PayoutBuilder builder) {
            this.interestRatePayout = Optional.ofNullable(builder.getInterestRatePayout()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.creditDefaultPayout = Optional.ofNullable(builder.getCreditDefaultPayout()).map(f -> f.build()).orElse(null);
            this.optionPayout = Optional.ofNullable(builder.getOptionPayout()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.commodityPayout = Optional.ofNullable(builder.getCommodityPayout()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.forwardPayout = Optional.ofNullable(builder.getForwardPayout()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.fixedPricePayout = Optional.ofNullable(builder.getFixedPricePayout()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.securityPayout = Optional.ofNullable(builder.getSecurityPayout()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.cashflow = Optional.ofNullable(builder.getCashflow()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.performancePayout = Optional.ofNullable(builder.getPerformancePayout()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.assetPayout = Optional.ofNullable(builder.getAssetPayout()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.meta = Optional.ofNullable(builder.getMeta()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="interestRatePayout")
        @RuneAttribute(value="interestRatePayout")
        public List<? extends InterestRatePayout> getInterestRatePayout() {
            return this.interestRatePayout;
        }

        @Override
        @RosettaAttribute(value="creditDefaultPayout")
        @RuneAttribute(value="creditDefaultPayout")
        public CreditDefaultPayout getCreditDefaultPayout() {
            return this.creditDefaultPayout;
        }

        @Override
        @RosettaAttribute(value="optionPayout")
        @RuneAttribute(value="optionPayout")
        public List<? extends OptionPayout> getOptionPayout() {
            return this.optionPayout;
        }

        @Override
        @RosettaAttribute(value="commodityPayout")
        @RuneAttribute(value="commodityPayout")
        public List<? extends CommodityPayout> getCommodityPayout() {
            return this.commodityPayout;
        }

        @Override
        @RosettaAttribute(value="forwardPayout")
        @RuneAttribute(value="forwardPayout")
        public List<? extends ForwardPayout> getForwardPayout() {
            return this.forwardPayout;
        }

        @Override
        @RosettaAttribute(value="fixedPricePayout")
        @RuneAttribute(value="fixedPricePayout")
        public List<? extends FixedPricePayout> getFixedPricePayout() {
            return this.fixedPricePayout;
        }

        @Override
        @RosettaAttribute(value="securityPayout")
        @RuneAttribute(value="securityPayout")
        public List<? extends SecurityPayout> getSecurityPayout() {
            return this.securityPayout;
        }

        @Override
        @RosettaAttribute(value="cashflow")
        @RuneAttribute(value="cashflow")
        public List<? extends Cashflow> getCashflow() {
            return this.cashflow;
        }

        @Override
        @RosettaAttribute(value="performancePayout")
        @RuneAttribute(value="performancePayout")
        public List<? extends PerformancePayout> getPerformancePayout() {
            return this.performancePayout;
        }

        @Override
        @RosettaAttribute(value="assetPayout")
        @RuneAttribute(value="assetPayout")
        public List<? extends AssetPayout> getAssetPayout() {
            return this.assetPayout;
        }

        @Override
        @RosettaAttribute(value="meta")
        @RuneAttribute(value="meta")
        @RuneMetaType
        public MetaFields getMeta() {
            return this.meta;
        }

        @Override
        public Payout build() {
            return this;
        }

        @Override
        public PayoutBuilder toBuilder() {
            PayoutBuilder builder = Payout.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(PayoutBuilder builder) {
            Optional.ofNullable(this.getInterestRatePayout()).ifPresent(builder::setInterestRatePayout);
            Optional.ofNullable(this.getCreditDefaultPayout()).ifPresent(builder::setCreditDefaultPayout);
            Optional.ofNullable(this.getOptionPayout()).ifPresent(builder::setOptionPayout);
            Optional.ofNullable(this.getCommodityPayout()).ifPresent(builder::setCommodityPayout);
            Optional.ofNullable(this.getForwardPayout()).ifPresent(builder::setForwardPayout);
            Optional.ofNullable(this.getFixedPricePayout()).ifPresent(builder::setFixedPricePayout);
            Optional.ofNullable(this.getSecurityPayout()).ifPresent(builder::setSecurityPayout);
            Optional.ofNullable(this.getCashflow()).ifPresent(builder::setCashflow);
            Optional.ofNullable(this.getPerformancePayout()).ifPresent(builder::setPerformancePayout);
            Optional.ofNullable(this.getAssetPayout()).ifPresent(builder::setAssetPayout);
            Optional.ofNullable(this.getMeta()).ifPresent(builder::setMeta);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            Payout _that = this.getType().cast(o);
            if (!ListEquals.listEquals(this.interestRatePayout, _that.getInterestRatePayout())) {
                return false;
            }
            if (!Objects.equals(this.creditDefaultPayout, _that.getCreditDefaultPayout())) {
                return false;
            }
            if (!ListEquals.listEquals(this.optionPayout, _that.getOptionPayout())) {
                return false;
            }
            if (!ListEquals.listEquals(this.commodityPayout, _that.getCommodityPayout())) {
                return false;
            }
            if (!ListEquals.listEquals(this.forwardPayout, _that.getForwardPayout())) {
                return false;
            }
            if (!ListEquals.listEquals(this.fixedPricePayout, _that.getFixedPricePayout())) {
                return false;
            }
            if (!ListEquals.listEquals(this.securityPayout, _that.getSecurityPayout())) {
                return false;
            }
            if (!ListEquals.listEquals(this.cashflow, _that.getCashflow())) {
                return false;
            }
            if (!ListEquals.listEquals(this.performancePayout, _that.getPerformancePayout())) {
                return false;
            }
            if (!ListEquals.listEquals(this.assetPayout, _that.getAssetPayout())) {
                return false;
            }
            return Objects.equals(this.meta, _that.getMeta());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.interestRatePayout != null ? this.interestRatePayout.hashCode() : 0);
            _result = 31 * _result + (this.creditDefaultPayout != null ? this.creditDefaultPayout.hashCode() : 0);
            _result = 31 * _result + (this.optionPayout != null ? this.optionPayout.hashCode() : 0);
            _result = 31 * _result + (this.commodityPayout != null ? this.commodityPayout.hashCode() : 0);
            _result = 31 * _result + (this.forwardPayout != null ? this.forwardPayout.hashCode() : 0);
            _result = 31 * _result + (this.fixedPricePayout != null ? this.fixedPricePayout.hashCode() : 0);
            _result = 31 * _result + (this.securityPayout != null ? this.securityPayout.hashCode() : 0);
            _result = 31 * _result + (this.cashflow != null ? this.cashflow.hashCode() : 0);
            _result = 31 * _result + (this.performancePayout != null ? this.performancePayout.hashCode() : 0);
            _result = 31 * _result + (this.assetPayout != null ? this.assetPayout.hashCode() : 0);
            _result = 31 * _result + (this.meta != null ? this.meta.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "Payout {interestRatePayout=" + this.interestRatePayout + ", creditDefaultPayout=" + this.creditDefaultPayout + ", optionPayout=" + this.optionPayout + ", commodityPayout=" + this.commodityPayout + ", forwardPayout=" + this.forwardPayout + ", fixedPricePayout=" + this.fixedPricePayout + ", securityPayout=" + this.securityPayout + ", cashflow=" + this.cashflow + ", performancePayout=" + this.performancePayout + ", assetPayout=" + this.assetPayout + ", meta=" + this.meta + '}';
        }
    }
}

