/*
 * Decompiled with CFR 0.152.
 */
package cdm.security.lending.functions;

import cdm.event.common.BusinessEvent;
import cdm.event.common.ExecutionInstruction;
import cdm.event.workflow.EventInstruction;
import cdm.event.workflow.Workflow;
import cdm.event.workflow.WorkflowStep;
import cdm.security.lending.functions.SettlementFunctionHelper;
import cdm.security.lending.functions.WorkflowFunctionHelper;
import com.regnosys.rosetta.common.testing.ExecutableFunction;
import com.rosetta.model.lib.records.Date;
import java.time.LocalDate;
import javax.inject.Inject;

public class RunNewSettlementWorkflow
implements ExecutableFunction<ExecutionInstruction, Workflow> {
    @Inject
    SettlementFunctionHelper settlements;
    @Inject
    WorkflowFunctionHelper workflows;

    public Workflow execute(ExecutionInstruction executionInstruction) {
        Date tradeDate = executionInstruction.getTradeDate().getValue();
        BusinessEvent executionBusinessEvent = this.settlements.createExecution(executionInstruction, tradeDate);
        WorkflowStep executionWorkflowStep = this.workflows.createWorkflowStep(executionBusinessEvent, WorkflowFunctionHelper.dateTime(tradeDate.toLocalDate(), 9, 0));
        LocalDate settlementDate = this.settlements.nearSettlementDate(executionWorkflowStep.getBusinessEvent());
        EventInstruction transferInstruction = this.settlements.createTransferInstruction(executionWorkflowStep.getBusinessEvent(), settlementDate);
        WorkflowStep proposedTransferWorkflowStep = this.workflows.createProposedWorkflowStep(executionWorkflowStep, transferInstruction, WorkflowFunctionHelper.dateTime(tradeDate.toLocalDate(), 15, 0));
        BusinessEvent transferBusinessEvent = this.settlements.createTransferBusinessEvent(transferInstruction);
        WorkflowStep acceptedTransferWorkflowStep = this.workflows.createAcceptedWorkflowStep(proposedTransferWorkflowStep, transferBusinessEvent, WorkflowFunctionHelper.dateTime(settlementDate, 18, 0));
        return Workflow.builder().addSteps(executionWorkflowStep).addSteps(proposedTransferWorkflowStep).addSteps(acceptedTransferWorkflowStep).build();
    }

    public Class<ExecutionInstruction> getInputType() {
        return ExecutionInstruction.class;
    }

    public Class<Workflow> getOutputType() {
        return Workflow.class;
    }
}

