/*
 * Decompiled with CFR 0.152.
 */
package com.rosetta.model.lib.mapper;

import com.rosetta.model.lib.mapper.AbstractMapperItem;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperBuilder;
import com.rosetta.model.lib.mapper.MapperItem;
import com.rosetta.model.lib.mapper.MapperListOfLists;
import com.rosetta.model.lib.mapper.MapperPath;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.mapper.NamedFunction;
import com.rosetta.model.lib.mapper.NamedFunctionImpl;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class MapperC<T>
implements MapperBuilder<T> {
    private final List<MapperItem<? extends T, ?>> items;

    protected MapperC(List<MapperItem<? extends T, ?>> items) {
        this.items = items;
    }

    public static <T> MapperC<T> ofNull() {
        return new MapperC<T>(new ArrayList());
    }

    @SafeVarargs
    public static <T> MapperC<T> of(MapperBuilder<? extends T> ... ts) {
        ArrayList items = new ArrayList();
        if (ts != null) {
            for (MapperBuilder<T> mapperBuilder : ts) {
                if (mapperBuilder == null) continue;
                mapperBuilder.getItems().forEach(item -> items.add((MapperItem)item));
            }
        }
        return new MapperC<T>(items);
    }

    public static <T> MapperC<T> of(List<? extends T> ts) {
        ArrayList items = new ArrayList();
        if (ts != null) {
            for (T ele : ts) {
                if (ele == null) {
                    items.add(new MapperItem(ele, MapperPath.builder().addNull(), true, Optional.empty()));
                    continue;
                }
                items.add(new MapperItem(ele, MapperPath.builder().addRoot(ele.getClass()), false, Optional.empty()));
            }
        }
        return new MapperC<T>(items);
    }

    @Override
    public <F> MapperC<F> map(String name, Function<T, F> mappingFunc) {
        return this.map(new NamedFunctionImpl<T, F>(name, mappingFunc));
    }

    @Override
    public <F> MapperC<F> map(NamedFunction<T, F> mappingFunc) {
        ArrayList results = new ArrayList();
        for (int i = 0; i < this.items.size(); ++i) {
            results.add(MapperItem.getMapperItem(this.items.get(i), mappingFunc));
        }
        return new MapperC<T>(results);
    }

    @Override
    public <F> MapperC<F> mapC(String name, Function<T, List<? extends F>> mappingFunc) {
        return this.mapC(new NamedFunctionImpl<T, List<? extends F>>(name, mappingFunc));
    }

    @Override
    public <F> MapperC<F> mapC(NamedFunction<T, List<? extends F>> mappingFunc) {
        ArrayList results = new ArrayList();
        for (int i = 0; i < this.items.size(); ++i) {
            results.addAll(MapperItem.getMapperItems(this.items.get(i), mappingFunc));
        }
        return new MapperC<T>(results);
    }

    public MapperC<T> filterItem(Predicate<MapperS<T>> predicate) {
        return new MapperC<T>(this.nonErrorItems().filter(item -> predicate.test(new MapperS(item))).collect(Collectors.toList()));
    }

    public MapperC<T> filterItemNullSafe(Function<MapperS<T>, Boolean> predicate) {
        return new MapperC<T>(this.nonErrorItems().filter(item -> {
            Boolean result = (Boolean)predicate.apply(new MapperS(item));
            return result != null && result != false;
        }).collect(Collectors.toList()));
    }

    public <F> MapperC<F> mapItem(Function<MapperS<T>, MapperS<F>> mappingFunc) {
        return MapperC.of(this.nonErrorItems().map((? super T item) -> new MapperS(item)).map((? super T m) -> (MapperS)mappingFunc.apply((MapperS)m)).map(MapperS::get).collect(Collectors.toList()));
    }

    public <F> MapperListOfLists<F> mapItemToList(Function<MapperS<T>, MapperC<F>> mappingFunc) {
        return MapperListOfLists.of(this.nonErrorItems().map((? super T item) -> new MapperS(item)).map((? super T m) -> (MapperC)mappingFunc.apply((MapperS)m)).map(MapperC::getMulti).collect(Collectors.toList()));
    }

    public <F> F apply(Function<MapperC<T>, F> f) {
        return f.apply(this);
    }

    public <F> MapperS<F> reduce(BinaryOperator<MapperS<F>> reduceFunc) {
        return this.reduce(MapperS.identity(), reduceFunc);
    }

    public <F> MapperS<F> reduce(MapperS<F> initial, BinaryOperator<MapperS<F>> reduceFunc) {
        return this.nonErrorItems().map((? super T item) -> new MapperS(item)).reduce(initial, (m1, m2) -> {
            if (m1.isIdentity()) {
                return m2;
            }
            if (m2.isIdentity()) {
                return m1;
            }
            return (MapperS)reduceFunc.apply((MapperS)m1, m2);
        });
    }

    public MapperS<Integer> sumInteger() {
        return MapperS.of(this.nonErrorItems().map(MapperItem::getMappedObject).map(Integer.class::cast).reduce(0, Integer::sum));
    }

    public MapperS<Long> sumLong() {
        return MapperS.of(this.nonErrorItems().map(MapperItem::getMappedObject).map(Long.class::cast).reduce(0L, Long::sum));
    }

    public MapperS<BigInteger> sumBigInteger() {
        return MapperS.of(this.nonErrorItems().map(MapperItem::getMappedObject).map(BigInteger.class::cast).reduce(BigInteger.ZERO, BigInteger::add));
    }

    public MapperS<BigDecimal> sumBigDecimal() {
        return MapperS.of(this.nonErrorItems().map(MapperItem::getMappedObject).map(BigDecimal.class::cast).reduce(BigDecimal.ZERO, BigDecimal::add));
    }

    public MapperS<String> join(MapperS<String> delimiter) {
        return MapperS.of(this.nonErrorItems().map(MapperItem::getMappedObject).map(String.class::cast).collect(Collectors.joining(delimiter.getOrDefault(""))));
    }

    public <F extends Comparable<F>> MapperS<T> min() {
        return this.min(x -> x);
    }

    public <F extends Comparable<F>> MapperS<T> min(Function<MapperS<T>, MapperS<F>> comparableGetter) {
        return this.nonErrorItems().map((? super T item) -> new MapperS(item)).filter(item -> ((MapperS)comparableGetter.apply((MapperS)item)).get() != null).min(Comparator.comparing(item -> (Comparable)((MapperS)comparableGetter.apply((MapperS)item)).get(), Comparator.nullsLast(Comparator.naturalOrder()))).orElse(MapperS.ofNull());
    }

    public <F extends Comparable<F>> MapperS<T> max() {
        return this.max(x -> x);
    }

    public <F extends Comparable<F>> MapperS<T> max(Function<MapperS<T>, MapperS<F>> comparableGetter) {
        return this.nonErrorItems().map((? super T item) -> new MapperS(item)).filter(item -> ((MapperS)comparableGetter.apply((MapperS)item)).get() != null).max(Comparator.comparing(item -> (Comparable)((MapperS)comparableGetter.apply((MapperS)item)).get(), Comparator.nullsFirst(Comparator.naturalOrder()))).orElse(MapperS.ofNull());
    }

    public MapperC<T> sort() {
        return MapperC.of(this.nonErrorItems().map(MapperItem::getMappedObject).sorted().collect(Collectors.toList()));
    }

    public <F extends Comparable<F>> MapperC<T> sort(Function<MapperS<T>, MapperS<F>> comparableGetter) {
        return new MapperC<T>(this.nonErrorItems().sorted(Comparator.comparing(item -> (Comparable)((MapperS)comparableGetter.apply(new MapperS(item))).get(), Comparator.nullsLast(Comparator.naturalOrder()))).collect(Collectors.toList()));
    }

    public MapperC<T> reverse() {
        List<MapperItem<? extends T, ?>> nonErrorItems = this.nonErrorItems().collect(Collectors.toList());
        Collections.reverse(nonErrorItems);
        return new MapperC<T>(nonErrorItems);
    }

    public MapperS<T> first() {
        return this.nonErrorItems().findFirst().map(MapperS::new).orElse(MapperS.ofNull());
    }

    public MapperS<T> last() {
        return this.nonErrorItems().reduce((first, second) -> second).map(MapperS::new).orElse(MapperS.ofNull());
    }

    public MapperS<T> getItem(MapperS<Integer> indexGetter) {
        List nonErrorItems = this.nonErrorItems().collect(Collectors.toList());
        Integer index = indexGetter.get();
        if (index != null && index < nonErrorItems.size()) {
            return new MapperS((MapperItem)nonErrorItems.get(index));
        }
        return MapperS.ofNull();
    }

    public MapperC<T> removeItem(MapperS<Integer> indexGetter) {
        List<MapperItem<T, ?>> nonErrorItems = this.nonErrorItems().collect(Collectors.toList());
        Integer index = indexGetter.get();
        if (index != null && index < nonErrorItems.size()) {
            nonErrorItems.remove(index);
        }
        return new MapperC<T>(nonErrorItems);
    }

    protected Stream<MapperItem<? extends T, ?>> nonErrorItems() {
        return this.items.stream().filter(i -> !i.isError());
    }

    private Stream<MapperItem<? extends T, ?>> errorItems() {
        return this.items.stream().filter(AbstractMapperItem::isError);
    }

    @Override
    public T get() {
        List collect = this.nonErrorItems().map((? super T i) -> i.getMappedObject()).collect(Collectors.toList());
        return collect.size() != 1 ? null : (T)collect.get(0);
    }

    @Override
    public T getOrDefault(T defaultValue) {
        return Optional.ofNullable(this.get()).orElse(defaultValue);
    }

    @Override
    public List<T> getMulti() {
        return this.nonErrorItems().map((? super T i) -> i.getMappedObject()).collect(Collectors.toList());
    }

    @Override
    public Optional<?> getParent() {
        List collect = this.nonErrorItems().map(this::findParent).filter(Optional::isPresent).map(Optional::get).map(MapperItem::getMappedObject).collect(Collectors.toList());
        return collect.size() == 1 ? Optional.of(collect.get(0)) : Optional.empty();
    }

    @Override
    public List<?> getParentMulti() {
        return this.nonErrorItems().map(this::findParent).filter(Optional::isPresent).map(Optional::get).map(MapperItem::getMappedObject).collect(Collectors.toList());
    }

    @Override
    public int resultCount() {
        return (int)this.nonErrorItems().count();
    }

    @Override
    public List<Mapper.Path> getPaths() {
        return this.nonErrorItems().map(AbstractMapperItem::getPath).collect(Collectors.toList());
    }

    @Override
    public List<Mapper.Path> getErrorPaths() {
        return this.errorItems().map(AbstractMapperItem::getPath).collect(Collectors.toList());
    }

    @Override
    public List<String> getErrors() {
        return this.errorItems().map(AbstractMapperItem::getPath).map((? super T p) -> String.format("[%s] is not set", p.getFullPath())).collect(Collectors.toList());
    }

    public String toString() {
        return String.join((CharSequence)",", this.items.stream().map((? super T i) -> i.getPath().getFullPath()).collect(Collectors.toList()));
    }

    @Override
    public MapperC<T> unionSame(MapperBuilder<T> other) {
        if (other instanceof MapperC) {
            MapperC otherMapperC = (MapperC)other;
            ArrayList unionItems = new ArrayList();
            unionItems.addAll(this.items);
            unionItems.addAll(otherMapperC.items);
            return new MapperC<T>(unionItems);
        }
        if (other instanceof MapperS) {
            return ((MapperS)other).unionSame((MapperBuilder)this);
        }
        throw new IllegalArgumentException("Unsupported Mapper type: " + other.getClass().getName());
    }

    public MapperC<Object> unionDifferent(MapperBuilder<?> other) {
        if (other instanceof MapperC) {
            MapperC otherMapperC = (MapperC)other;
            ArrayList unionItems = new ArrayList();
            unionItems.addAll(this.upcast(this));
            unionItems.addAll(this.upcast(otherMapperC));
            return new MapperC<T>(unionItems);
        }
        if (other instanceof MapperS) {
            return ((MapperS)other).unionDifferent((MapperBuilder)this);
        }
        throw new IllegalArgumentException("Unsupported Mapper type: " + other.getClass().getName());
    }

    private List<MapperItem<Object, ?>> upcast(MapperC<?> mapper) {
        return mapper.items.stream().map(MapperItem::upcast).collect(Collectors.toList());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.items == null ? 0 : this.items.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MapperC other = (MapperC)obj;
        return !(this.items == null ? other.items != null : !this.items.equals(other.items));
    }

    @Override
    public Stream<MapperItem<? extends T, ?>> getItems() {
        return this.items.stream();
    }
}

