/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.model.testpacks;

import com.regnosys.model.testpacks.TranslateTestPackInitialiser;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestPackBootstrapRecordKeeping {
    private static final Logger LOGGER = LoggerFactory.getLogger(TestPackBootstrapRecordKeeping.class);

    public static void main(String[] args) throws IOException {
        if (args.length < 1) {
            throw new IllegalArgumentException("Requires argument with path to sample files");
        }
        String oneDriveBasePath = args[0];
        Path baseResourcesPath = Path.of("rosetta-source/src/main/resources", new String[0]);
        Path recordKeepingTestPackBase = baseResourcesPath.resolve("cdm-sample-files/fpml-5-10/record-keeping");
        Path recordKeepingTestPackOneDriveSource = Path.of(oneDriveBasePath + "/CDM Workstreams/Reporting/Test Pack/Contribution Test Pack/Record Keeping", new String[0]);
        TestPackBootstrapRecordKeeping.copySourceFiles(recordKeepingTestPackOneDriveSource, recordKeepingTestPackBase);
        Path transparencyTestPackBase = baseResourcesPath.resolve("cdm-sample-files/fpml-5-10/transparency");
        Path transparencyTestPackOneDriveSource = Path.of(oneDriveBasePath + "/CDM Workstreams/Reporting/Test Pack/Contribution Test Pack/Transparency", new String[0]);
        TestPackBootstrapRecordKeeping.copySourceFiles(transparencyTestPackOneDriveSource, transparencyTestPackBase);
        Path cftcEventsTestPackBase = baseResourcesPath.resolve("cdm-sample-files/fpml-5-10/record-keeping/events/cftc-event-scenarios");
        Path cftcTestPackOneDriveSource = Path.of(oneDriveBasePath + "/CDM Workstreams/Reporting/Test Pack/Native CDM Events", new String[0]);
        TestPackBootstrapRecordKeeping.copySourceFiles(cftcTestPackOneDriveSource, cftcEventsTestPackBase);
        TranslateTestPackInitialiser.createBlankExpectations(baseResourcesPath, recordKeepingTestPackBase, true);
    }

    private static void copySourceFiles(Path sourceFolderPath, Path targetFolderPath) throws IOException {
        try (Stream<Path> sourceFiles = Files.walk(sourceFolderPath, FileVisitOption.FOLLOW_LINKS);){
            sourceFiles.filter(f -> f.getFileName().toString().endsWith(".xml")).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(sourceFilePath -> {
                Path relativeFilePath = sourceFolderPath.relativize((Path)sourceFilePath);
                Path targetFilePath = TestPackBootstrapRecordKeeping.sanitizePath(targetFolderPath.resolve(relativeFilePath));
                LOGGER.info("Copying {}", sourceFilePath);
                try {
                    Files.createDirectories(targetFilePath.getParent(), new FileAttribute[0]);
                    String contents = Files.readString(sourceFilePath, StandardCharsets.UTF_8);
                    String cleanedContents = contents.replaceAll("\r\n", "\n");
                    Files.write(targetFilePath, cleanedContents.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
                    Files.setPosixFilePermissions(targetFilePath, Set.of(PosixFilePermission.OWNER_READ, PosixFilePermission.OWNER_WRITE, PosixFilePermission.GROUP_READ, PosixFilePermission.OTHERS_READ));
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            });
        }
    }

    private static Path sanitizePath(Path path) {
        Path fileName = path.getFileName();
        Path parent = Path.of(path.getParent().toString().toLowerCase(Locale.ROOT), new String[0]);
        return Path.of(parent.resolve(fileName).toString().replace(" ", "-").replaceAll("-+", "-"), new String[0]);
    }
}

