/*
 * Decompiled with CFR 0.152.
 */
package drr.base.qualification.product.functions;

import cdm.product.template.OptionTypeEnum;
import cdm.product.template.Product;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import drr.base.qualification.product.functions.IsOption;
import drr.base.trade.functions.EconomicTermsForProduct;
import javax.inject.Inject;

@ImplementedBy(value=IsCallOptionDefault.class)
public abstract class IsCallOption
implements RosettaFunction {
    @Inject
    protected EconomicTermsForProduct economicTermsForProduct;
    @Inject
    protected IsOption isOption;

    public Boolean evaluate(Product product) {
        Boolean result = this.doEvaluate(product);
        return result;
    }

    protected abstract Boolean doEvaluate(Product var1);

    public static class IsCallOptionDefault
    extends IsCallOption {
        @Override
        protected Boolean doEvaluate(Product product) {
            Boolean result = null;
            return this.assignOutput(result, product);
        }

        protected Boolean assignOutput(Boolean result, Product product) {
            result = ComparisonResult.of((Mapper)MapperS.of((Object)this.isOption.evaluate(product))).and(ExpressionOperators.areEqual((Mapper)MapperS.of((Object)this.economicTermsForProduct.evaluate(product)).map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getOptionPayout", payout -> payout.getOptionPayout()).map("getOptionType", optionPayout -> optionPayout.getOptionType()), (Mapper)MapperS.of((Object)OptionTypeEnum.CALL), (CardinalityOperator)CardinalityOperator.All).or(ExpressionOperators.areEqual((Mapper)MapperS.of((Object)this.economicTermsForProduct.evaluate(product)).map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getOptionPayout", payout -> payout.getOptionPayout()).map("getOptionType", optionPayout -> optionPayout.getOptionType()), (Mapper)MapperS.of((Object)OptionTypeEnum.PAYER), (CardinalityOperator)CardinalityOperator.All))).get();
            return result;
        }
    }
}

