/*
 * Decompiled with CFR 0.152.
 */
package drr.base.trade.functions;

import cdm.product.template.EconomicTerms;
import cdm.product.template.Product;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import drr.base.qualification.product.functions.IsProductETD;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=EconomicTermsForProductDefault.class)
public abstract class EconomicTermsForProduct
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected IsProductETD isProductETD;

    public EconomicTerms evaluate(Product product) {
        EconomicTerms economicTerms;
        EconomicTerms.EconomicTermsBuilder economicTermsBuilder = this.doEvaluate(product);
        if (economicTermsBuilder == null) {
            economicTerms = null;
        } else {
            economicTerms = economicTermsBuilder.build();
            this.objectValidator.validate(EconomicTerms.class, (RosettaModelObject)economicTerms);
        }
        return economicTerms;
    }

    protected abstract EconomicTerms.EconomicTermsBuilder doEvaluate(Product var1);

    public static class EconomicTermsForProductDefault
    extends EconomicTermsForProduct {
        @Override
        protected EconomicTerms.EconomicTermsBuilder doEvaluate(Product product) {
            EconomicTerms.EconomicTermsBuilder economicTerms = EconomicTerms.builder();
            return this.assignOutput(economicTerms, product);
        }

        protected EconomicTerms.EconomicTermsBuilder assignOutput(EconomicTerms.EconomicTermsBuilder economicTerms, Product product) {
            economicTerms = ExpressionOperators.exists((Mapper)MapperS.of((Object)product).map("getContractualProduct", _product -> _product.getContractualProduct()).map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms())).getOrDefault(Boolean.valueOf(false)) != false ? (EconomicTerms.EconomicTermsBuilder)this.toBuilder((RosettaModelObject)MapperS.of((Object)product).map("getContractualProduct", _product -> _product.getContractualProduct()).map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).get()) : (ComparisonResult.of((Mapper)MapperS.of((Object)this.isProductETD.evaluate(product))).and(ExpressionOperators.exists((Mapper)MapperS.of((Object)product).map("getSecurity", _product -> _product.getSecurity()).map("getEconomicTerms", security -> security.getEconomicTerms()))).getOrDefault(Boolean.valueOf(false)) != false ? (EconomicTerms.EconomicTermsBuilder)this.toBuilder((RosettaModelObject)MapperS.of((Object)product).map("getSecurity", _product -> _product.getSecurity()).map("getEconomicTerms", security -> security.getEconomicTerms()).get()) : null);
            return Optional.ofNullable(economicTerms).map(o -> o.prune()).orElse(null);
        }
    }
}

