/*
 * Decompiled with CFR 0.152.
 */
package drr.base.trade.price;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.model.lib.records.Date;
import drr.base.trade.price.PriceFormat;
import drr.base.trade.price.meta.PricePeriodMeta;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="PricePeriod", builder=PricePeriodBuilderImpl.class, version="7.0.0-dev.17")
@RuneDataType(value="PricePeriod", model="drr", builder=PricePeriodBuilderImpl.class, version="7.0.0-dev.17")
public interface PricePeriod
extends RosettaModelObject {
    public static final PricePeriodMeta metaData = new PricePeriodMeta();

    public PriceFormat getPrice();

    public Date getEffectiveDate();

    public Date getEndDate();

    public PricePeriod build();

    public PricePeriodBuilder toBuilder();

    public static PricePeriodBuilder builder() {
        return new PricePeriodBuilderImpl();
    }

    default public RosettaMetaData<? extends PricePeriod> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends PricePeriod> getType() {
        return PricePeriod.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("price"), processor, PriceFormat.class, this.getPrice(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("effectiveDate"), Date.class, (Object)this.getEffectiveDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("endDate"), Date.class, (Object)this.getEndDate(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class PricePeriodBuilderImpl
    implements PricePeriodBuilder {
        protected PriceFormat.PriceFormatBuilder price;
        protected Date effectiveDate;
        protected Date endDate;

        @Override
        @RosettaAttribute(value="price", isRequired=true)
        @RuneAttribute(value="price", isRequired=true)
        public PriceFormat.PriceFormatBuilder getPrice() {
            return this.price;
        }

        @Override
        public PriceFormat.PriceFormatBuilder getOrCreatePrice() {
            PriceFormat.PriceFormatBuilder result = this.price != null ? this.price : (this.price = PriceFormat.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="effectiveDate", isRequired=true)
        @RuneAttribute(value="effectiveDate", isRequired=true)
        public Date getEffectiveDate() {
            return this.effectiveDate;
        }

        @Override
        @RosettaAttribute(value="endDate")
        @RuneAttribute(value="endDate")
        public Date getEndDate() {
            return this.endDate;
        }

        @Override
        @RosettaAttribute(value="price", isRequired=true)
        @RuneAttribute(value="price", isRequired=true)
        public PricePeriodBuilder setPrice(PriceFormat _price) {
            this.price = _price == null ? null : _price.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="effectiveDate", isRequired=true)
        @RuneAttribute(value="effectiveDate", isRequired=true)
        public PricePeriodBuilder setEffectiveDate(Date _effectiveDate) {
            this.effectiveDate = _effectiveDate == null ? null : _effectiveDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="endDate")
        @RuneAttribute(value="endDate")
        public PricePeriodBuilder setEndDate(Date _endDate) {
            this.endDate = _endDate == null ? null : _endDate;
            return this;
        }

        @Override
        public PricePeriod build() {
            return new PricePeriodImpl(this);
        }

        @Override
        public PricePeriodBuilder toBuilder() {
            return this;
        }

        @Override
        public PricePeriodBuilder prune() {
            if (this.price != null && !this.price.prune().hasData()) {
                this.price = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getPrice() != null && this.getPrice().hasData()) {
                return true;
            }
            if (this.getEffectiveDate() != null) {
                return true;
            }
            return this.getEndDate() != null;
        }

        public PricePeriodBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            PricePeriodBuilder o = (PricePeriodBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPrice(), (RosettaModelObjectBuilder)o.getPrice(), this::setPrice);
            merger.mergeBasic((Object)this.getEffectiveDate(), (Object)o.getEffectiveDate(), this::setEffectiveDate, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getEndDate(), (Object)o.getEndDate(), this::setEndDate, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            PricePeriod _that = this.getType().cast(o);
            if (!Objects.equals(this.price, _that.getPrice())) {
                return false;
            }
            if (!Objects.equals(this.effectiveDate, _that.getEffectiveDate())) {
                return false;
            }
            return Objects.equals(this.endDate, _that.getEndDate());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.price != null ? this.price.hashCode() : 0);
            _result = 31 * _result + (this.effectiveDate != null ? this.effectiveDate.hashCode() : 0);
            _result = 31 * _result + (this.endDate != null ? this.endDate.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "PricePeriodBuilder {price=" + String.valueOf(this.price) + ", effectiveDate=" + String.valueOf(this.effectiveDate) + ", endDate=" + String.valueOf(this.endDate) + "}";
        }
    }

    public static interface PricePeriodBuilder
    extends PricePeriod,
    RosettaModelObjectBuilder {
        public PriceFormat.PriceFormatBuilder getOrCreatePrice();

        @Override
        public PriceFormat.PriceFormatBuilder getPrice();

        public PricePeriodBuilder setPrice(PriceFormat var1);

        public PricePeriodBuilder setEffectiveDate(Date var1);

        public PricePeriodBuilder setEndDate(Date var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("price"), processor, PriceFormat.PriceFormatBuilder.class, this.getPrice(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("effectiveDate"), Date.class, (Object)this.getEffectiveDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("endDate"), Date.class, (Object)this.getEndDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        public PricePeriodBuilder prune();
    }

    public static class PricePeriodImpl
    implements PricePeriod {
        private final PriceFormat price;
        private final Date effectiveDate;
        private final Date endDate;

        protected PricePeriodImpl(PricePeriodBuilder builder) {
            this.price = Optional.ofNullable(builder.getPrice()).map(f -> f.build()).orElse(null);
            this.effectiveDate = builder.getEffectiveDate();
            this.endDate = builder.getEndDate();
        }

        @Override
        @RosettaAttribute(value="price", isRequired=true)
        @RuneAttribute(value="price", isRequired=true)
        public PriceFormat getPrice() {
            return this.price;
        }

        @Override
        @RosettaAttribute(value="effectiveDate", isRequired=true)
        @RuneAttribute(value="effectiveDate", isRequired=true)
        public Date getEffectiveDate() {
            return this.effectiveDate;
        }

        @Override
        @RosettaAttribute(value="endDate")
        @RuneAttribute(value="endDate")
        public Date getEndDate() {
            return this.endDate;
        }

        @Override
        public PricePeriod build() {
            return this;
        }

        @Override
        public PricePeriodBuilder toBuilder() {
            PricePeriodBuilder builder = PricePeriod.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(PricePeriodBuilder builder) {
            Optional.ofNullable(this.getPrice()).ifPresent(builder::setPrice);
            Optional.ofNullable(this.getEffectiveDate()).ifPresent(builder::setEffectiveDate);
            Optional.ofNullable(this.getEndDate()).ifPresent(builder::setEndDate);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            PricePeriod _that = this.getType().cast(o);
            if (!Objects.equals(this.price, _that.getPrice())) {
                return false;
            }
            if (!Objects.equals(this.effectiveDate, _that.getEffectiveDate())) {
                return false;
            }
            return Objects.equals(this.endDate, _that.getEndDate());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.price != null ? this.price.hashCode() : 0);
            _result = 31 * _result + (this.effectiveDate != null ? this.effectiveDate.hashCode() : 0);
            _result = 31 * _result + (this.endDate != null ? this.endDate.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "PricePeriod {price=" + String.valueOf(this.price) + ", effectiveDate=" + String.valueOf(this.effectiveDate) + ", endDate=" + String.valueOf(this.endDate) + "}";
        }
    }
}

