/*
 * Decompiled with CFR 0.152.
 */
package drr.base.trade.price.functions;

import cdm.observable.asset.PriceOperandEnum;
import cdm.observable.asset.PriceSchedule;
import cdm.product.template.SchedulePeriod;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import java.math.BigDecimal;

@ImplementedBy(value=ExtractPriceValueDefault.class)
public abstract class ExtractPriceValue
implements RosettaFunction {
    public BigDecimal evaluate(PriceSchedule price, SchedulePeriod schedulePeriod) {
        BigDecimal amount = this.doEvaluate(price, schedulePeriod);
        return amount;
    }

    protected abstract BigDecimal doEvaluate(PriceSchedule var1, SchedulePeriod var2);

    public static class ExtractPriceValueDefault
    extends ExtractPriceValue {
        @Override
        protected BigDecimal doEvaluate(PriceSchedule price, SchedulePeriod schedulePeriod) {
            BigDecimal amount = null;
            return this.assignOutput(amount, price, schedulePeriod);
        }

        protected BigDecimal assignOutput(BigDecimal amount, PriceSchedule price, SchedulePeriod schedulePeriod) {
            if (ExpressionOperators.areEqual((Mapper)MapperS.of((Object)price).map("getComposite", priceSchedule -> priceSchedule.getComposite()).map("getOperandType", priceComposite -> priceComposite.getOperandType()), (Mapper)MapperS.of((Object)PriceOperandEnum.ACCRUED_INTEREST), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                amount = (BigDecimal)MapperS.of((Object)price).map("getComposite", priceSchedule -> priceSchedule.getComposite()).map("getBaseValue", priceComposite -> priceComposite.getBaseValue()).get();
            } else if (ExpressionOperators.exists((Mapper)MapperS.of((Object)price).map("getValue", priceSchedule -> priceSchedule.getValue())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                amount = (BigDecimal)MapperS.of((Object)price).map("getValue", priceSchedule -> priceSchedule.getValue()).get();
            } else if (ExpressionOperators.exists((Mapper)MapperS.of((Object)price).mapC("getDatedValue", priceSchedule -> priceSchedule.getDatedValue())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                MapperC thenArg0 = MapperS.of((Object)price).mapC("getDatedValue", priceSchedule -> priceSchedule.getDatedValue()).filterItemNullSafe(item -> ExpressionOperators.areEqual((Mapper)item.map("getDate", datedValue -> datedValue.getDate()), (Mapper)MapperS.of((Object)schedulePeriod).map("getCalculationPeriod", _schedulePeriod -> _schedulePeriod.getCalculationPeriod()).map("getStartDate", dateRange -> dateRange.getStartDate()), (CardinalityOperator)CardinalityOperator.All).get());
                MapperC thenArg1 = thenArg0.mapItem(item -> item.map("getValue", datedValue -> datedValue.getValue()));
                amount = (BigDecimal)MapperS.of((Object)((BigDecimal)thenArg1.get())).get();
            } else {
                amount = null;
            }
            return amount;
        }
    }
}

