/*
 * Decompiled with CFR 0.152.
 */
package drr.base.trade.quantity.functions;

import cdm.product.template.TradableProduct;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;
import drr.base.qualification.event.functions.IsActionTypeTERM;
import drr.base.trade.ReportableEventBase;
import drr.base.trade.functions.BeforeTradeForEvent;
import drr.base.trade.functions.TradableProductForEvent;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=GetProductForQuantityDefault.class)
public abstract class GetProductForQuantity
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected BeforeTradeForEvent beforeTradeForEvent;
    @Inject
    protected IsActionTypeTERM isActionTypeTERM;
    @Inject
    protected TradableProductForEvent tradableProductForEvent;

    public TradableProduct evaluate(ReportableEventBase reportableEvent) {
        TradableProduct product;
        TradableProduct.TradableProductBuilder productBuilder = this.doEvaluate(reportableEvent);
        if (productBuilder == null) {
            product = null;
        } else {
            product = productBuilder.build();
            this.objectValidator.validate(TradableProduct.class, (RosettaModelObject)product);
        }
        return product;
    }

    protected abstract TradableProduct.TradableProductBuilder doEvaluate(ReportableEventBase var1);

    public static class GetProductForQuantityDefault
    extends GetProductForQuantity {
        @Override
        protected TradableProduct.TradableProductBuilder doEvaluate(ReportableEventBase reportableEvent) {
            TradableProduct.TradableProductBuilder product = TradableProduct.builder();
            return this.assignOutput(product, reportableEvent);
        }

        protected TradableProduct.TradableProductBuilder assignOutput(TradableProduct.TradableProductBuilder product, ReportableEventBase reportableEvent) {
            Boolean _boolean = this.isActionTypeTERM.evaluate(reportableEvent);
            product = _boolean != null && _boolean != false ? (TradableProduct.TradableProductBuilder)this.toBuilder((RosettaModelObject)MapperS.of((Object)this.beforeTradeForEvent.evaluate(reportableEvent)).map("getTradableProduct", trade -> trade.getTradableProduct()).get()) : (TradableProduct.TradableProductBuilder)this.toBuilder((RosettaModelObject)this.tradableProductForEvent.evaluate(reportableEvent));
            return Optional.ofNullable(product).map(o -> o.prune()).orElse(null);
        }
    }
}

