/*
 * Decompiled with CFR 0.152.
 */
package drr.base.trade.underlier.functions;

import cdm.base.staticdata.asset.common.ProductIdTypeEnum;
import cdm.base.staticdata.asset.common.ProductIdentifier;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=FilterProductIdentifierDefault.class)
public abstract class FilterProductIdentifier
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;

    public ProductIdentifier evaluate(List<? extends ProductIdentifier> productIdentifiers, ProductIdTypeEnum productIdentificationType) {
        ProductIdentifier productIdentifier;
        ProductIdentifier.ProductIdentifierBuilder productIdentifierBuilder = this.doEvaluate(productIdentifiers, productIdentificationType);
        if (productIdentifierBuilder == null) {
            productIdentifier = null;
        } else {
            productIdentifier = productIdentifierBuilder.build();
            this.objectValidator.validate(ProductIdentifier.class, (RosettaModelObject)productIdentifier);
        }
        return productIdentifier;
    }

    protected abstract ProductIdentifier.ProductIdentifierBuilder doEvaluate(List<? extends ProductIdentifier> var1, ProductIdTypeEnum var2);

    public static class FilterProductIdentifierDefault
    extends FilterProductIdentifier {
        @Override
        protected ProductIdentifier.ProductIdentifierBuilder doEvaluate(List<? extends ProductIdentifier> productIdentifiers, ProductIdTypeEnum productIdentificationType) {
            if (productIdentifiers == null) {
                productIdentifiers = Collections.emptyList();
            }
            ProductIdentifier.ProductIdentifierBuilder productIdentifier = ProductIdentifier.builder();
            return this.assignOutput(productIdentifier, productIdentifiers, productIdentificationType);
        }

        protected ProductIdentifier.ProductIdentifierBuilder assignOutput(ProductIdentifier.ProductIdentifierBuilder productIdentifier, List<? extends ProductIdentifier> productIdentifiers, ProductIdTypeEnum productIdentificationType) {
            if (ExpressionOperators.areEqual((Mapper)MapperC.of(productIdentifiers).map("getSource", _productIdentifier -> _productIdentifier.getSource()), (Mapper)MapperS.of((Object)productIdentificationType), (CardinalityOperator)CardinalityOperator.Any).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                MapperC thenArg = MapperC.of(productIdentifiers).filterItemNullSafe(item -> ExpressionOperators.areEqual((Mapper)item.map("getSource", _productIdentifier -> _productIdentifier.getSource()), (Mapper)MapperS.of((Object)productIdentificationType), (CardinalityOperator)CardinalityOperator.All).get());
                productIdentifier = (ProductIdentifier.ProductIdentifierBuilder)this.toBuilder((RosettaModelObject)thenArg.first().get());
            } else {
                productIdentifier = (ProductIdentifier.ProductIdentifierBuilder)this.toBuilder((RosettaModelObject)MapperC.of(productIdentifiers).first().get());
            }
            return Optional.ofNullable(productIdentifier).map(o -> o.prune()).orElse(null);
        }
    }
}

