/*
 * Decompiled with CFR 0.152.
 */
package drr.projection.iso20022.jfsa.rewrite.margin.functions;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.annotations.RuneLabelProvider;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import drr.projection.iso20022.jfsa.rewrite.margin.functions.Create_MarginReportData;
import drr.projection.iso20022.jfsa.rewrite.margin.labels.Project_JFSARewriteMarginReportToIso20022LabelProvider;
import drr.regulation.jfsa.rewrite.margin.CollateralReport;
import drr.regulation.jfsa.rewrite.margin.JFSAMarginReport;
import drr.regulation.jfsa.rewrite.margin.PartiesToTheDerivative;
import drr.standards.iso.MarginActionEnum;
import iso20022.auth108.jfsa.Document;
import iso20022.auth108.jfsa.MarginReportData9__1;
import iso20022.auth108.jfsa.TradeReport34Choice__1;
import java.util.Collections;
import java.util.Optional;
import javax.inject.Inject;

@RuneLabelProvider(labelProvider=Project_JFSARewriteMarginReportToIso20022LabelProvider.class)
@ImplementedBy(value=Project_JFSARewriteMarginReportToIso20022Default.class)
public abstract class Project_JFSARewriteMarginReportToIso20022
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected Create_MarginReportData create_MarginReportData;

    public Document evaluate(JFSAMarginReport marginReport) {
        Document iso20022Report;
        Document.DocumentBuilder iso20022ReportBuilder = this.doEvaluate(marginReport);
        if (iso20022ReportBuilder == null) {
            iso20022Report = null;
        } else {
            iso20022Report = iso20022ReportBuilder.build();
            this.objectValidator.validate(Document.class, (RosettaModelObject)iso20022Report);
        }
        return iso20022Report;
    }

    protected abstract Document.DocumentBuilder doEvaluate(JFSAMarginReport var1);

    public static class Project_JFSARewriteMarginReportToIso20022Default
    extends Project_JFSARewriteMarginReportToIso20022 {
        @Override
        protected Document.DocumentBuilder doEvaluate(JFSAMarginReport marginReport) {
            Document.DocumentBuilder iso20022Report = Document.builder();
            return this.assignOutput(iso20022Report, marginReport);
        }

        protected Document.DocumentBuilder assignOutput(Document.DocumentBuilder iso20022Report, JFSAMarginReport marginReport) {
            MarginReportData9__1 ifThenElseResult = null;
            if (ExpressionOperators.areEqual((Mapper)MapperS.of((Object)marginReport).map("getCollateral", jFSAMarginReport -> jFSAMarginReport.getCollateral()).map("getActionType", collateralReport -> collateralReport.getActionType()), (Mapper)MapperS.of((Object)((Object)MarginActionEnum.MARU)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                ifThenElseResult = this.create_MarginReportData.evaluate((PartiesToTheDerivative)MapperS.of((Object)marginReport).map("getPartiesToTheDerivative", jFSAMarginReport -> jFSAMarginReport.getPartiesToTheDerivative()).get(), (CollateralReport)MapperS.of((Object)marginReport).map("getCollateral", jFSAMarginReport -> jFSAMarginReport.getCollateral()).get());
            }
            TradeReport34Choice__1 tradeReport34Choice__1 = TradeReport34Choice__1.builder().setMrgnUpd(ifThenElseResult).build();
            iso20022Report.getOrCreateDerivsTradMrgnDataRpt().getOrCreateTradData().setRpt(tradeReport34Choice__1 == null ? Collections.emptyList() : Collections.singletonList(tradeReport34Choice__1));
            return Optional.ofNullable(iso20022Report).map(o -> o.prune()).orElse(null);
        }
    }
}

