/*
 * Decompiled with CFR 0.152.
 */
package drr.projection.iso20022.jfsa.rewrite.trade.functions;

import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;
import drr.regulation.jfsa.rewrite.trade.JFSATransactionReport;
import iso20022.auth030.jfsa.ActiveOrHistoricCurrencyAnd5DecimalAmount;
import java.math.BigDecimal;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=GetCallAmtDefault.class)
public abstract class GetCallAmt
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;

    public ActiveOrHistoricCurrencyAnd5DecimalAmount evaluate(JFSATransactionReport drrReport) {
        ActiveOrHistoricCurrencyAnd5DecimalAmount callAmt;
        ActiveOrHistoricCurrencyAnd5DecimalAmount.ActiveOrHistoricCurrencyAnd5DecimalAmountBuilder callAmtBuilder = this.doEvaluate(drrReport);
        if (callAmtBuilder == null) {
            callAmt = null;
        } else {
            callAmt = callAmtBuilder.build();
            this.objectValidator.validate(ActiveOrHistoricCurrencyAnd5DecimalAmount.class, (RosettaModelObject)callAmt);
        }
        return callAmt;
    }

    protected abstract ActiveOrHistoricCurrencyAnd5DecimalAmount.ActiveOrHistoricCurrencyAnd5DecimalAmountBuilder doEvaluate(JFSATransactionReport var1);

    public static class GetCallAmtDefault
    extends GetCallAmt {
        @Override
        protected ActiveOrHistoricCurrencyAnd5DecimalAmount.ActiveOrHistoricCurrencyAnd5DecimalAmountBuilder doEvaluate(JFSATransactionReport drrReport) {
            ActiveOrHistoricCurrencyAnd5DecimalAmount.ActiveOrHistoricCurrencyAnd5DecimalAmountBuilder callAmt = ActiveOrHistoricCurrencyAnd5DecimalAmount.builder();
            return this.assignOutput(callAmt, drrReport);
        }

        protected ActiveOrHistoricCurrencyAnd5DecimalAmount.ActiveOrHistoricCurrencyAnd5DecimalAmountBuilder assignOutput(ActiveOrHistoricCurrencyAnd5DecimalAmount.ActiveOrHistoricCurrencyAnd5DecimalAmountBuilder callAmt, JFSATransactionReport drrReport) {
            callAmt = (ActiveOrHistoricCurrencyAnd5DecimalAmount.ActiveOrHistoricCurrencyAnd5DecimalAmountBuilder)this.toBuilder((RosettaModelObject)ActiveOrHistoricCurrencyAnd5DecimalAmount.builder().setValue((BigDecimal)MapperS.of((Object)drrReport).map("getCallAmount", jFSATransactionReport -> jFSATransactionReport.getCallAmount()).get()).setCcy((String)MapperS.of((Object)drrReport).map("getCallCurrency", jFSATransactionReport -> jFSATransactionReport.getCallCurrency()).map("to-string", ISOCurrencyCodeEnum::toDisplayString).get()).build());
            return Optional.ofNullable(callAmt).map(o -> o.prune()).orElse(null);
        }
    }
}

