/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.asic.rewrite.trade.functions;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.records.Date;
import drr.regulation.common.trade.CommonLeg;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=ASICLegEnrichmentDefault.class)
public abstract class ASICLegEnrichment
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;

    public CommonLeg evaluate(CommonLeg legEnrichment, Date nextFloatingReferenceResetDate) {
        CommonLeg asicEnrichedLeg;
        CommonLeg.CommonLegBuilder asicEnrichedLegBuilder = this.doEvaluate(legEnrichment, nextFloatingReferenceResetDate);
        if (asicEnrichedLegBuilder == null) {
            asicEnrichedLeg = null;
        } else {
            asicEnrichedLeg = asicEnrichedLegBuilder.build();
            this.objectValidator.validate(CommonLeg.class, (RosettaModelObject)asicEnrichedLeg);
        }
        return asicEnrichedLeg;
    }

    protected abstract CommonLeg.CommonLegBuilder doEvaluate(CommonLeg var1, Date var2);

    public static class ASICLegEnrichmentDefault
    extends ASICLegEnrichment {
        @Override
        protected CommonLeg.CommonLegBuilder doEvaluate(CommonLeg legEnrichment, Date nextFloatingReferenceResetDate) {
            CommonLeg.CommonLegBuilder asicEnrichedLeg = CommonLeg.builder();
            return this.assignOutput(asicEnrichedLeg, legEnrichment, nextFloatingReferenceResetDate);
        }

        protected CommonLeg.CommonLegBuilder assignOutput(CommonLeg.CommonLegBuilder asicEnrichedLeg, CommonLeg legEnrichment, Date nextFloatingReferenceResetDate) {
            asicEnrichedLeg = (CommonLeg.CommonLegBuilder)this.toBuilder(legEnrichment, () -> CommonLeg.builder());
            asicEnrichedLeg.setNextFloatingReferenceResetDate(nextFloatingReferenceResetDate);
            return Optional.ofNullable(asicEnrichedLeg).map(o -> o.prune()).orElse(null);
        }
    }
}

