/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.asic.rewrite.trade.reports;

import cdm.base.staticdata.asset.common.ProductIdTypeEnum;
import cdm.product.template.Product;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import com.rosetta.model.metafields.FieldWithMetaString;
import drr.base.trade.ReportableEventBase;
import drr.base.trade.functions.EconomicTermsForProduct;
import drr.base.trade.functions.ProductForEvent;
import drr.base.trade.underlier.functions.UnderlierForProduct;
import drr.regulation.asic.rewrite.trade.functions.IsAllowableActionForASIC;
import drr.regulation.common.ReportableEvent;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.GetUnderlierProductIdentifier;
import drr.regulation.common.functions.IsFRA;
import javax.inject.Inject;

@ImplementedBy(value=UnderlyingIdentificationRuleDefault.class)
public abstract class UnderlyingIdentificationRule
implements ReportFunction<TransactionReportInstruction, String> {
    @Inject
    protected EconomicTermsForProduct economicTermsForProduct;
    @Inject
    protected GetUnderlierProductIdentifier getUnderlierProductIdentifier;
    @Inject
    protected IsAllowableActionForASIC isAllowableActionForASIC;
    @Inject
    protected IsFRA isFRA;
    @Inject
    protected ProductForEvent productForEvent;
    @Inject
    protected UnderlierForProduct underlierForProduct;

    public String evaluate(TransactionReportInstruction input) {
        String output = this.doEvaluate(input);
        return output;
    }

    protected abstract String doEvaluate(TransactionReportInstruction var1);

    public static class UnderlyingIdentificationRuleDefault
    extends UnderlyingIdentificationRule {
        @Override
        protected String doEvaluate(TransactionReportInstruction input) {
            String output = null;
            return this.assignOutput(output, input);
        }

        protected String assignOutput(String output, TransactionReportInstruction input) {
            MapperS thenArg0 = MapperS.of((Object)input).filterSingleNullSafe(item -> this.isAllowableActionForASIC.evaluate((ReportableEvent)item.get()));
            MapperS thenArg1 = thenArg0.mapSingleToItem(item -> MapperS.of((Object)this.productForEvent.evaluate((ReportableEventBase)item.get())));
            FieldWithMetaString fieldWithMetaString = (FieldWithMetaString)thenArg1.mapSingleToItem(item -> {
                if (ExpressionOperators.exists((Mapper)MapperC.of(this.getUnderlierProductIdentifier.evaluate((Product)item.get()))).and(ExpressionOperators.areEqual((Mapper)MapperC.of(this.getUnderlierProductIdentifier.evaluate((Product)item.get())).map("getSource", productIdentifier -> productIdentifier.getSource()), (Mapper)MapperS.of((Object)ProductIdTypeEnum.ISIN), (CardinalityOperator)CardinalityOperator.Any)).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return MapperC.of(this.getUnderlierProductIdentifier.evaluate((Product)item.get())).first().map("getIdentifier", productIdentifier -> productIdentifier.getIdentifier());
                }
                if (ExpressionOperators.exists((Mapper)MapperS.of((Object)this.economicTermsForProduct.evaluate((Product)item.get())).map("getPayout", economicTerms -> economicTerms.getPayout()).map("getCreditDefaultPayout", payout -> payout.getCreditDefaultPayout()).map("getGeneralTerms", creditDefaultPayout -> creditDefaultPayout.getGeneralTerms()).map("getIndexReferenceInformation", generalTerms -> generalTerms.getIndexReferenceInformation()).mapC("getIndexId", creditIndexReferenceInformation -> creditIndexReferenceInformation.getIndexId())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return MapperS.of((Object)this.economicTermsForProduct.evaluate((Product)item.get())).map("getPayout", economicTerms -> economicTerms.getPayout()).map("getCreditDefaultPayout", payout -> payout.getCreditDefaultPayout()).map("getGeneralTerms", creditDefaultPayout -> creditDefaultPayout.getGeneralTerms()).map("getIndexReferenceInformation", generalTerms -> generalTerms.getIndexReferenceInformation()).mapC("getIndexId", creditIndexReferenceInformation -> creditIndexReferenceInformation.getIndexId()).first();
                }
                if (ExpressionOperators.exists((Mapper)MapperS.of((Object)this.economicTermsForProduct.evaluate(this.underlierForProduct.evaluate((Product)item.get()))).map("getPayout", economicTerms -> economicTerms.getPayout()).map("getCreditDefaultPayout", payout -> payout.getCreditDefaultPayout()).map("getGeneralTerms", creditDefaultPayout -> creditDefaultPayout.getGeneralTerms()).map("getIndexReferenceInformation", generalTerms -> generalTerms.getIndexReferenceInformation()).mapC("getIndexId", creditIndexReferenceInformation -> creditIndexReferenceInformation.getIndexId())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return MapperS.of((Object)this.economicTermsForProduct.evaluate(this.underlierForProduct.evaluate((Product)item.get()))).map("getPayout", economicTerms -> economicTerms.getPayout()).map("getCreditDefaultPayout", payout -> payout.getCreditDefaultPayout()).map("getGeneralTerms", creditDefaultPayout -> creditDefaultPayout.getGeneralTerms()).map("getIndexReferenceInformation", generalTerms -> generalTerms.getIndexReferenceInformation()).mapC("getIndexId", creditIndexReferenceInformation -> creditIndexReferenceInformation.getIndexId()).first();
                }
                Boolean _boolean = this.isFRA.evaluate((Product)item.get());
                if (_boolean != null && _boolean.booleanValue()) {
                    return MapperS.of((Object)this.economicTermsForProduct.evaluate((Product)item.get())).map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getInterestRatePayout", payout -> payout.getInterestRatePayout()).map("getRateSpecification", interestRatePayout -> interestRatePayout.getRateSpecification()).map("getFloatingRate", rateSpecification -> rateSpecification.getFloatingRate()).map("getRateOption", floatingRateSpecification -> floatingRateSpecification.getRateOption()).map("Type coercion", referenceWithMetaFloatingRateOption -> referenceWithMetaFloatingRateOption.getValue()).map("getIndexReferenceInformation", floatingRateOption -> floatingRateOption.getIndexReferenceInformation()).mapC("getIndexId", indexReferenceInformation -> indexReferenceInformation.getIndexId()).first();
                }
                return MapperS.ofNull();
            }).get();
            output = fieldWithMetaString == null ? null : fieldWithMetaString.getValue();
            return output;
        }
    }
}

