/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.asic.rewrite.trade.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperBuilder;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.asic.rewrite.trade.ASICTransactionReport;
import drr.regulation.common.CommonAssetClass;
import drr.regulation.common.CommonContractType;
import drr.standards.iso.ActionTypeEnum;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="ASICTransactionReportDTCC_ASIC_BR_1047_02")
@ImplementedBy(value=Default.class)
public interface ASICTransactionReportDTCC_ASIC_BR_1047_02
extends Validator<ASICTransactionReport> {
    public static final String NAME = "ASICTransactionReportDTCC_ASIC_BR_1047_02";
    public static final String DEFINITION = "if [ActionTypeEnum -> NEWT, ActionTypeEnum -> MODI, ActionTypeEnum -> CORR, ActionTypeEnum -> REVI] any = actionType and ((CommonAssetClass -> INTR = assetClass and [CommonContractType -> FRAS, CommonContractType -> FORW, CommonContractType -> OPTN, CommonContractType -> SWAP, CommonContractType -> SWPT, CommonContractType -> OTHR] any = contractType) or [CommonAssetClass -> EQUI, CommonAssetClass -> COMM] any = assetClass and [CommonContractType -> FRAS, CommonContractType -> OPTN, CommonContractType -> SWPT, CommonContractType -> OTHR] any = contractType) then if leg1 -> fixedRate is absent and leg2 -> fixedRate is absent and leg1 -> spread is absent and leg2 -> spread is absent and strikePrice is absent and optionPremiumAmount is absent then price exists";

    public static class NoOp
    implements ASICTransactionReportDTCC_ASIC_BR_1047_02 {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, ASICTransactionReport aSICTransactionReport) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements ASICTransactionReportDTCC_ASIC_BR_1047_02 {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, ASICTransactionReport aSICTransactionReport) {
            ComparisonResult result = this.executeDataRule(aSICTransactionReport);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)ASICTransactionReportDTCC_ASIC_BR_1047_02.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"ASICTransactionReport", (RosettaPath)path, (String)ASICTransactionReportDTCC_ASIC_BR_1047_02.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)ASICTransactionReportDTCC_ASIC_BR_1047_02.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"ASICTransactionReport", (RosettaPath)path, (String)ASICTransactionReportDTCC_ASIC_BR_1047_02.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(ASICTransactionReport aSICTransactionReport) {
            try {
                if (ExpressionOperators.areEqual((Mapper)MapperC.of((MapperBuilder[])new MapperBuilder[]{MapperS.of((Object)((Object)ActionTypeEnum.NEWT)), MapperS.of((Object)((Object)ActionTypeEnum.MODI)), MapperS.of((Object)((Object)ActionTypeEnum.CORR)), MapperS.of((Object)((Object)ActionTypeEnum.REVI))}), (Mapper)MapperS.of((Object)aSICTransactionReport).map("getActionType", _aSICTransactionReport -> _aSICTransactionReport.getActionType()), (CardinalityOperator)CardinalityOperator.Any).and(ExpressionOperators.areEqual((Mapper)MapperS.of((Object)((Object)CommonAssetClass.INTR)), (Mapper)MapperS.of((Object)aSICTransactionReport).map("getAssetClass", _aSICTransactionReport -> _aSICTransactionReport.getAssetClass()), (CardinalityOperator)CardinalityOperator.All).and(ExpressionOperators.areEqual((Mapper)MapperC.of((MapperBuilder[])new MapperBuilder[]{MapperS.of((Object)((Object)CommonContractType.FRAS)), MapperS.of((Object)((Object)CommonContractType.FORW)), MapperS.of((Object)((Object)CommonContractType.OPTN)), MapperS.of((Object)((Object)CommonContractType.SWAP)), MapperS.of((Object)((Object)CommonContractType.SWPT)), MapperS.of((Object)((Object)CommonContractType.OTHR))}), (Mapper)MapperS.of((Object)aSICTransactionReport).map("getContractType", _aSICTransactionReport -> _aSICTransactionReport.getContractType()), (CardinalityOperator)CardinalityOperator.Any)).or(ExpressionOperators.areEqual((Mapper)MapperC.of((MapperBuilder[])new MapperBuilder[]{MapperS.of((Object)((Object)CommonAssetClass.EQUI)), MapperS.of((Object)((Object)CommonAssetClass.COMM))}), (Mapper)MapperS.of((Object)aSICTransactionReport).map("getAssetClass", _aSICTransactionReport -> _aSICTransactionReport.getAssetClass()), (CardinalityOperator)CardinalityOperator.Any).and(ExpressionOperators.areEqual((Mapper)MapperC.of((MapperBuilder[])new MapperBuilder[]{MapperS.of((Object)((Object)CommonContractType.FRAS)), MapperS.of((Object)((Object)CommonContractType.OPTN)), MapperS.of((Object)((Object)CommonContractType.SWPT)), MapperS.of((Object)((Object)CommonContractType.OTHR))}), (Mapper)MapperS.of((Object)aSICTransactionReport).map("getContractType", _aSICTransactionReport -> _aSICTransactionReport.getContractType()), (CardinalityOperator)CardinalityOperator.Any)))).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    if (ExpressionOperators.notExists((Mapper)MapperS.of((Object)aSICTransactionReport).map("getLeg1", _aSICTransactionReport -> _aSICTransactionReport.getLeg1()).map("getFixedRate", commonLeg -> commonLeg.getFixedRate())).and(ExpressionOperators.notExists((Mapper)MapperS.of((Object)aSICTransactionReport).map("getLeg2", _aSICTransactionReport -> _aSICTransactionReport.getLeg2()).map("getFixedRate", commonLeg -> commonLeg.getFixedRate()))).and(ExpressionOperators.notExists((Mapper)MapperS.of((Object)aSICTransactionReport).map("getLeg1", _aSICTransactionReport -> _aSICTransactionReport.getLeg1()).map("getSpread", commonLeg -> commonLeg.getSpread()))).and(ExpressionOperators.notExists((Mapper)MapperS.of((Object)aSICTransactionReport).map("getLeg2", _aSICTransactionReport -> _aSICTransactionReport.getLeg2()).map("getSpread", commonLeg -> commonLeg.getSpread()))).and(ExpressionOperators.notExists((Mapper)MapperS.of((Object)aSICTransactionReport).map("getStrikePrice", _aSICTransactionReport -> _aSICTransactionReport.getStrikePrice()))).and(ExpressionOperators.notExists((Mapper)MapperS.of((Object)aSICTransactionReport).map("getOptionPremiumAmount", _aSICTransactionReport -> _aSICTransactionReport.getOptionPremiumAmount()))).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                        return ExpressionOperators.exists((Mapper)MapperS.of((Object)aSICTransactionReport).map("getPrice", _aSICTransactionReport -> _aSICTransactionReport.getPrice()));
                    }
                    return ComparisonResult.successEmptyOperand((String)"");
                }
                return ComparisonResult.successEmptyOperand((String)"");
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

