/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.cftc.rewrite.trade.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.cftc.rewrite.trade.functions.IsAllowableActionForCFTC;
import drr.regulation.common.ReportableEvent;
import drr.regulation.common.SupervisoryBodyEnum;
import drr.regulation.common.TransactionReportInstruction;
import drr.standards.iosco.uti.functions.GetUniqueTransactionIdentifier;
import java.util.Collections;
import javax.inject.Inject;

@ImplementedBy(value=UniqueTransactionIdentifierRuleDefault.class)
public abstract class UniqueTransactionIdentifierRule
implements ReportFunction<TransactionReportInstruction, String> {
    @Inject
    protected GetUniqueTransactionIdentifier getUniqueTransactionIdentifier;
    @Inject
    protected IsAllowableActionForCFTC isAllowableActionForCFTC;

    public String evaluate(TransactionReportInstruction input) {
        String output = this.doEvaluate(input);
        return output;
    }

    protected abstract String doEvaluate(TransactionReportInstruction var1);

    public static class UniqueTransactionIdentifierRuleDefault
    extends UniqueTransactionIdentifierRule {
        @Override
        protected String doEvaluate(TransactionReportInstruction input) {
            String output = null;
            return this.assignOutput(output, input);
        }

        protected String assignOutput(String output, TransactionReportInstruction input) {
            MapperS thenArg = MapperS.of((Object)input).filterSingleNullSafe(item -> this.isAllowableActionForCFTC.evaluate((ReportableEvent)item.get()));
            output = (String)thenArg.mapSingleToItem(item -> {
                SupervisoryBodyEnum supervisoryBodyEnum = SupervisoryBodyEnum.CFTC;
                return MapperS.of((Object)this.getUniqueTransactionIdentifier.evaluate((ReportableEvent)item.get(), supervisoryBodyEnum == null ? Collections.emptyList() : Collections.singletonList(supervisoryBodyEnum)));
            }).get();
            return output;
        }
    }
}

