/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.common;

import com.rosetta.model.lib.annotations.RosettaEnum;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

@RosettaEnum(value="CommonContractType")
public enum CommonContractType {
    CFDS("CFDS", null),
    FRAS("FRAS", null),
    FUTR("FUTR", null),
    FORW("FORW", null),
    OPTN("OPTN", null),
    SPDB("SPDB", null),
    SWAP("SWAP", null),
    SWPT("SWPT", null),
    OTHR("OTHR", null);

    private static Map<String, CommonContractType> values;
    private final String rosettaName;
    private final String displayName;

    private CommonContractType(String rosettaName, String displayName) {
        this.rosettaName = rosettaName;
        this.displayName = displayName;
    }

    public static CommonContractType fromDisplayName(String name) {
        CommonContractType value = values.get(name);
        if (value == null) {
            throw new IllegalArgumentException("No enum constant with display name \"" + name + "\".");
        }
        return value;
    }

    public String toString() {
        return this.toDisplayString();
    }

    public String toDisplayString() {
        return this.displayName != null ? this.displayName : this.rosettaName;
    }

    static {
        ConcurrentHashMap<String, CommonContractType> map = new ConcurrentHashMap<String, CommonContractType>();
        for (CommonContractType instance : CommonContractType.values()) {
            map.put(instance.toDisplayString(), instance);
        }
        values = Collections.unmodifiableMap(map);
    }
}

