/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.common.functions;

import com.rosetta.model.lib.records.Date;
import drr.base.trade.price.PricePeriod;
import drr.regulation.common.functions.Create_ContinuousPriceSchedule;
import java.time.LocalDate;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class Create_ContinuousPriceScheduleImpl
extends Create_ContinuousPriceSchedule {
    @Override
    protected List<PricePeriod.PricePeriodBuilder> doEvaluate(List<? extends PricePeriod> pricePeriods, Date endDate) {
        if (pricePeriods == null || endDate == null) {
            return null;
        }
        LocalDate localEndDate = endDate.toLocalDate();
        List sortedPeriods = pricePeriods.stream().sorted(Comparator.comparing(PricePeriod::getEffectiveDate)).collect(Collectors.toList());
        return IntStream.range(0, sortedPeriods.size()).mapToObj(i -> {
            PricePeriod pricePeriod = (PricePeriod)sortedPeriods.get(i);
            PricePeriod.PricePeriodBuilder pricePeriodBuilder = (PricePeriod.PricePeriodBuilder)this.toBuilder(pricePeriod);
            LocalDate computedEndDate = i == sortedPeriods.size() - 1 ? localEndDate : ((PricePeriod)sortedPeriods.get(i + 1)).getEffectiveDate().toLocalDate().minusDays(1L);
            if (pricePeriod.getEndDate() == null || pricePeriod.getEndDate().toLocalDate().isBefore(localEndDate)) {
                pricePeriodBuilder.setEndDate(Date.of((LocalDate)computedEndDate));
            }
            return pricePeriodBuilder;
        }).collect(Collectors.toList());
    }
}

