/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.common.functions;

import cdm.base.staticdata.asset.common.ProductIdTypeEnum;
import cdm.base.staticdata.asset.common.ProductIdentifier;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperBuilder;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=ExtractProductIdentifierBySourceDefault.class)
public abstract class ExtractProductIdentifierBySource
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;

    public ProductIdentifier evaluate(List<? extends ProductIdentifier> productIdentifiers) {
        ProductIdentifier productIdentifier;
        ProductIdentifier.ProductIdentifierBuilder productIdentifierBuilder = this.doEvaluate(productIdentifiers);
        if (productIdentifierBuilder == null) {
            productIdentifier = null;
        } else {
            productIdentifier = productIdentifierBuilder.build();
            this.objectValidator.validate(ProductIdentifier.class, (RosettaModelObject)productIdentifier);
        }
        return productIdentifier;
    }

    protected abstract ProductIdentifier.ProductIdentifierBuilder doEvaluate(List<? extends ProductIdentifier> var1);

    protected abstract MapperC<ProductIdTypeEnum> orderedSources(List<? extends ProductIdentifier> var1);

    public static class ExtractProductIdentifierBySourceDefault
    extends ExtractProductIdentifierBySource {
        @Override
        protected ProductIdentifier.ProductIdentifierBuilder doEvaluate(List<? extends ProductIdentifier> productIdentifiers) {
            if (productIdentifiers == null) {
                productIdentifiers = Collections.emptyList();
            }
            ProductIdentifier.ProductIdentifierBuilder productIdentifier = ProductIdentifier.builder();
            return this.assignOutput(productIdentifier, productIdentifiers);
        }

        protected ProductIdentifier.ProductIdentifierBuilder assignOutput(ProductIdentifier.ProductIdentifierBuilder productIdentifier, List<? extends ProductIdentifier> productIdentifiers) {
            MapperC thenArg = this.orderedSources(productIdentifiers).mapItem(src -> {
                MapperC _thenArg = MapperC.of((List)productIdentifiers).filterItemNullSafe(item -> ExpressionOperators.areEqual((Mapper)item.map("getSource", _productIdentifier -> _productIdentifier.getSource()), (Mapper)src, (CardinalityOperator)CardinalityOperator.All).get());
                return _thenArg.first();
            });
            productIdentifier = (ProductIdentifier.ProductIdentifierBuilder)this.toBuilder((RosettaModelObject)MapperS.of((Object)((ProductIdentifier)thenArg.first().getOrDefault((Object)((ProductIdentifier)MapperC.of(productIdentifiers).first().get())))).get());
            return Optional.ofNullable(productIdentifier).map(o -> o.prune()).orElse(null);
        }

        @Override
        protected MapperC<ProductIdTypeEnum> orderedSources(List<? extends ProductIdentifier> productIdentifiers) {
            return MapperC.of((MapperBuilder[])new MapperBuilder[]{MapperS.of((Object)ProductIdTypeEnum.REDID), MapperS.of((Object)ProductIdTypeEnum.CUSIP), MapperS.of((Object)ProductIdTypeEnum.SEDOL), MapperS.of((Object)ProductIdTypeEnum.RIC), MapperS.of((Object)ProductIdTypeEnum.SICOVAM), MapperS.of((Object)ProductIdTypeEnum.FIGI), MapperS.of((Object)ProductIdTypeEnum.BBGTICKER), MapperS.of((Object)ProductIdTypeEnum.NAME)});
        }
    }
}

