/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.common.functions;

import cdm.product.asset.InterestRatePayout;
import cdm.product.template.Product;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.records.Date;
import drr.base.trade.functions.ProductForEvent;
import drr.regulation.common.ReportableEvent;
import drr.regulation.common.functions.IsFRA;
import drr.regulation.common.functions.ProductOrUnderlierProduct;
import javax.inject.Inject;

@ImplementedBy(value=GetNextFloatingReferenceResetDateDefault.class)
public abstract class GetNextFloatingReferenceResetDate
implements RosettaFunction {
    @Inject
    protected IsFRA isFRA;
    @Inject
    protected ProductForEvent productForEvent;
    @Inject
    protected ProductOrUnderlierProduct productOrUnderlierProduct;

    public Date evaluate(ReportableEvent reportableEvent, InterestRatePayout interestRateLeg) {
        Date nextFloatingReferenceResetDate = this.doEvaluate(reportableEvent, interestRateLeg);
        return nextFloatingReferenceResetDate;
    }

    protected abstract Date doEvaluate(ReportableEvent var1, InterestRatePayout var2);

    public static class GetNextFloatingReferenceResetDateDefault
    extends GetNextFloatingReferenceResetDate {
        @Override
        protected Date doEvaluate(ReportableEvent reportableEvent, InterestRatePayout interestRateLeg) {
            Date nextFloatingReferenceResetDate = null;
            return this.assignOutput(nextFloatingReferenceResetDate, reportableEvent, interestRateLeg);
        }

        protected Date assignOutput(Date nextFloatingReferenceResetDate, ReportableEvent reportableEvent, InterestRatePayout interestRateLeg) {
            MapperS thenArg0 = MapperS.of((Object)this.productForEvent.evaluate(reportableEvent));
            MapperS thenArg1 = thenArg0.filterSingleNullSafe(item -> ExpressionOperators.areEqual((Mapper)MapperS.of((Object)this.isFRA.evaluate((Product)item.get())), (Mapper)MapperS.of((Object)false), (CardinalityOperator)CardinalityOperator.All).get());
            MapperS thenArg2 = thenArg1.mapSingleToItem(item -> MapperS.of((Object)this.productOrUnderlierProduct.evaluate((Product)item.get())));
            MapperS thenArg3 = thenArg2.mapSingleToItem(item -> MapperS.of((Object)interestRateLeg));
            nextFloatingReferenceResetDate = (Date)thenArg3.mapSingleToItem(item -> {
                if (ExpressionOperators.exists((Mapper)item.map("getRateSpecification", interestRatePayout -> interestRatePayout.getRateSpecification()).map("getFloatingRate", rateSpecification -> rateSpecification.getFloatingRate())).and(ExpressionOperators.exists((Mapper)item.map("getResetDates", interestRatePayout -> interestRatePayout.getResetDates()))).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return item.map("getResetDates", interestRatePayout -> interestRatePayout.getResetDates()).map("getFixingDates", resetDates -> resetDates.getFixingDates()).map("getAdjustedDate", relativeDateOffset -> relativeDateOffset.getAdjustedDate());
                }
                if (ExpressionOperators.exists((Mapper)item.map("getRateSpecification", interestRatePayout -> interestRatePayout.getRateSpecification()).map("getInflationRate", rateSpecification -> rateSpecification.getInflationRate())).and(ExpressionOperators.exists((Mapper)item.map("getResetDates", interestRatePayout -> interestRatePayout.getResetDates()))).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return item.map("getResetDates", interestRatePayout -> interestRatePayout.getResetDates()).map("getFixingDates", resetDates -> resetDates.getFixingDates()).map("getAdjustedDate", relativeDateOffset -> relativeDateOffset.getAdjustedDate());
                }
                return MapperS.ofNull();
            }).get();
            return nextFloatingReferenceResetDate;
        }
    }
}

