/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.common.functions;

import cdm.base.staticdata.asset.common.ProductIdTypeEnum;
import cdm.base.staticdata.asset.common.ProductIdentifier;
import cdm.product.template.Product;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperListOfLists;
import com.rosetta.model.lib.mapper.MapperS;
import drr.base.qualification.product.functions.IsProductETD;
import drr.base.qualification.product.functions.IsSingleCommodityPayoutProduct;
import drr.base.trade.functions.EconomicTermsForProduct;
import drr.base.trade.underlier.functions.FilterProductIdentifier;
import drr.base.trade.underlier.functions.UnderlierForProduct;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;

@ImplementedBy(value=GetUnderlierProductIdentifierDefault.class)
public abstract class GetUnderlierProductIdentifier
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected EconomicTermsForProduct economicTermsForProduct;
    @Inject
    protected FilterProductIdentifier filterProductIdentifier;
    @Inject
    protected IsProductETD isProductETD;
    @Inject
    protected IsSingleCommodityPayoutProduct isSingleCommodityPayoutProduct;
    @Inject
    protected UnderlierForProduct underlierForProduct;

    public List<? extends ProductIdentifier> evaluate(Product product) {
        List productId;
        List<ProductIdentifier.ProductIdentifierBuilder> productIdBuilder = this.doEvaluate(product);
        if (productIdBuilder == null) {
            productId = null;
        } else {
            productId = productIdBuilder.stream().map(ProductIdentifier::build).collect(Collectors.toList());
            this.objectValidator.validate(ProductIdentifier.class, productId);
        }
        return productId;
    }

    protected abstract List<ProductIdentifier.ProductIdentifierBuilder> doEvaluate(Product var1);

    public static class GetUnderlierProductIdentifierDefault
    extends GetUnderlierProductIdentifier {
        @Override
        protected List<ProductIdentifier.ProductIdentifierBuilder> doEvaluate(Product product) {
            ArrayList<ProductIdentifier.ProductIdentifierBuilder> productId = new ArrayList<ProductIdentifier.ProductIdentifierBuilder>();
            return this.assignOutput(productId, product);
        }

        protected List<ProductIdentifier.ProductIdentifierBuilder> assignOutput(List<ProductIdentifier.ProductIdentifierBuilder> productId, Product product) {
            MapperC thenArg0 = ExpressionOperators.exists((Mapper)MapperS.of((Object)this.economicTermsForProduct.evaluate(product)).map("getPayout", economicTerms -> economicTerms.getPayout()).map("getCreditDefaultPayout", payout -> payout.getCreditDefaultPayout()).map("getGeneralTerms", creditDefaultPayout -> creditDefaultPayout.getGeneralTerms()).map("getReferenceInformation", generalTerms -> generalTerms.getReferenceInformation()).mapC("getReferenceObligation", referenceInformation -> referenceInformation.getReferenceObligation())).getOrDefault(Boolean.valueOf(false)) != false ? MapperS.of((Object)this.economicTermsForProduct.evaluate(product)).map("getPayout", economicTerms -> economicTerms.getPayout()).map("getCreditDefaultPayout", payout -> payout.getCreditDefaultPayout()).map("getGeneralTerms", creditDefaultPayout -> creditDefaultPayout.getGeneralTerms()).map("getReferenceInformation", generalTerms -> generalTerms.getReferenceInformation()).mapC("getReferenceObligation", referenceInformation -> referenceInformation.getReferenceObligation()) : (ExpressionOperators.exists((Mapper)MapperS.of((Object)this.economicTermsForProduct.evaluate(this.underlierForProduct.evaluate(product))).map("getPayout", economicTerms -> economicTerms.getPayout()).map("getCreditDefaultPayout", payout -> payout.getCreditDefaultPayout()).map("getGeneralTerms", creditDefaultPayout -> creditDefaultPayout.getGeneralTerms()).map("getReferenceInformation", generalTerms -> generalTerms.getReferenceInformation()).mapC("getReferenceObligation", referenceInformation -> referenceInformation.getReferenceObligation())).getOrDefault(Boolean.valueOf(false)) != false ? MapperS.of((Object)this.economicTermsForProduct.evaluate(this.underlierForProduct.evaluate(product))).map("getPayout", economicTerms -> economicTerms.getPayout()).map("getCreditDefaultPayout", payout -> payout.getCreditDefaultPayout()).map("getGeneralTerms", creditDefaultPayout -> creditDefaultPayout.getGeneralTerms()).map("getReferenceInformation", generalTerms -> generalTerms.getReferenceInformation()).mapC("getReferenceObligation", referenceInformation -> referenceInformation.getReferenceObligation()) : MapperC.ofNull());
            MapperListOfLists thenArg1 = thenArg0.mapItemToList(item -> {
                if (ExpressionOperators.exists((Mapper)item.map("getSecurity", referenceObligation -> referenceObligation.getSecurity())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return item.map("getSecurity", referenceObligation -> referenceObligation.getSecurity()).mapC("getProductIdentifier", security -> security.getProductIdentifier());
                }
                if (ExpressionOperators.exists((Mapper)item.map("getLoan", referenceObligation -> referenceObligation.getLoan())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return item.map("getLoan", referenceObligation -> referenceObligation.getLoan()).mapC("getProductIdentifier", loan -> loan.getProductIdentifier());
                }
                return MapperC.ofNull();
            });
            productId.addAll(this.toBuilder(thenArg1.mapListToItem(item -> MapperS.of((Object)this.filterProductIdentifier.evaluate(item.map("Type coercion", referenceWithMetaProductIdentifier -> referenceWithMetaProductIdentifier.getValue()).getMulti(), ProductIdTypeEnum.ISIN))).getMulti()));
            MapperC thenArg2 = ExpressionOperators.exists((Mapper)MapperS.of((Object)this.underlierForProduct.evaluate(product))).getOrDefault(Boolean.valueOf(false)) != false ? MapperC.of(Collections.singletonList(this.underlierForProduct.evaluate(product))) : (ExpressionOperators.exists((Mapper)MapperS.of((Object)this.economicTermsForProduct.evaluate(product)).map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getPerformancePayout", payout -> payout.getPerformancePayout()).map("getUnderlier", performancePayout -> performancePayout.getUnderlier())).getOrDefault(Boolean.valueOf(false)) != false ? MapperS.of((Object)this.economicTermsForProduct.evaluate(product)).map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getPerformancePayout", payout -> payout.getPerformancePayout()).map("getUnderlier", performancePayout -> performancePayout.getUnderlier()) : MapperC.ofNull());
            MapperListOfLists thenArg3 = thenArg2.mapItemToList(item -> {
                if (ExpressionOperators.exists((Mapper)item.map("getSecurity", _product -> _product.getSecurity())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return item.map("getSecurity", _product -> _product.getSecurity()).mapC("getProductIdentifier", security -> security.getProductIdentifier());
                }
                if (ExpressionOperators.exists((Mapper)item.map("getLoan", _product -> _product.getLoan())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return item.map("getLoan", _product -> _product.getLoan()).mapC("getProductIdentifier", loan -> loan.getProductIdentifier());
                }
                if (ExpressionOperators.exists((Mapper)item.map("getIndex", _product -> _product.getIndex())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return item.map("getIndex", _product -> _product.getIndex()).mapC("getProductIdentifier", index -> index.getProductIdentifier());
                }
                if (ExpressionOperators.exists((Mapper)item.map("getCommodity", _product -> _product.getCommodity())).and(ComparisonResult.of((Mapper)MapperS.of((Object)this.isProductETD.evaluate(product)))).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return item.map("getCommodity", _product -> _product.getCommodity()).map("Type coercion", referenceWithMetaCommodity -> referenceWithMetaCommodity == null ? null : referenceWithMetaCommodity.getValue()).mapC("getProductIdentifier", commodity -> commodity.getProductIdentifier());
                }
                return MapperC.ofNull();
            });
            productId.addAll(this.toBuilder(thenArg3.mapListToItem(item -> MapperS.of((Object)this.filterProductIdentifier.evaluate(item.map("Type coercion", referenceWithMetaProductIdentifier -> referenceWithMetaProductIdentifier.getValue()).getMulti(), ProductIdTypeEnum.ISIN))).getMulti()));
            MapperC thenArg4 = ComparisonResult.of((Mapper)MapperS.of((Object)this.isProductETD.evaluate(product))).and(ExpressionOperators.exists((Mapper)MapperS.of((Object)this.underlierForProduct.evaluate(product)).map("getCommodity", _product -> _product.getCommodity()).map("Type coercion", referenceWithMetaCommodity0 -> referenceWithMetaCommodity0 == null ? null : referenceWithMetaCommodity0.getValue()).mapC("getProductIdentifier", commodity -> commodity.getProductIdentifier()))).getOrDefault(Boolean.valueOf(false)) != false ? MapperS.of((Object)this.underlierForProduct.evaluate(product)).map("getCommodity", _product -> _product.getCommodity()).map("Type coercion", referenceWithMetaCommodity1 -> referenceWithMetaCommodity1 == null ? null : referenceWithMetaCommodity1.getValue()).mapC("getProductIdentifier", commodity -> commodity.getProductIdentifier()).map("Type coercion", referenceWithMetaProductIdentifier -> referenceWithMetaProductIdentifier.getValue()) : (ComparisonResult.of((Mapper)MapperS.of((Object)this.isProductETD.evaluate(product))).and(ExpressionOperators.exists((Mapper)MapperS.of((Object)this.economicTermsForProduct.evaluate(product)).map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getCommodityPayout", payout -> payout.getCommodityPayout()).map("getUnderlier", commodityPayout -> commodityPayout.getUnderlier()).map("getCommodity", _product -> _product.getCommodity()).map("Type coercion", referenceWithMetaCommodity -> referenceWithMetaCommodity.getValue()).mapC("getProductIdentifier", commodity -> commodity.getProductIdentifier()))).and(ExpressionOperators.areEqual((Mapper)MapperS.of((Object)this.isSingleCommodityPayoutProduct.evaluate(product)), (Mapper)MapperS.of((Object)false), (CardinalityOperator)CardinalityOperator.All)).getOrDefault(Boolean.valueOf(false)) != false ? MapperS.of((Object)this.economicTermsForProduct.evaluate(product)).map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getCommodityPayout", payout -> payout.getCommodityPayout()).map("getUnderlier", commodityPayout -> commodityPayout.getUnderlier()).map("getCommodity", _product -> _product.getCommodity()).map("Type coercion", referenceWithMetaCommodity -> referenceWithMetaCommodity.getValue()).mapC("getProductIdentifier", commodity -> commodity.getProductIdentifier()).map("Type coercion", referenceWithMetaProductIdentifier -> referenceWithMetaProductIdentifier.getValue()) : (ExpressionOperators.exists((Mapper)MapperS.of((Object)this.underlierForProduct.evaluate(product)).map("getContractualProduct", _product -> _product.getContractualProduct()).mapC("getProductIdentifier", contractualProduct -> contractualProduct.getProductIdentifier())).getOrDefault(Boolean.valueOf(false)) != false ? MapperS.of((Object)this.underlierForProduct.evaluate(product)).map("getContractualProduct", _product -> _product.getContractualProduct()).mapC("getProductIdentifier", contractualProduct -> contractualProduct.getProductIdentifier()).map("Type coercion", referenceWithMetaProductIdentifier -> referenceWithMetaProductIdentifier.getValue()) : (ExpressionOperators.exists((Mapper)MapperS.of((Object)this.economicTermsForProduct.evaluate(product)).map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getInterestRatePayout", payout -> payout.getInterestRatePayout()).map("getBondReference", interestRatePayout -> interestRatePayout.getBondReference()).map("getBond", bondReference -> bondReference.getBond())).getOrDefault(Boolean.valueOf(false)) != false ? MapperS.of((Object)this.economicTermsForProduct.evaluate(product)).map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getInterestRatePayout", payout -> payout.getInterestRatePayout()).map("getBondReference", interestRatePayout -> interestRatePayout.getBondReference()).map("getBond", bondReference -> bondReference.getBond()) : (ExpressionOperators.exists((Mapper)MapperS.of((Object)this.economicTermsForProduct.evaluate(product)).map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getForwardPayout", payout -> payout.getForwardPayout()).map("getUnderlier", forwardPayout -> forwardPayout.getUnderlier()).map("getCommodity", _product -> _product.getCommodity())).getOrDefault(Boolean.valueOf(false)) != false ? MapperS.of((Object)this.economicTermsForProduct.evaluate(product)).map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getForwardPayout", payout -> payout.getForwardPayout()).map("getUnderlier", forwardPayout -> forwardPayout.getUnderlier()).map("getCommodity", _product -> _product.getCommodity()).map("Type coercion", referenceWithMetaCommodity -> referenceWithMetaCommodity.getValue()).mapC("getProductIdentifier", commodity -> commodity.getProductIdentifier()).map("Type coercion", referenceWithMetaProductIdentifier -> referenceWithMetaProductIdentifier.getValue()) : (ComparisonResult.of((Mapper)MapperS.of((Object)this.isProductETD.evaluate(product))).and(ExpressionOperators.exists((Mapper)MapperS.of((Object)this.economicTermsForProduct.evaluate(product)).map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getCommodityPayout", payout -> payout.getCommodityPayout()).map("getUnderlier", commodityPayout -> commodityPayout.getUnderlier()).map("getIndex", _product -> _product.getIndex()))).and(ExpressionOperators.areEqual((Mapper)MapperS.of((Object)this.isSingleCommodityPayoutProduct.evaluate(product)), (Mapper)MapperS.of((Object)false), (CardinalityOperator)CardinalityOperator.All)).getOrDefault(Boolean.valueOf(false)) != false ? MapperS.of((Object)this.economicTermsForProduct.evaluate(product)).map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getCommodityPayout", payout -> payout.getCommodityPayout()).map("getUnderlier", commodityPayout -> commodityPayout.getUnderlier()).map("getIndex", _product -> _product.getIndex()).mapC("getProductIdentifier", index -> index.getProductIdentifier()).map("Type coercion", referenceWithMetaProductIdentifier -> referenceWithMetaProductIdentifier.getValue()) : (ComparisonResult.of((Mapper)MapperS.of((Object)this.isProductETD.evaluate(product))).and(ExpressionOperators.exists((Mapper)MapperS.of((Object)this.underlierForProduct.evaluate(this.underlierForProduct.evaluate(product))).map("getIndex", _product -> _product.getIndex()))).getOrDefault(Boolean.valueOf(false)) != false ? MapperS.of((Object)this.underlierForProduct.evaluate(this.underlierForProduct.evaluate(product))).map("getIndex", _product -> _product.getIndex()).mapC("getProductIdentifier", index -> index.getProductIdentifier()).map("Type coercion", referenceWithMetaProductIdentifier -> referenceWithMetaProductIdentifier.getValue()) : MapperC.ofNull()))))));
            productId.addAll(this.toBuilder(thenArg4.mapItem(item -> MapperS.of((Object)this.filterProductIdentifier.evaluate(item.getMulti(), ProductIdTypeEnum.ISIN))).getMulti()));
            return Optional.ofNullable(productId).map(o -> o.stream().map(i -> i.prune()).collect(Collectors.toList())).orElse(null);
        }
    }
}

