/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.common.functions;

import cdm.product.asset.CommodityPayout;
import cdm.product.common.settlement.SettlementTerms;
import cdm.product.template.EconomicTerms;
import cdm.product.template.FixedPricePayout;
import cdm.product.template.ForwardPayout;
import cdm.product.template.OptionPayout;
import cdm.product.template.PerformancePayout;
import cdm.product.template.Product;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import drr.base.qualification.product.functions.IsCommodityFixedPriceForward;
import drr.base.qualification.product.functions.IsCommodityFloatingPriceForward;
import drr.base.qualification.product.functions.IsCommoditySwapFixedFloat;
import drr.base.qualification.product.functions.IsCommoditySwapFloatFloat;
import drr.base.qualification.product.functions.IsFXSwap;
import drr.base.qualification.product.functions.IsSingleCommodityPayoutProduct;
import drr.base.trade.functions.EconomicTermsForProduct;
import drr.base.trade.quantity.functions.FixedPriceLeg1;
import drr.regulation.common.functions.CommodityLeg1;
import drr.regulation.common.functions.FXFarLeg;
import drr.regulation.common.functions.InterestRateLeg1;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=SettlementTermsLeg1Default.class)
public abstract class SettlementTermsLeg1
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected CommodityLeg1 commodityLeg1;
    @Inject
    protected EconomicTermsForProduct economicTermsForProduct;
    @Inject
    protected FXFarLeg fXFarLeg;
    @Inject
    protected FixedPriceLeg1 fixedPriceLeg1;
    @Inject
    protected InterestRateLeg1 interestRateLeg1;
    @Inject
    protected IsCommodityFixedPriceForward isCommodityFixedPriceForward;
    @Inject
    protected IsCommodityFloatingPriceForward isCommodityFloatingPriceForward;
    @Inject
    protected IsCommoditySwapFixedFloat isCommoditySwapFixedFloat;
    @Inject
    protected IsCommoditySwapFloatFloat isCommoditySwapFloatFloat;
    @Inject
    protected IsFXSwap isFXSwap;
    @Inject
    protected IsSingleCommodityPayoutProduct isSingleCommodityPayoutProduct;

    public SettlementTerms evaluate(Product product) {
        SettlementTerms settlementTerms;
        SettlementTerms.SettlementTermsBuilder settlementTermsBuilder = this.doEvaluate(product);
        if (settlementTermsBuilder == null) {
            settlementTerms = null;
        } else {
            settlementTerms = settlementTermsBuilder.build();
            this.objectValidator.validate(SettlementTerms.class, (RosettaModelObject)settlementTerms);
        }
        return settlementTerms;
    }

    protected abstract SettlementTerms.SettlementTermsBuilder doEvaluate(Product var1);

    protected abstract MapperS<? extends EconomicTerms> economicTerms(Product var1);

    public static class SettlementTermsLeg1Default
    extends SettlementTermsLeg1 {
        @Override
        protected SettlementTerms.SettlementTermsBuilder doEvaluate(Product product) {
            SettlementTerms.SettlementTermsBuilder settlementTerms = SettlementTerms.builder();
            return this.assignOutput(settlementTerms, product);
        }

        protected SettlementTerms.SettlementTermsBuilder assignOutput(SettlementTerms.SettlementTermsBuilder settlementTerms, Product product) {
            Boolean boolean3;
            Boolean boolean2;
            Boolean boolean1;
            Boolean boolean0;
            settlementTerms = ExpressionOperators.exists((Mapper)MapperS.of((Object)this.interestRateLeg1.evaluate(product)).map("getSettlementTerms", interestRatePayout -> interestRatePayout.getSettlementTerms())).getOrDefault(Boolean.valueOf(false)) != false ? (SettlementTerms.SettlementTermsBuilder)this.toBuilder((RosettaModelObject)MapperS.of((Object)this.interestRateLeg1.evaluate(product)).map("getSettlementTerms", interestRatePayout -> interestRatePayout.getSettlementTerms()).get()) : (ExpressionOperators.exists((Mapper)this.economicTerms(product).map("getPayout", _economicTerms -> _economicTerms.getPayout()).map("getCreditDefaultPayout", payout -> payout.getCreditDefaultPayout()).map("getSettlementTerms", creditDefaultPayout -> creditDefaultPayout.getSettlementTerms())).getOrDefault(Boolean.valueOf(false)) != false ? (SettlementTerms.SettlementTermsBuilder)this.toBuilder((RosettaModelObject)this.economicTerms(product).map("getPayout", _economicTerms -> _economicTerms.getPayout()).map("getCreditDefaultPayout", payout -> payout.getCreditDefaultPayout()).map("getSettlementTerms", creditDefaultPayout -> creditDefaultPayout.getSettlementTerms()).get()) : (ExpressionOperators.exists((Mapper)this.economicTerms(product).map("getPayout", _economicTerms -> _economicTerms.getPayout()).mapC("getPerformancePayout", payout -> payout.getPerformancePayout()).map("getSettlementTerms", performancePayout -> performancePayout.getSettlementTerms())).getOrDefault(Boolean.valueOf(false)) != false ? (SettlementTerms.SettlementTermsBuilder)this.toBuilder((RosettaModelObject)MapperS.of((Object)((PerformancePayout)this.economicTerms(product).map("getPayout", _economicTerms -> _economicTerms.getPayout()).mapC("getPerformancePayout", payout -> payout.getPerformancePayout()).get())).map("getSettlementTerms", performancePayout -> performancePayout.getSettlementTerms()).get()) : ((boolean0 = this.isFXSwap.evaluate(product)) != null && boolean0 != false ? (SettlementTerms.SettlementTermsBuilder)this.toBuilder((RosettaModelObject)MapperS.of((Object)this.fXFarLeg.evaluate(product)).map("getSettlementTerms", forwardPayout -> forwardPayout.getSettlementTerms()).get()) : ((boolean1 = this.isCommoditySwapFloatFloat.evaluate(product)) != null && boolean1 != false ? (SettlementTerms.SettlementTermsBuilder)this.toBuilder((RosettaModelObject)MapperS.of((Object)this.commodityLeg1.evaluate(product)).map("getSettlementTerms", commodityPayout -> commodityPayout.getSettlementTerms()).get()) : ((boolean2 = this.isSingleCommodityPayoutProduct.evaluate(product)) != null && boolean2 != false ? (SettlementTerms.SettlementTermsBuilder)this.toBuilder((RosettaModelObject)MapperS.of((Object)((CommodityPayout)MapperS.of((Object)this.economicTermsForProduct.evaluate(product)).map("getPayout", _economicTerms -> _economicTerms.getPayout()).mapC("getCommodityPayout", payout -> payout.getCommodityPayout()).get())).map("getSettlementTerms", commodityPayout -> commodityPayout.getSettlementTerms()).get()) : ((boolean3 = this.isCommoditySwapFixedFloat.evaluate(product)) != null && boolean3 != false ? (SettlementTerms.SettlementTermsBuilder)this.toBuilder((RosettaModelObject)MapperS.of((Object)this.fixedPriceLeg1.evaluate(product)).map("getSettlementTerms", fixedPricePayout -> fixedPricePayout.getSettlementTerms()).get()) : (ExpressionOperators.areEqual((Mapper)MapperS.of((Object)this.isCommodityFixedPriceForward.evaluate(product)), (Mapper)MapperS.of((Object)true), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)) != false ? (SettlementTerms.SettlementTermsBuilder)this.toBuilder((RosettaModelObject)MapperS.of((Object)((FixedPricePayout)MapperS.of((Object)this.economicTermsForProduct.evaluate(product)).map("getPayout", _economicTerms -> _economicTerms.getPayout()).mapC("getFixedPricePayout", payout -> payout.getFixedPricePayout()).get())).map("getSettlementTerms", fixedPricePayout -> fixedPricePayout.getSettlementTerms()).get()) : (ExpressionOperators.areEqual((Mapper)MapperS.of((Object)this.isCommodityFloatingPriceForward.evaluate(product)), (Mapper)MapperS.of((Object)true), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)) != false ? (SettlementTerms.SettlementTermsBuilder)this.toBuilder((RosettaModelObject)MapperS.of((Object)((CommodityPayout)MapperS.of((Object)this.economicTermsForProduct.evaluate(product)).map("getPayout", _economicTerms -> _economicTerms.getPayout()).mapC("getCommodityPayout", payout -> payout.getCommodityPayout()).get())).map("getSettlementTerms", commodityPayout -> commodityPayout.getSettlementTerms()).get()) : (ExpressionOperators.exists((Mapper)this.economicTerms(product).map("getPayout", _economicTerms -> _economicTerms.getPayout()).mapC("getOptionPayout", payout -> payout.getOptionPayout()).map("getSettlementTerms", optionPayout -> optionPayout.getSettlementTerms())).getOrDefault(Boolean.valueOf(false)) != false ? (SettlementTerms.SettlementTermsBuilder)this.toBuilder((RosettaModelObject)MapperS.of((Object)((OptionPayout)this.economicTerms(product).map("getPayout", _economicTerms -> _economicTerms.getPayout()).mapC("getOptionPayout", payout -> payout.getOptionPayout()).get())).map("getSettlementTerms", optionPayout -> optionPayout.getSettlementTerms()).get()) : (ExpressionOperators.exists((Mapper)MapperS.of((Object)((ForwardPayout)this.economicTerms(product).map("getPayout", _economicTerms -> _economicTerms.getPayout()).mapC("getForwardPayout", payout -> payout.getForwardPayout()).get())).map("getSettlementTerms", forwardPayout -> forwardPayout.getSettlementTerms())).getOrDefault(Boolean.valueOf(false)) != false ? (SettlementTerms.SettlementTermsBuilder)this.toBuilder((RosettaModelObject)MapperS.of((Object)((ForwardPayout)this.economicTerms(product).map("getPayout", _economicTerms -> _economicTerms.getPayout()).mapC("getForwardPayout", payout -> payout.getForwardPayout()).get())).map("getSettlementTerms", forwardPayout -> forwardPayout.getSettlementTerms()).get()) : null))))))))));
            return Optional.ofNullable(settlementTerms).map(o -> o.prune()).orElse(null);
        }

        @Override
        protected MapperS<? extends EconomicTerms> economicTerms(Product product) {
            return MapperS.of((Object)this.economicTermsForProduct.evaluate(product));
        }
    }
}

