/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.common.functions;

import cdm.product.asset.InterestRatePayout;
import cdm.product.common.settlement.SettlementTerms;
import cdm.product.template.ForwardPayout;
import cdm.product.template.PerformancePayout;
import cdm.product.template.Product;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import drr.base.qualification.product.functions.IsCommodityForward;
import drr.base.qualification.product.functions.IsCommoditySwap;
import drr.base.qualification.product.functions.IsEquitySwapProduct;
import drr.base.qualification.product.functions.IsFXSwap;
import drr.base.trade.functions.EconomicTermsForProduct;
import drr.regulation.common.functions.CommodityLeg2;
import drr.regulation.common.functions.FXNearLeg;
import drr.regulation.common.functions.InterestRateLeg2;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=SettlementTermsLeg2Default.class)
public abstract class SettlementTermsLeg2
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected CommodityLeg2 commodityLeg2;
    @Inject
    protected EconomicTermsForProduct economicTermsForProduct;
    @Inject
    protected FXNearLeg fXNearLeg;
    @Inject
    protected InterestRateLeg2 interestRateLeg2;
    @Inject
    protected IsCommodityForward isCommodityForward;
    @Inject
    protected IsCommoditySwap isCommoditySwap;
    @Inject
    protected IsEquitySwapProduct isEquitySwapProduct;
    @Inject
    protected IsFXSwap isFXSwap;

    public SettlementTerms evaluate(Product product) {
        SettlementTerms settlementTerms;
        SettlementTerms.SettlementTermsBuilder settlementTermsBuilder = this.doEvaluate(product);
        if (settlementTermsBuilder == null) {
            settlementTerms = null;
        } else {
            settlementTerms = settlementTermsBuilder.build();
            this.objectValidator.validate(SettlementTerms.class, (RosettaModelObject)settlementTerms);
        }
        return settlementTerms;
    }

    protected abstract SettlementTerms.SettlementTermsBuilder doEvaluate(Product var1);

    public static class SettlementTermsLeg2Default
    extends SettlementTermsLeg2 {
        @Override
        protected SettlementTerms.SettlementTermsBuilder doEvaluate(Product product) {
            SettlementTerms.SettlementTermsBuilder settlementTerms = SettlementTerms.builder();
            return this.assignOutput(settlementTerms, product);
        }

        protected SettlementTerms.SettlementTermsBuilder assignOutput(SettlementTerms.SettlementTermsBuilder settlementTerms, Product product) {
            Boolean boolean1;
            Boolean boolean0;
            settlementTerms = ExpressionOperators.exists((Mapper)MapperS.of((Object)this.interestRateLeg2.evaluate(product)).map("getSettlementTerms", interestRatePayout -> interestRatePayout.getSettlementTerms())).getOrDefault(Boolean.valueOf(false)) != false ? (SettlementTerms.SettlementTermsBuilder)this.toBuilder((RosettaModelObject)MapperS.of((Object)this.interestRateLeg2.evaluate(product)).map("getSettlementTerms", interestRatePayout -> interestRatePayout.getSettlementTerms()).get()) : ((boolean0 = this.isFXSwap.evaluate(product)) != null && boolean0 != false ? (SettlementTerms.SettlementTermsBuilder)this.toBuilder((RosettaModelObject)MapperS.of((Object)this.fXNearLeg.evaluate(product)).map("getSettlementTerms", forwardPayout -> forwardPayout.getSettlementTerms()).get()) : ((boolean1 = this.isCommoditySwap.evaluate(product)) != null && boolean1 != false ? (SettlementTerms.SettlementTermsBuilder)this.toBuilder((RosettaModelObject)MapperS.of((Object)this.commodityLeg2.evaluate(product)).map("getSettlementTerms", commodityPayout -> commodityPayout.getSettlementTerms()).get()) : (ComparisonResult.of((Mapper)MapperS.of((Object)this.isCommodityForward.evaluate(product))).and(ExpressionOperators.areEqual((Mapper)ExpressionOperators.exists((Mapper)MapperS.of((Object)((ForwardPayout)MapperS.of((Object)this.economicTermsForProduct.evaluate(product)).map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getForwardPayout", payout -> payout.getForwardPayout()).get()))), (Mapper)MapperS.of((Object)false), (CardinalityOperator)CardinalityOperator.All)).getOrDefault(Boolean.valueOf(false)) != false ? (SettlementTerms.SettlementTermsBuilder)this.toBuilder((RosettaModelObject)MapperS.of((Object)((ForwardPayout)MapperS.of((Object)this.economicTermsForProduct.evaluate(product)).map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getForwardPayout", payout -> payout.getForwardPayout()).get())).map("getSettlementTerms", forwardPayout -> forwardPayout.getSettlementTerms()).get()) : (ComparisonResult.of((Mapper)MapperS.of((Object)this.isEquitySwapProduct.evaluate(product))).and(ExpressionOperators.exists((Mapper)MapperS.of((Object)((InterestRatePayout)MapperS.of((Object)this.economicTermsForProduct.evaluate(product)).map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getInterestRatePayout", payout -> payout.getInterestRatePayout()).get())).map("getSettlementTerms", interestRatePayout -> interestRatePayout.getSettlementTerms()))).getOrDefault(Boolean.valueOf(false)) != false ? (SettlementTerms.SettlementTermsBuilder)this.toBuilder((RosettaModelObject)MapperS.of((Object)((InterestRatePayout)MapperS.of((Object)this.economicTermsForProduct.evaluate(product)).map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getInterestRatePayout", payout -> payout.getInterestRatePayout()).get())).map("getSettlementTerms", interestRatePayout -> interestRatePayout.getSettlementTerms()).get()) : (ExpressionOperators.exists((Mapper)MapperS.of((Object)this.economicTermsForProduct.evaluate(product)).map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getPerformancePayout", payout -> payout.getPerformancePayout()).map("getSettlementTerms", performancePayout -> performancePayout.getSettlementTerms())).getOrDefault(Boolean.valueOf(false)) != false ? (SettlementTerms.SettlementTermsBuilder)this.toBuilder((RosettaModelObject)MapperS.of((Object)((PerformancePayout)MapperS.of((Object)this.economicTermsForProduct.evaluate(product)).map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getPerformancePayout", payout -> payout.getPerformancePayout()).get())).map("getSettlementTerms", performancePayout -> performancePayout.getSettlementTerms()).get()) : null)))));
            return Optional.ofNullable(settlementTerms).map(o -> o.prune()).orElse(null);
        }
    }
}

