/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.common.trade.basket.reports;

import cdm.base.math.CapacityUnitEnum;
import cdm.base.math.FinancialUnitEnum;
import cdm.base.math.WeatherUnitEnum;
import cdm.base.math.metafields.ReferenceWithMetaNonNegativeQuantitySchedule;
import cdm.product.template.BasketConstituent;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.standards.iso.functions.CapacityUnitToISO20022UnitOfMeasure;
import drr.standards.iso.functions.FinancialUnitToISO20022UnitOfMeasure;
import drr.standards.iso.functions.WeatherUnitToISO20022UnitOfMeasure;
import javax.inject.Inject;

@ImplementedBy(value=BasketConstituentUnitOfMeasureRuleDefault.class)
public abstract class BasketConstituentUnitOfMeasureRule
implements ReportFunction<BasketConstituent, String> {
    @Inject
    protected CapacityUnitToISO20022UnitOfMeasure capacityUnitToISO20022UnitOfMeasure;
    @Inject
    protected FinancialUnitToISO20022UnitOfMeasure financialUnitToISO20022UnitOfMeasure;
    @Inject
    protected WeatherUnitToISO20022UnitOfMeasure weatherUnitToISO20022UnitOfMeasure;

    public String evaluate(BasketConstituent input) {
        String output = this.doEvaluate(input);
        return output;
    }

    protected abstract String doEvaluate(BasketConstituent var1);

    public static class BasketConstituentUnitOfMeasureRuleDefault
    extends BasketConstituentUnitOfMeasureRule {
        @Override
        protected String doEvaluate(BasketConstituent input) {
            String output = null;
            return this.assignOutput(output, input);
        }

        protected String assignOutput(String output, BasketConstituent input) {
            MapperS thenArg = MapperS.of((Object)input).mapSingleToItem(item -> {
                ReferenceWithMetaNonNegativeQuantitySchedule referenceWithMetaNonNegativeQuantitySchedule = (ReferenceWithMetaNonNegativeQuantitySchedule)item.mapC("getQuantity", basketConstituent -> basketConstituent.getQuantity()).get();
                return (referenceWithMetaNonNegativeQuantitySchedule == null ? MapperS.ofNull() : MapperS.of((Object)referenceWithMetaNonNegativeQuantitySchedule.getValue())).map("getUnit", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getUnit());
            });
            output = (String)thenArg.mapSingleToItem(item -> {
                if (ExpressionOperators.exists((Mapper)item.map("getCapacityUnit", unitType -> unitType.getCapacityUnit())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return MapperS.of((Object)this.capacityUnitToISO20022UnitOfMeasure.evaluate((CapacityUnitEnum)item.map("getCapacityUnit", unitType -> unitType.getCapacityUnit()).get()));
                }
                if (ExpressionOperators.exists((Mapper)item.map("getWeatherUnit", unitType -> unitType.getWeatherUnit())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return MapperS.of((Object)this.weatherUnitToISO20022UnitOfMeasure.evaluate((WeatherUnitEnum)item.map("getWeatherUnit", unitType -> unitType.getWeatherUnit()).get()));
                }
                if (ExpressionOperators.exists((Mapper)item.map("getFinancialUnit", unitType -> unitType.getFinancialUnit())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return MapperS.of((Object)this.financialUnitToISO20022UnitOfMeasure.evaluate((FinancialUnitEnum)item.map("getFinancialUnit", unitType -> unitType.getFinancialUnit()).get()));
                }
                return MapperS.ofNull();
            }).get();
            return output;
        }
    }
}

