/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.common.trade.datetime.reports;

import cdm.product.qualification.functions.Qualify_InterestRate_Fra;
import cdm.product.template.EconomicTerms;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.records.Date;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.base.trade.ReportableEventBase;
import drr.base.trade.functions.PositionForEvent;
import drr.base.trade.functions.ProductForEvent;
import drr.base.trade.functions.TradeForEvent;
import drr.regulation.common.TransactionReportInstruction;
import java.time.LocalDate;
import javax.inject.Inject;

@ImplementedBy(value=EffectiveDateRuleDefault.class)
public abstract class EffectiveDateRule
implements ReportFunction<TransactionReportInstruction, Date> {
    @Inject
    protected drr.standards.iosco.cde.version3.datetime.reports.EffectiveDateRule effectiveDateRule;
    @Inject
    protected PositionForEvent positionForEvent;
    @Inject
    protected ProductForEvent productForEvent;
    @Inject
    protected Qualify_InterestRate_Fra qualify_InterestRate_Fra;
    @Inject
    protected TradeForEvent tradeForEvent;

    public Date evaluate(TransactionReportInstruction input) {
        Date output = this.doEvaluate(input);
        return output;
    }

    protected abstract Date doEvaluate(TransactionReportInstruction var1);

    public static class EffectiveDateRuleDefault
    extends EffectiveDateRule {
        @Override
        protected Date doEvaluate(TransactionReportInstruction input) {
            Date output = null;
            return this.assignOutput(output, input);
        }

        protected Date assignOutput(Date output, TransactionReportInstruction input) {
            output = (Date)MapperS.of((Object)input).mapSingleToItem(item -> {
                Boolean _boolean = this.qualify_InterestRate_Fra.evaluate((EconomicTerms)MapperS.of((Object)this.productForEvent.evaluate((ReportableEventBase)item.get())).map("getContractualProduct", product -> product.getContractualProduct()).map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).get());
                if (_boolean != null && _boolean.booleanValue()) {
                    if (ExpressionOperators.exists((Mapper)MapperS.of((Object)this.tradeForEvent.evaluate((ReportableEventBase)item.get()))).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                        return MapperS.of((Object)this.tradeForEvent.evaluate((ReportableEventBase)item.get())).map("getTradeDate", trade -> trade.getTradeDate()).map("Type coercion", fieldWithMetaDate -> fieldWithMetaDate == null ? null : fieldWithMetaDate.getValue());
                    }
                    if (ExpressionOperators.exists((Mapper)MapperS.of((Object)this.positionForEvent.evaluate((ReportableEventBase)item.get()))).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                        return MapperS.of((Object)this.positionForEvent.evaluate((ReportableEventBase)item.get())).map("getOpenDateTime", counterpartyPosition -> counterpartyPosition.getOpenDateTime()).map("Date", dt -> Date.of((LocalDate)dt.toLocalDate()));
                    }
                    return MapperS.ofNull();
                }
                return MapperS.of((Object)this.effectiveDateRule.evaluate((TransactionReportInstruction)item.get()));
            }).get();
            return output;
        }
    }
}

