/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.common.trade.party.functions;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import drr.regulation.common.CorporateSector;
import drr.regulation.common.NatureOfPartyEnum;
import drr.regulation.common.functions.GetFinancialCorporateSector;
import drr.regulation.common.functions.GetNonFinancialCorporateSector;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;

@ImplementedBy(value=ExtractPartySectorDefault.class)
public abstract class ExtractPartySector
implements RosettaFunction {
    @Inject
    protected GetFinancialCorporateSector getFinancialCorporateSector;
    @Inject
    protected GetNonFinancialCorporateSector getNonFinancialCorporateSector;

    public List<String> evaluate(NatureOfPartyEnum natureOfParty, List<? extends CorporateSector> corporateSector) {
        List<String> sector = this.doEvaluate(natureOfParty, corporateSector);
        return sector;
    }

    protected abstract List<String> doEvaluate(NatureOfPartyEnum var1, List<? extends CorporateSector> var2);

    public static class ExtractPartySectorDefault
    extends ExtractPartySector {
        @Override
        protected List<String> doEvaluate(NatureOfPartyEnum natureOfParty, List<? extends CorporateSector> corporateSector) {
            if (corporateSector == null) {
                corporateSector = Collections.emptyList();
            }
            ArrayList<String> sector = new ArrayList<String>();
            return this.assignOutput(sector, natureOfParty, corporateSector);
        }

        protected List<String> assignOutput(List<String> sector, NatureOfPartyEnum natureOfParty, List<? extends CorporateSector> corporateSector) {
            sector = ExpressionOperators.areEqual((Mapper)MapperS.of((Object)((Object)natureOfParty)), (Mapper)MapperS.of((Object)((Object)NatureOfPartyEnum.NON_FINANCIAL)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)) != false ? this.getNonFinancialCorporateSector.evaluate(MapperC.of(corporateSector).mapC("getNonFinancialSector", _corporateSector -> _corporateSector.getNonFinancialSector()).getMulti()) : (ExpressionOperators.areEqual((Mapper)MapperS.of((Object)((Object)natureOfParty)), (Mapper)MapperS.of((Object)((Object)NatureOfPartyEnum.FINANCIAL)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)) != false ? this.getFinancialCorporateSector.evaluate(MapperC.of(corporateSector).mapC("getFinancialSector", _corporateSector -> _corporateSector.getFinancialSector()).getMulti()) : Collections.emptyList());
            return sector;
        }
    }
}

