/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.csa.rewrite.trade.functions;

import cdm.product.asset.CommodityPayout;
import cdm.product.template.Product;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import drr.base.qualification.product.functions.IsCommoditySwapFloatFloat;
import drr.base.trade.functions.EconomicTermsForProduct;
import drr.regulation.csa.rewrite.trade.functions.CommodityBasisLeg1;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=CommodityLeg1Default.class)
public abstract class CommodityLeg1
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected CommodityBasisLeg1 commodityBasisLeg1;
    @Inject
    protected drr.regulation.common.functions.CommodityLeg1 commodityLeg1;
    @Inject
    protected EconomicTermsForProduct economicTermsForProduct;
    @Inject
    protected IsCommoditySwapFloatFloat isCommoditySwapFloatFloat;

    public CommodityPayout evaluate(Product product) {
        CommodityPayout _commodityLeg1;
        CommodityPayout.CommodityPayoutBuilder commodityLeg1Builder = this.doEvaluate(product);
        if (commodityLeg1Builder == null) {
            _commodityLeg1 = null;
        } else {
            _commodityLeg1 = commodityLeg1Builder.build();
            this.objectValidator.validate(CommodityPayout.class, (RosettaModelObject)_commodityLeg1);
        }
        return _commodityLeg1;
    }

    protected abstract CommodityPayout.CommodityPayoutBuilder doEvaluate(Product var1);

    protected abstract MapperC<? extends CommodityPayout> commodityPayouts(Product var1);

    public static class CommodityLeg1Default
    extends CommodityLeg1 {
        @Override
        protected CommodityPayout.CommodityPayoutBuilder doEvaluate(Product product) {
            CommodityPayout.CommodityPayoutBuilder _commodityLeg1 = CommodityPayout.builder();
            return this.assignOutput(_commodityLeg1, product);
        }

        protected CommodityPayout.CommodityPayoutBuilder assignOutput(CommodityPayout.CommodityPayoutBuilder _commodityLeg1, Product product) {
            Boolean _boolean = this.isCommoditySwapFloatFloat.evaluate(product);
            _commodityLeg1 = _boolean != null && _boolean != false ? (CommodityPayout.CommodityPayoutBuilder)this.toBuilder((RosettaModelObject)this.commodityBasisLeg1.evaluate(product)) : (CommodityPayout.CommodityPayoutBuilder)this.toBuilder((RosettaModelObject)this.commodityLeg1.evaluate(product));
            return Optional.ofNullable(_commodityLeg1).map(o -> o.prune()).orElse(null);
        }

        @Override
        protected MapperC<? extends CommodityPayout> commodityPayouts(Product product) {
            return MapperS.of((Object)this.economicTermsForProduct.evaluate(product)).map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getCommodityPayout", payout -> payout.getCommodityPayout());
        }
    }
}

